<html lang="en">

<head>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <!-- <script async src="https://www.googletagmanager.com/gtag/js?id=G-Q8EDCFG2DG"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', 'G-Q8EDCFG2DG');
    </script> -->
    <title>Faculty Login Page - EDJ</title>
    <meta name="keywords" content="EDJ " />
    <meta name="description" content="EDJ ">
    <meta name="author" content="EDJ">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <!-- Favicon -->
    <link href="" id="faviconImg" rel="shortcut icon" />

    <div class="loader"></div>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="" id="fontawesomeFree">

    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">

    <!-- Tempusdominus Bbootstrap 4 -->
    <link rel="stylesheet" href="" id="tempusdominusBootstrap">

    <!-- Select2 -->
    <link rel="stylesheet" href="" id="select2MinCss">
    <link rel="stylesheet" href="" id="select2Bootstrap">

    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="" id="iCheckBootstrap">
    <!-- JQVMap -->
    <link rel="stylesheet" href="" id="jqvmapMicCss">
    <!-- Theme style -->
    <link rel="stylesheet" href="" id="adminlteMinCss">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="" id="overlayScrollbarsMinCss">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="" id="daterangepickerMinCss">
    <!-- summernote -->
    <link rel="stylesheet" href="" id="summernoteMinCss">
    <!-- custom css -->
    <link rel="stylesheet" href="" id="customCss">

    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <!-- to get user device info -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.4/jquery.min.js"></script>
    <style>
        #password_rules ul li {
            color: white;
        }

        #password_rules ul li.complete {
            color: #5DB406;
        }
    </style>
</head>

<?php
include 'common/connectToDB.php';
$APIkeyForUserDeviceInfo = '';
$sql = "SELECT * FROM seriesnumber WHERE seriesName = 'APIkeyForUserDeviceInfo';";
$result = mysqli_query($conn, $sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $APIkeyForUserDeviceInfo = $row['seriesValue'];
    }
}
?>

<body class="hold-transition login-page">
    <div class="login-box" id="loginPagecontent" hidden>
        <div class="login-logo">
            <p><b>EDJ</b><br>FACULTY PANEL</p>
        </div>
        <div class="signInContent">
            <div class="card-body login-card-body" id='signInContent'>
                <p class="login-box-msg iconClr">Sign in to start your session</p>
                <div>
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" placeholder="Enter Email Id" id="username">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope iconClr"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="password" class="form-control" placeholder="Enter Password" id="password">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-eye pointer iconClr" onclick="togalPassword(document.getElementById('password'))" style.bordercolor="red"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <input type="button" class="btn btn-primary btn-block" value="Sign In" onclick="loginToSystem()" />
                        </div>
                    </div>
                    <div class="row mt-3" style="display: flex; align-items:center; justify-content: center;">
                        <a href="#" class='iconClr' onclick="openForm();">Forget your Password?</a>
                    </div>
                    <div class="row mt-3" style="display: flex; align-items:center; justify-content: center;">
                        <a href="#" class='iconClr' onclick="openForm();">Reset Password</a>
                    </div>
                    <p class="mb-2" id="successMessage" style="color: green; font-size: 1em; text-align: center;">
                    </p>
                    <p class="mb-0" id="errorMessage" style="color: red; font-size: 1em; text-align: center;">
                    </p>
                    <span id="bDetails">
                    </span>
                </div>
            </div>
        </div>
        <div class="ForgettenyourPassword" id='ForgettenyourPassword' hidden>
            <div class="card-body login-card-body">
                <div class="col-md-12">
                    <div class="row">
                        <i class="fas fa-arrow-alt-circle-left" id='back' onclick="backToLoginDiv()"></i>
                        <p class="login-box-msg">Enter your registered Email-Id</p>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="text" class="form-control" name="userEmailId" id="userEmailId" placeholder="Enter Email-Id here...">
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                <p class="mb-0" id="successMessageSendOtp" style="color: green; font-size: 1em; text-align: center;">
                </p>
                <p class="mb-0" id="errorMessageSendOtp" style="color: red; font-size: 1em; text-align: center;">
                </p>
                <div class="card-footer tAC">
                    <input type="button" class="btn btn-primary btn-block" value="Generate OTP" id='generateOtpButton' onclick="validateEmailId()" style="margin-left: 25%;margin-right: 25%;width: 50%;" />
                </div>
            </div>
        </div>
        <div class="card" id='EnteryourOTP' hidden>
            <div class="card-body login-card-body">
                <div class="col-md-12">
                    <div class="row">
                        <p class="login-box-msg">OTP Verification Page</p>
                        <input type="button" class="btn btn-primary btn-block" style="float: right;width: 35%;" value="Resend OTP" onclick="resendOtp()" hidden id="resendOtp" />
                    </div>
                </div>
                <div class="col-md-12">
                    <p class="mb-2" id="successMessageEnterOtp" style="color:white; font-size: 1em; text-align: center;">
                    </p>
                    <div class="row">
                        <div class="col-6">
                            <div><i class="fas fa-clock" style="color: #1f53e7;margin-left: 103px;width: 123%;margin-bottom:20px"> <span id="timer" style=font-size:larger;></span></div></i>
                        </div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="number" class="form-control" name="Enter OTP" id="userEnteredOTP" placeholder="Enter OTP">
                </div>
                <div class="card-footer tAC">
                    <input type="button" class="btn btn-primary btn-block" value="Verify OTP" onclick="otpVerify()" style="margin-left: 25%;margin-right: 25%;width: 50%;" />
                </div>
                <p class="mb-2" id="errorMessageEnterOtp" style="color: red; font-size: 1em; text-align: center;">
                </p>
                <span id="bDetails">
                </span>
            </div>
        </div>
        <div class="card" id='Resetpassword' hidden>
            <div class="card-body login-card-body">
                <p class="login-box-msg">Set New Password</p>
                <div class="col-md-12">
                    <div class="input-group mb-3">
                        <input type="password" class="form-control validate passwordConfirm" placeholder="Enter New Password" id="newPassword" value="" onkeypress="validateInputs()">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-eye pointer" onclick="togalPassword(document.getElementById('newPassword'))"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="text" class="form-control validate passwordConfirm" placeholder="Confirm New Password" id="confirmPassword" value="" onkeypress="validateInputs()">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-eye pointer" onclick="togalPassword(document.getElementById('confirmPassword'))"></span>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer tAC">
                        <input type="button" class="btn btn-primary btn-block" value="UPDATE" onclick="setNewPassWord()" id="saveButton" style="margin-left: 25%;margin-right: 25%;width: 50%;" newPassword />
                    </div>
                    <div id="password_rules">
                        <p>Passwords must meet these requirements:</p>
                        <ul>
                            <li class="password_uppercase">At least 1 uppercase letter</li>
                            <li class="password_number">At least one number</li>
                            <li class="password_length">At least 7 characters</li>
                            <li class="password_match">Password and Confirmation must match</li>
                        </ul>
                    </div>
                    <p class="mb-2" id="errorMessageResetPassword" style="color: red; font-size: 1em; text-align: center;">
                    </p>
                    <p class="mb-2" id="successMessageResetPassword" style="color: green; font-size: 1em; text-align: center;">
                    </p>
                    <span id="bDetails">
                    </span>
                </div>
            </div>
        </div>
        <div class="card" id='clicklogin' hidden>
            <div class="card-body login-card-body">
                <div class="col-md-12">
                    <p class="login-box-msg"> Your Password has been updated successfully.</p>
                </div>
                <p class="mb-0" id="clickLoginSuccessMessage" style="color: green; font-size: 1em; text-align: center;">
                </p>
                <div class="card-footer tAC">
                    <input type="button" class="btn btn-primary btn-block" value="Click Here To Login" onclick="clickHear()" style="margin-left: 25%;margin-right: 25%;width: 50%;" />
                </div>
            </div>
        </div>
    </div>
    <script src="../plugins/jquery/jquery.min.js"></script>
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../dist/js/adminlte.min.js"></script>

</body>

</html>

<script>
    $(window).on('load', function() {
        $(".loader").fadeOut("slow");
        document.getElementById('loginPagecontent').hidden = false;
    });
</script>

<script type="text/javascript">
    function checkOnline() {
        if (window.navigator.onLine) {} else {
            alert("Disonnected to Internet.");
            return false;
        }
    }

    function togalPassword(element) {
        if (element.type === "password") {
            element.type = "text";
        } else {
            element.type = "password";
        }
    }
    var uName = '',
        pass = '';

    function setHeaders() {
        uName = '',
            pass = '';

        uName = document.getElementById("username").value.trim();
        pass = document.getElementById("password").value.trim();
        return 1;
    }

    function showError(id, color, message) {
        document.getElementById(id).style.backgroundColor = color;
        document.getElementById('errorMessage').innerHTML = message;
    }

    function validateEmail(email) {
        const re =
            /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
        return re.test(String(email).toLowerCase());
    }

    function formValidation() {
        if (setHeaders() == 0) return 0;

        if (uName == '') {
            showError('username', '#ff6666', "Username cannot be blank");
            return 0;
        } else showError('username', '', '');

        if (!validateEmail(uName)) {
            showError('username', '#ff6666', "UserName is not in correct format. Please correct it.");
            return 0;
        } else showError('username', '', '');

        if (pass == '') {
            showError('password', '#ff6666', "Password cannot be blank");
            return 0;
        } else showError('password', '', '');
        return 1;
    }

    function loginToSystem() {
        if (formValidation() == 0) return;
        else {
            document.getElementById('successMessage').innerHTML = "Checking the credentials.. Please wait..";
            $.post('login_process.php', {
                'userNameEdj': uName,
                'passEdj': pass,
                'userDeviceInfo': userDeviceInfo,
            }, function(data) {
                dataArray = data.split('::');
                document.getElementById('successMessage').innerHTML = '';
                console.log(dataArray);
                if (dataArray[0] == "ACTIVE" && dataArray[1] == "FALSE") {
                    window.location.href = 'c/HA/index';

                } else if (dataArray[0] == "PENDING" && dataArray[1] == "FALSE") {
                    window.location.href = 'c/HA/index';
                } else if (dataArray[0] == "TERMINATE" && dataArray[1] == "FALSE") {
                    window.location.href = 'c/HA/index';
                } else if (dataArray[0] == "TERMINATE" && dataArray[1] == "TRUE") {
                    $('#errorMessage').html('Your Access to EDJ Platform is permanently Terminated..');

                } else if (dataArray[0] == "RELIEVE" && dataArray[1] == "FALSE") {
                    window.location.href = 'c/HA/index';
                } else if (dataArray[0] == "RELIEVE" && dataArray[1] == "TRUE") {
                    $('#errorMessage').html('Your Access to EDJ Platform is de-activated..');
                } else if (dataArray[0] == "BLOCK" && dataArray[1] == "FALSE") {
                    $('#errorMessage').html('Your Access to EDJ Platform is Blocked.');
                } else if (dataArray[0] == "BLOCKED" && dataArray[1] == "FALSE") {
                    $('#errorMessage').html('Your Access to EDJ Platform is Blocked.');
                } else {
                    $('#errorMessage').html(data);
                }
            });
        }
    }
</script>


<script>
    // on Enter key press
    var uNameEvent = document.getElementById('username');
    uNameEvent.onkeyup = function(e) {
        if (e.keyCode == 13) {
            loginToSystem();
        }
    }

    var uPassEvent = document.getElementById('password');
    uPassEvent.onkeyup = function(e) {
        if (e.keyCode == 13) {
            loginToSystem();
        }
    }
    // forget password
    function showErrorSendOtp(id, color, message) {
        document.getElementById(id).style.backgroundColor = color;
        document.getElementById('errorMessageSendOtp').innerHTML = message;
    }

    function showErrorEnteredOtp(id, color, message) {
        document.getElementById(id).style.backgroundColor = color;
        document.getElementById('errorMessageEnterOtp').innerHTML = message;
    }

    function openForm() {
        document.getElementById('signInContent').hidden = true;
        document.getElementById('ForgettenyourPassword').hidden = false;
    }

    function backToLoginDiv() {
        document.getElementById('errorMessage').innerHTML = '';
        document.getElementById('ForgettenyourPassword').hidden = true;
        document.getElementById('signInContent').hidden = false;
    }

    function validateEmailId() {
        document.getElementById('generateOtpButton').disabled = true;
        userEmailId = document.getElementById('userEmailId').value.trim();
        var otp = Math.floor((Math.random() * 1000000) + 1);
        var email = userEmailId
        var userEmailIdMasked = "";
        for (i = 0; i < email.length; i++) {
            if (i > 2 && i < email.indexOf("@")) {
                userEmailIdMasked += "*";
            } else {
                userEmailIdMasked += email[i];
            }
        }
        if (userEmailId == '') {
            showErrorSendOtp('userEmailId', '#ff6666', " Email Id cannot be blank");
            document.getElementById('generateOtpButton').disabled = false;
            return 0;
        } else showErrorSendOtp('userEmailId', '', '');

        document.getElementById('successMessageEnterOtp').innerHTML = 'OTP send at ' + userEmailIdMasked;
        document.getElementById('successMessageSendOtp').innerHTML =
            'Please wait until we send OTP to your registered Email Id';

        var saveFlag = 'sendOTP';
        $.post('useremail.php', {
            'saveFlag': saveFlag,
            'validOtp': otp,
            'userEmailId': userEmailId,
        }, function(data) {
            dataInfo = data.split(':::');
            if (dataInfo[0] == 'false') {
                showErrorSendOtp('userEmailId', '#ff6666', " Oops! We weren't able to locate any user with " +
                    userEmailId + " email");
                document.getElementById('generateOtpButton').disabled = false;
                document.getElementById('successMessageSendOtp').innerHTML = '';
                return 0;
            } else if (dataInfo[0] == 'true') {
                showErrorSendOtp('userEmailId', '', '');
                document.getElementById('successMessageSendOtp').innerHTML = '';
                document.getElementById('ForgettenyourPassword').hidden = true
                document.getElementById('EnteryourOTP').hidden = false;
                timer(180); //timer(180)
            }
        });
    }

    function resendOtp() {
        // validateEmailId();
        // setHeadersNewPassword() == 0
        document.getElementById('resendOtp').disabled = true;
        userEmailId = document.getElementById('userEmailId').value.trim();
        var email = userEmailId
        var userEmailIdMasked = "";
        for (i = 0; i < email.length; i++) {
            if (i > 2 && i < email.indexOf("@")) {
                userEmailIdMasked += "*";
            } else {
                userEmailIdMasked += email[i];
            }
        }
        var saveFlag = 'resendOtp';
        var otp = Math.floor((Math.random() * 1000000) + 1);
        document.getElementById('successMessageEnterOtp').innerHTML = "Please wait until we send OTP to your registered Email Id";
        $.post('useremail.php', {
            'saveFlag': saveFlag,
            'otp': otp,
            'userEmailId': userEmailId,
        }, function(data) {
            document.getElementById('successMessageEnterOtp').innerHTML = 'OTP Resend at ' + userEmailIdMasked;
            document.getElementById('resendOtp').disabled = false;
            document.getElementById('resendOtp').hidden = true;
            timer(180); //timer(180)
            dataInfo = data.split(':::');
        });
    }

    let timerOn = true;

    function timer(remaining) {
        var s = remaining;
        s = s < 10 ? '0' + s : s;
        document.getElementById('timer').innerHTML = s + ' Sec';
        remaining -= 1;
        if (remaining >= 0 && timerOn) {
            setTimeout(function() {
                timer(remaining);
            }, 1000);
            return;
        }
        if (!timerOn) {
            return;
        }
        document.getElementById("resendOtp").hidden = false;
        // dataInfo[1] = '';
    }

    // function setHeadersNewPassword() {
    //     userEmailId = '';
    //     // passwordd = '';
    //     // otpCreationTime = '';
    //     // otpSubmissionTime = '';
    //     userEmailId = document.getElementById("userEmailId").value.trim();
    //     userEnteredOtp = document.getElementById("userEnteredOTP").value.trim();
    //     // passwordd = document.getElementById("passwordd").value.trim();
    //     return 1;
    // }

    function otpVerify() {
        // if (setHeadersNewPassword() == 0) return 0;
        userEmailId = document.getElementById('userEmailId').value.trim();
        var userEnteredOtp = document.getElementById('userEnteredOTP').value;
        if (userEnteredOtp == '') {
            showErrorEnteredOtp('userEnteredOTP', '#ff6666', "OTP cannot be blank");
            return 0;
        } else showErrorEnteredOtp('userEnteredOTP', '', '');
        if (userEnteredOtp.length != '' && userEnteredOtp.length != 6) {
            showErrorEnteredOtp('errorMessage', '', "OTP should be of 6 digits");
            return 0;
        }
        if (dataInfo[1] != userEnteredOtp) {
            showErrorEnteredOtp('userEnteredOTP', '#ff6666', "Invalid OTP");
            return 0;
        } else {
            showErrorEnteredOtp('userEnteredOTP', '', '');
            timerOn = false;
            document.getElementById('successMessageEnterOtp').innerHTML = '';
        }
        document.getElementById('EnteryourOTP').hidden = true;
        document.getElementById('Resetpassword').hidden = false;
    }

    function validateInputs() {
        // if (setHeaders1() == 0) return 0;
        userEmailId = document.getElementById('userEmailId').value;
        var userEnteredOtp = document.getElementById('userEnteredOTP').value.trim();
        var resetpswd = document.getElementById('newPassword').value.trim();
        var confpswd = document.getElementById('confirmPassword').value.trim();
        var validateInput = $('input.validate');
        // var password = document.getElementById('newPassword').value.trim();
        // conf = document.getElementById('confirmPassword').value.trim();
        all_pass = true;
        var uppercase = resetpswd.match(/[A-Z]/),
            number = resetpswd.match(/[0-9]/);

        if (resetpswd.length < 7) {
            $('.password_length').removeClass('complete');
            all_pass = false;

        } else $('.password_length').addClass('complete');
        if (uppercase) $('.password_uppercase').addClass('complete');

        else {
            $('.password_uppercase').removeClass('complete');
            all_pass = false;
        }
        if (number) $('.password_number').addClass('complete');
        else {
            $('.password_number').removeClass('complete');
            all_pass = false
            // return 0;   
        }
        if (resetpswd == confpswd && resetpswd != '') $('.password_match').addClass('complete');
        else {

            $('.password_match').removeClass('complete')
            all_pass = false;
            document.getElementById('errorMessageResetPassword').hidden = false;
            document.getElementById('saveButton').hidden = false;
        }
        // document.getElementById('clicklogin').hidden = true;
    }

    var APIkeyForUserDeviceInfo = '';
    $(document).ready(function() {
        APIkeyForUserDeviceInfo = '<?php echo $APIkeyForUserDeviceInfo ?>';
        userDeviceInfo = [];
        $.getJSON('https://ipgeolocation.abstractapi.com/v1/?api_key=' + APIkeyForUserDeviceInfo, function(data) {
            userDeviceInfo = [];
            userDeviceInfo.push(data);
            console.log(userDeviceInfo);
        });
        localStorage.setItem("APIkeyForUserDeviceInfo", APIkeyForUserDeviceInfo);
        var validateInput = $('input.validate');
        validateInput.each(validateInputs).on('keyup', validateInputs);
        validateInputs();
    });

    function setNewPassWord() {
        userEmailId = document.getElementById('userEmailId').value;
        var userEnteredOtp = document.getElementById('userEnteredOTP').value.trim();
        var resetpswd = document.getElementById('newPassword').value.trim();
        var confpswd = document.getElementById('confirmPassword').value.trim();
        var validateInput = $('input.validate');

        conf = document.getElementById('confirmPassword').value;
        all_pass = true;

        var uppercase = resetpswd.match(/[A-Z]/),
            number = resetpswd.match(/[0-9]/);

        if (resetpswd == conf && resetpswd != '') $('.password_match').addClass('complete');
        else {
            $('.password_match').removeClass('complete')
            all_pass = false;
            document.getElementById('saveButton').hidden = false;
            return 0;
        }
        var saveFlag = 'setNewPassword';
        document.getElementById('saveButton').disabled = true;
        // console.log('resetPassword',resetpswd);
        document.getElementById('successMessageResetPassword').innerHTML = 'updating please wait....';
        $.post('useremail.php', {
            'saveFlag': saveFlag,
            'password': resetpswd,
            'userEmailId': userEmailId,
        }, function(data) {
            document.getElementById('successMessageResetPassword').innerHTML = 'Password Updated Successfully.';
            document.getElementById('Resetpassword').hidden = true;
            document.getElementById('saveButton').disabled = false;
            document.getElementById("clicklogin").hidden = false;
        });
    }

    function clickHear() {
        // document.getElementById('clicklogin').hidden = true;
        // document.getElementById('signInContent').hidden = false;
        location.reload();
    }

    var uemailEvent = document.getElementById('userEmailId');
    uemailEvent.onkeyup = function(e) {
        if (e.keyCode == 13) {
            validateEmailId();
        }
    }

    var uotpEvent = document.getElementById('userEnteredOTP');
    uotpEvent.onkeyup = function(e) {
        if (e.keyCode == 13) {
            otpVerify();
        }
    }

    var upassEvent = document.getElementById('newPassword');
    upassEvent.onkeyup = function(e) {
        if (e.keyCode == 13) {
            setNewPassWord();
        }
    }

    var uconfirmpassEvent = document.getElementById('confirmPassword');
    uconfirmpassEvent.onkeyup = function(e) {
        if (e.keyCode == 13) {
            setNewPassWord();
        }
    }
    // forget password

    var dots = "";
    var faviconImg = dots + "../dist/img/kalash-logo-ld.jpg";
    var fontawesomeFree = dots + "../plugins/fontawesome-free/css/all.min.css";
    var iCheckBootstrap = dots + "../plugins/icheck-bootstrap/icheck-bootstrap.min.css";
    var adminlteMinCss = dots + "../dist/css/adminlte.min.css";
    var tempusdominusBootstrap = dots + "../plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css";
    var jqvmapMicCss = dots + "../plugins/jqvmap/jqvmap.min.css";
    var overlayScrollbarsMinCss = dots + "../plugins/overlayScrollbars/css/OverlayScrollbars.min.css";
    var daterangepickerMinCss = dots + "../plugins/daterangepicker/daterangepicker.css";
    var summernoteMinCss = dots + "../plugins/summernote/summernote-bs4.css";
    var customCss = dots + "../dist/css/custom.css";
    var select2MinCss = dots + "../plugins/select2/css/select2.min.css";
    var select2Bootstrap = dots + "../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css";

    var dataTableCss = dots + "assets/css/datatables.css";
    var jqueryMinJs = dots + "../plugins/jquery/jquery.min.js";
    var jqueryUiMinJS = dots + "../plugins/jquery-ui/jquery-ui.js";
    var jqueryVmapMinJS = dots + "../plugins/jqvmap/jquery.vmap.min.js";
    var jqueryMapsMinJS = dots + "../plugins/jqvmap/maps/jquery.vmap.usa.js";
    var jqueryKnobMinJS = dots + "../plugins/jquery-knob/jquery.knob.min.js";
    // var jqueryKnobMinJS = dots + "";

    // console.log(animateMin);
    if (document.getElementById("faviconImg")) document.getElementById("faviconImg").href = faviconImg;
    if (document.getElementById("fontawesomeFree")) document.getElementById("fontawesomeFree").href = fontawesomeFree;
    if (document.getElementById("iCheckBootstrap")) document.getElementById("iCheckBootstrap").href = iCheckBootstrap;
    if (document.getElementById("adminlteMinCss")) document.getElementById("adminlteMinCss").href = adminlteMinCss;
    if (document.getElementById("tempusdominusBootstrap")) document.getElementById("tempusdominusBootstrap").href =
        tempusdominusBootstrap;
    if (document.getElementById("jqvmapMicCss")) document.getElementById("jqvmapMicCss").href = jqvmapMicCss;
    if (document.getElementById("overlayScrollbarsMinCss")) document.getElementById("overlayScrollbarsMinCss").href =
        overlayScrollbarsMinCss;
    if (document.getElementById("daterangepickerMinCss")) document.getElementById("daterangepickerMinCss").href =
        daterangepickerMinCss;
    if (document.getElementById("summernoteMinCss")) document.getElementById("summernoteMinCss").href = summernoteMinCss;
    if (document.getElementById("customCss")) document.getElementById("customCss").href = customCss;
    if (document.getElementById("select2MinCss")) document.getElementById("select2MinCss").href = select2MinCss;
    if (document.getElementById("select2Bootstrap")) document.getElementById("select2Bootstrap").href = select2Bootstrap;
    if (document.getElementById("dataTableCss")) document.getElementById("dataTableCss").href = dataTableCss;


    if (document.getElementById("jqueryMinJs")) document.getElementById("jqueryMinJs").src = jqueryMinJs;
    if (document.getElementById("jqueryUiMinJS")) document.getElementById("jqueryUiMinJS").src = jqueryUiMinJS;
    if (document.getElementById("jqueryVmapMinJS")) document.getElementById("jqueryVmapMinJS").src = jqueryVmapMinJS;
    if (document.getElementById("jqueryMapsMinJS")) document.getElementById("jqueryMapsMinJS").src = jqueryMapsMinJS;
    if (document.getElementById("jqueryKnobMinJS")) document.getElementById("jqueryKnobMinJS").src = jqueryKnobMinJS;
</script>