var reminderDate = '',
    reminderTime = '',
    reminderAgenda = '';

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    reminderDate = '';
    reminderTime = '';
    reminderAgenda = '';

    reminderDate = document.getElementById("reminderDate").value.trim();
    reminderTime = document.getElementById("reminderTime").value.trim();
    reminderAgenda = document.getElementById("reminderAgenda").value.trim();
}

function reminderValidation() {
    if (reminderDate == '') {
        showError('reminderDate', "#ffc2b3", "Select Date");
        return 0;
    } else showError('reminderDate', '', '');

    if (reminderTime == '') {
        showError('reminderTime', "#ffc2b3", "Select Time");
        return 0;
    } else showError('reminderTime', '', '');

    if (reminderAgenda == '') {
        showError('reminderAgenda', "#ffc2b3", "Enter Agenda");
        return 0;
    } else showError('reminderAgenda', '', '');

    if (charLimitExceed == 'true') {
        showError('reminderAgenda', "#ffc2b3", "Character limit exceeded");
        return 0;
    } else showError('reminderAgenda', '', '');
}

function saveReminder() {
    var saveFlag = 'saveReminder';

    document.getElementById("saveButton").disabled = true;
    if (setHeaders() == 0) return;
    if (reminderValidation() == 0) {
        document.getElementById("saveButton").disabled = false;
        return;
    }
    agenda = escapeSpecialCharacters(reminderAgenda);
    document.getElementById('successMessage').innerHTML = 'Saving.Please wait...';
    $.post('saveReminder.php', {
        'saveFlag': saveFlag,
        'facultyId': facultyId,
        'reminderDate': reminderDate,
        'reminderTime': reminderTime,
        'agenda': agenda
    }, function (data) {
        document.getElementById('successMessage').innerHTML = 'Saved successfully';
        document.getElementById("saveButton").disabled = false;
        location.reload();
    });
}

function confirmReminder(reminderId,notifictionId) {
    var saveFlag = 'confirmReminder';
    if (confirm("Are you sure you want to mark reminder with reminder ID " + reminderId + " as completed?")) {
        $.post('saveReminder.php', {
            'saveFlag': saveFlag,
            'reminderId': reminderId,
            'notifictionId': notifictionId
        }, function (data) {
            document.getElementById("saveButton").disabled = false;
            location.reload();
        });
    }
}

function deleteReminder(reminderId) {
    var saveFlag = 'deleteReminder';
    if (confirm("Are you sure you want to delete reminder with reminder ID " + reminderId + "?")) {
        $.post('saveReminder.php', {
            'saveFlag': saveFlag,
            'reminderId': reminderId,
        }, function (data) {
            document.getElementById("saveButton").disabled = false;
            location.reload();
        });
    }
}

function editRemainder(id) {
    var remainderId = id;
    encodedValue_remainderId = btoa(remainderId);
    window.location.href = "editReminder.php?rId=" + encodedValue_remainderId;
}