function showError(id, color, message)
{
    console.log(id);
    if (id != '')
        document.getElementById(id).innerHTML = message;

}
function createTHcell(newRow, cellValue) {
    newCell = document.createElement("th");
    newCell.innerHTML = cellValue;
    newRow.appendChild(newCell);
}


function addNONGSTtypeInvoiceTableHeader() {
    var mytableHeader = document.getElementById("invoiceTableHeader"),
        newRow,
        newCell;

    var newRow = document.createElement("tr");
    mytableHeader.appendChild(newRow);

    createTHcell(newRow, " WORKSHOP ID");
    createTHcell(newRow, "WORKSHOP TITLE");
    createTHcell(newRow, "TOTAL AMOUNT");
    createTHcell(newRow, "PENALTY AMOUNT");
    createTHcell(newRow, "FINAL AMOUNT");
    createTHcell(newRow, "INVOICE NUMBER");
    createTHcell(newRow, "INVOICE STATUS");
    createTHcell(newRow, "INVOICE");
    createTHcell(newRow, "VIEW");
}

function addGSTtypeInvoiceTableHeader() {
    var mytableHeader = document.getElementById("invoiceTableHeader"),
        newRow,
        newCell;

    var newRow = document.createElement("tr");
    mytableHeader.appendChild(newRow);

    createTHcell(newRow, " WORKSHOP ID");
    createTHcell(newRow, "WORKSHOP TITLE");
    createTHcell(newRow, "TOTAL AMOUNT");
    createTHcell(newRow, "PENALTY AMOUNT");
    createTHcell(newRow, "GROSS AMOUNT");
    createTHcell(newRow, "GST TAX");
    createTHcell(newRow, "NET AMOUNT");
    createTHcell(newRow, "INVOICE STATUS");
    createTHcell(newRow, "VIEW");
    createTHcell(newRow, "ACTIONS");
}

function generateInvoicePdf(facultyId,accountsId,workshopId,workshopTitle,feeforworkshop,finalAmount,totalAmount,penaltyAmount,index) {
    var invoiceNumber = document.getElementById('facultyInvoiceNumber' + index).value.trim();

    if (invoiceNumber === '') {
        showError('errorMessage' + index, '#ff6666', 'Invoice number cannot be blank.');
        return; 
    } else {
        showError('errorMessage' + index, '', ''); 
    }

    console.log(facultyId);
    console.log(invoiceNumber);

    if (confirm("Are you sure you want to raise invoice?")) {
        var finalAmountInString = ConvertNumberToWords(finalAmount);
        document.getElementById('successMessage' + index).innerHTML = 'Invoice Generated Successfully.';
        window.open("generateWorkshopInvoicePdf.php?aId=" + accountsId + "&fID=" + facultyId + "&FIN=" + invoiceNumber + "&fAIS=" + finalAmountInString + "&workshopId=" + workshopId + "&wT="+workshopTitle + "&wFee="+feeforworkshop + "&fA=" + totalAmount + "&pA=" + penaltyAmount);
    }
    location.reload();
}

function ConvertNumberToWords(number) {
    var words = new Array();
    words[0] = '';
    words[1] = 'One';
    words[2] = 'Two';
    words[3] = 'Three';
    words[4] = 'Four';
    words[5] = 'Five';
    words[6] = 'Six';
    words[7] = 'Seven';
    words[8] = 'Eight';
    words[9] = 'Nine';
    words[10] = 'Ten';
    words[11] = 'Eleven';
    words[12] = 'Twelve';
    words[13] = 'Thirteen';
    words[14] = 'Fourteen';
    words[15] = 'Fifteen';
    words[16] = 'Sixteen';
    words[17] = 'Seventeen';
    words[18] = 'Eighteen';
    words[19] = 'Nineteen';
    words[20] = 'Twenty';
    words[30] = 'Thirty';
    words[40] = 'Forty';
    words[50] = 'Fifty';
    words[60] = 'Sixty';
    words[70] = 'Seventy';
    words[80] = 'Eighty';
    words[90] = 'Ninety';
    number = number.toString();
    var atemp = number.split(".");
    var number = atemp[0].split(",").join("");
    var n_length = number.length;
    var words_string = "";
    if (n_length <= 9) {
        var n_array = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0);
        var received_n_array = new Array();
        for (var i = 0; i < n_length; i++) {
            received_n_array[i] = number.substr(i, 1);
        }
        for (var i = 9 - n_length, j = 0; i < 9; i++, j++) {
            n_array[i] = received_n_array[j];
        }
        for (var i = 0, j = 1; i < 9; i++, j++) {
            if (i == 0 || i == 2 || i == 4 || i == 7) {
                if (n_array[i] == 1) {
                    n_array[j] = 10 + parseInt(n_array[j]);
                    n_array[i] = 0;
                }
            }
        }
        value = "";
        for (var i = 0; i < 9; i++) {
            if (i == 0 || i == 2 || i == 4 || i == 7) {
                value = n_array[i] * 10;
            } else {
                value = n_array[i];
            }
            if (value != 0) {
                words_string += words[value] + " ";
            }
            if ((i == 1 && value != 0) || (i == 0 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Crores ";
            }
            if ((i == 3 && value != 0) || (i == 2 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Lakhs ";
            }
            if ((i == 5 && value != 0) || (i == 4 && value != 0 && n_array[i + 1] == 0)) {
                words_string += "Thousand ";
            }
            if (i == 6 && value != 0 && (n_array[i + 1] != 0 && n_array[i + 2] != 0)) {
                words_string += "Hundred and ";
            } else if (i == 6 && value != 0) {
                words_string += "Hundred ";
            }
        }
        words_string = words_string.split(" ").join(" ");
    }
    return words_string;
}

function showGstDetails(id,workshopId, gstTax, netAmount, CGST, SGST, IGST) {
    encodedValue_accountsId = btoa(id);
    encodedValue_gstTax = btoa(gstTax);
    encodedValue_netAmount = btoa(netAmount);
    encodedValue_CGST = btoa(CGST);
    encodedValue_SGST = btoa(SGST);
    encodedValue_IGST = btoa(IGST);
    workshopId = btoa(workshopId);

    window.location.href = "viewWorkshopInvoiceDetails.php?acId=" + encodedValue_accountsId + "&gt=" + encodedValue_gstTax +  "&workshopId="+workshopId + "&nt=" +encodedValue_netAmount + "&cg=" + encodedValue_CGST + "&sg=" + encodedValue_SGST + "&ig=" + encodedValue_IGST;
}

var loadInvoiceFile = function (event, previewId) {
    console.log(previewId);
    flagEditInvoice = 1;
    var invoicePreview = document.getElementById('invoicePreview');
    invoicePreview.innerHTML = event.target.files[0].name;
}
function showErrorPI(id, color, message) {
    if (id != '')
        // document.getElementById(id).style.backgroundColor = color;
        document.getElementById('invoiceErrorMessage').innerHTML = message;
}

function saveInvoice() {
    console.log(CGST);
    console.log(SGST);
    console.log(IGST);
    var facultyInvoiceNumber=document.getElementById('facultyInvoiceNumber').value.trim();
    var workshopId = document.getElementById('workshopId').value.trim();
    var workshopTitle = document.getElementById('workshopTitle').value.trim();
    gstAmount = document.getElementById('gstTax').value.trim();
    document.getElementById('saveButton').disabled = true;
    invoiceInput = '';
    invoiceFlag = '';
    invoiceDocument = '';
    invoiceInput = document.getElementById('invoice');

    if(facultyInvoiceNumber==''){
        showErrorPI('facultyInvoiceNumber', '#ffc2b3', "Invoice number cannot be blank ");
    }
    if (invoiceInput.files.length == 0) {
        document.getElementById('uploadInvoiceButton').style.backgroundColor = "#ffc2b3";
        showErrorPI('uploadInvoiceButton', '', "Select File");
        document.getElementById('saveButton').disabled = false;
        return 0;
    } else {
        document.getElementById('uploadInvoiceButton').style.backgroundColor = "";
        showErrorPI('uploadInvoiceButton', '', '');
    }

    console.log(facultyInvoiceNumber);
    console.log(invoiceInput);
    console.log(invoiceInput.files.length);
    console.log(invoiceFlag);

    if (invoiceInput.files.length > 0) {
        invoiceFlag = "true";
        console.log(invoiceFlag);

        invoiceDocument = invoiceInput.files[0];
        var imgSize = (parseFloat(invoiceInput.files[0].size / 1024) / 1024).toFixed(2);
        console.log(imgSize);
        if (imgSize > 1) {
            console.log('enter');
            showErrorPI('uploadInvoiceButton', '', "Image size should not exceed 1 MB.");
            document.getElementById('saveButton').disabled = false;

            return 0;
        } else showErrorPI('', '', '');
    }

    var saveFlag = 'saveInvoice';
    formData = new FormData();
    formData.append('saveFlag', saveFlag);
    formData.append('invoiceFlag', invoiceFlag);
    formData.append('invoiceDocument', invoiceDocument);
    formData.append('accountsId', accountsId);
    formData.append('workshopId', workshopId);
    formData.append('workshopTitle', workshopTitle);
    formData.append('CGST', CGST);
    formData.append('SGST', SGST);
    formData.append('IGST', IGST);
    formData.append('gstAmount', gstAmount);
    formData.append('facultyInvoiceNumber', facultyInvoiceNumber);



    document.getElementById('saveButton').disabled = true;
    document.getElementById('invoiceSuccessMessage').innerHTML = 'Uploading ...';
    $.ajax({
        url: "saveWorkshopInvoice.php",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        enctype: 'multipart/form-data',
        success: function (data) {
            console.log(data);
            document.getElementById('invoiceSuccessMessage').innerHTML = 'Uploaded successfully';
            document.getElementById('uploadInvoiceButton').disabled = true;
            // location.reload();
        }
    });
}