var queryRaisedTo = '',
    studentQuery = '';

function showAndHideDiv() {
    if (ratingCount != '' && ratingCount != 'PENDING') {
        document.getElementById('editDiv').hidden = true;
        document.getElementById('viewDiv').hidden = false;
        document.getElementById('viewRatingDiv').hidden = false;
        document.getElementById('viewUnresolvedQueryDiv').hidden = true;
        document.getElementById('queryResolvedDiv').hidden = true;
    } else if (queryStatus == 'NOT RESOLVED') {
        document.getElementById('editDiv').hidden = true;
        document.getElementById('viewDiv').hidden = false;
        document.getElementById('viewRatingDiv').hidden = true;
        document.getElementById('viewUnresolvedQueryDiv').hidden = false;
        document.getElementById('queryResolvedDiv').hidden = true;
    } else if (queryStatus == 'PARTIALLY RESOLVED') {
        document.getElementById('editDiv').hidden = true;
        document.getElementById('viewDiv').hidden = false;
        document.getElementById('viewRatingDiv').hidden = true;
        document.getElementById('viewUnresolvedQueryDiv').hidden = false;
        document.getElementById('queryResolvedDiv').hidden = true;
    } else {
        document.getElementById('editDiv').hidden = false;
        document.getElementById('viewDiv').hidden = true;
        document.getElementById('viewRatingDiv').hidden = true;
        document.getElementById('viewUnresolvedQueryDiv').hidden = true;
        document.getElementById('queryResolvedDiv').hidden = false;
    }
}

function giveRating() {
    let star = document.querySelectorAll("fieldset.rating > input");
    rateCount = '';
    for (let i = 0; i < star.length; i++) {
        star[i].addEventListener('click', function () {
            i = this.value;
            // rateCount = (parseFloat(i) / 2) + 2.5;
            rateCount = i;
        });
    }
    //add event listener
    function clickStar(ele) {
        var clickedStar = ele;
        var children = '';
        //value of the star
        var rateValue = parseInt(clickedStar.getAttribute("value"));
        //change the color of the star
        for (var i = 0; i < rateValue; i++) {
            rate.children[i].classList.add("clicked");
            for (var j = rateValue; j <= 9; j++) {
                if (rate.children[j].classList.contains("clicked")) {
                    rate.children[j].classList.remove("clicked");
                }
            }
        }
    }
}

function viewRating() {
    if (ratingCount == '' || ratingCount == 'PENDING') rateCount = 0;
    const starTotal = 10;
    const starPercentage = (ratingCount / starTotal) * 100;
    const starPercentageRounded = (Math.round(starPercentage / 10) * 10) + '%';
    document.querySelector('.stars-inner').style.width = starPercentageRounded;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("queryRaisedTo")) {
            if (i == 0) {
                options.value = options.text = "QUERY RAISED TO";
                theSelect.add(options);
                options.selected = true;
                options.disabled = true;
                options = document.createElement("option");
            }
            options.value = results[i].userid;
            if (results[i].user_type != '') options.text = results[i].firstname + " " + results[i].lastname + " (" + results[i].user_type + ")".toUpperCase();
            else options.text = results[i].firstname + " " + results[i].lastname.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function selectDropdownValue(selectName, val) {
    val = val.toUpperCase();
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function selectQueryStatus(id) {
    if (id == 'queryResolvedRadio') {
        document.getElementById("queryResolvedDiv").hidden = false;
        document.getElementById("queryUnresolvedDiv").hidden = true;
        document.getElementById("queryPartialDiv").hidden = true;
    }
    if (id == 'queryPartialRadio') {
        document.getElementById("queryResolvedDiv").hidden = true;
        document.getElementById("queryPartialDiv").hidden = false;
        document.getElementById("queryUnresolvedDiv").hidden = true;
    }
    else if (id == 'queryUnresolvedRadio') {
        document.getElementById("queryResolvedDiv").hidden = true;
        document.getElementById("queryUnresolvedDiv").hidden = false;
        document.getElementById("queryPartialDiv").hidden = true;
    }
}

function showRatingError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('ratingErrorMessage').innerHTML = message;
}

function showUnresolvedError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('unresolvedErrorMessage').innerHTML = message;
}

function saveRatings() {
    document.getElementById('saveRatingButton').disabled = true;
    var saveFlag = 'saveRatings';

    if (rateCount == '') {
        showRatingError('', "", "Please rate your experience.");
        document.getElementById('saveRatingButton').disabled = false;
        return 0;
    } else showRatingError('', '', '');

    document.getElementById('ratingSuccessMessage').innerHTML = 'Saving.Please wait...';
    document.getElementById('saveRatingButton').disabled = true;
    document.getElementById("saveUnresolvedQueryButton").disabled = true;
    document.getElementById("savePartialResolveQueryButton").disabled = true;
    $.post('saveQuery.php', {
        'saveFlag': saveFlag,
        'queryId': queryId,
        'rateCount': rateCount,
    }, function (data) {
        document.getElementById('ratingSuccessMessage').innerHTML = 'Saved successfully';
        location.reload();
    });
}

function savePartialResolveQuery() {
    var saveFlag = 'partiallyeResolve';
    if (confirm("Are you sure you want to mark query as partially Resolved?")) {
        document.getElementById('saveRatingButton').disabled = true;
        document.getElementById("saveUnresolvedQueryButton").disabled = true;
        document.getElementById("savePartialResolveQueryButton").disabled = true;
        document.getElementById('partialSuccessMessage').innerHTML = 'Updating Please wait...';
        $.post('saveQuery.php', {
            'saveFlag': saveFlag,
            'queryId': queryId,
        }, function (data) {
            document.getElementById('partialSuccessMessage').innerHTML = 'Saved successfully';
            location.reload();
        });
    }
}

function unresolvedQueryValidation() {
    queryRaisedTo = '';
    studentQuery = '';

    queryRaisedTo = document.getElementById('queryRaisedTo').value.trim();
    studentQuery = document.getElementById('updatedQuery').value.trim();

    if (queryRaisedTo == 'QUERY RAISED TO') {
        document.getElementById("queryRaisedTo").style.backgroundColor = "#ffc2b3";
        showUnresolvedError('queryRaisedTo', "#ffc2b3", "Select whom you want to raise query");
        return 0;
    } else {
        document.getElementById("queryRaisedTo").style.backgroundColor = "";
        showUnresolvedError('unresolvedErrorMessage', '', '');
    }

    if (studentQuery == '') {
        document.getElementById("updatedQuery").style.backgroundColor = "#ffc2b3";
        showUnresolvedError('updatedQuery', "#ffc2b3", "Enter your query");
        return 0;
    } else {
        document.getElementById("updatedQuery").style.backgroundColor = "";
        showUnresolvedError('unresolvedErrorMessage', '', '');
    }

    if (studentQuery.length <= 40) {
        document.getElementById("updatedQuery").style.backgroundColor = "#ffc2b3";
        showUnresolvedError('updatedQuery', "#ffc2b3", "Query should contain at least 40 characters.");
        return 0;
    } else {
        document.getElementById("updatedQuery").style.backgroundColor = "";
        showUnresolvedError('unresolvedErrorMessage', '', '');
    }
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

function saveUnresolvedQuery() {
    document.getElementById('saveUnresolvedQueryButton').disabled = true;
    var saveFlag = 'saveUnresolvedQuery';
    if (unresolvedQueryValidation() == 0) {
        document.getElementById('saveUnresolvedQueryButton').disabled = false;
        return;
    }
    studentQuery = escapeSpecialCharacters(studentQuery);
    if (confirm("Are you sure you want to mark query as unresolved?")) {
        document.getElementById('unresolvedSuccessMessage').innerHTML = 'Saving.Please wait...';
        document.getElementById('saveRatingButton').disabled = true;
        document.getElementById("saveUnresolvedQueryButton").disabled = true;
        document.getElementById("savePartialResolveQueryButton").disabled = true;
        $.post('saveQuery.php', {
            'saveFlag': saveFlag,
            'queryId': queryId,
            'studentId': studentId,
        }, function (data) {
            document.getElementById('unresolvedSuccessMessage').innerHTML = 'Saved successfully';
            location.reload();
        });
    }
    else document.getElementById("saveUnresolvedQueryButton").disabled = false;
}