var queryId = '',
    queryRaisedTo = '',
    studentQuery = '',
    queryImage = '',
    queryImageFlag = "false";

var queryAttachment = '',
    queryAttachmentInput = '',
    queryAttachmentFlag = 'false';

function addQueryCharacterLimit() {
    var msg = document.getElementsByClassName("msg")[0],
        charLeftLabel = "char-left",
        charLeft = document.getElementsByClassName(charLeftLabel)[0],
        maxChar = 240,
        maxCharWarn = 0;
    charLeft.innerHTML = maxChar + '/' + maxChar;

    msg.onkeydown = function () {
        setTimeout(function () {
            charLeft.innerHTML = (maxChar - msg.value.length) + '/' + maxChar;
            var warnLabel = msg.value.length > maxChar - maxCharWarn ? " warning" : "";
            charLeft.className = charLeftLabel + warnLabel;
            if (warnLabel.trim() == 'warning') {
                document.getElementById("query").style.backgroundColor = "#ffc2b3";
                charLimitExceed = 'true';
            } else {
                document.getElementById("query").style.backgroundColor = "";
                charLimitExceed = 'false';
            }
        }, 1);
    };
}

function editQueryCharacterLimit() {
    var msgEdit = document.getElementsByClassName("msgEdit")[0],
        charLeftLabelEdit = "char-left-Edit",
        charLeftEdit = document.getElementsByClassName(charLeftLabelEdit)[0],
        maxCharEdit = 240,
        maxCharWarnEdit = 0;

    msgEdit.onkeydown = function () {
        setTimeout(function () {
            charLeftEdit.innerHTML = (maxCharEdit - msgEdit.value.length) + '/' + maxCharEdit;
            var warnLabelEdit = msgEdit.value.length > maxCharEdit - maxCharWarnEdit ? " warningEdit" :
                "";
            charLeftEdit.className = charLeftLabelEdit + warnLabelEdit;
            if (warnLabelEdit.trim() == 'warningEdit') {
                document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
                charLimitExceedEdit = 'true';
            } else {
                document.getElementById("ModalQueryMessage").style.backgroundColor = "";
                charLimitExceedEdit = 'false';
            }
        }, 1)
    }
}

var loadFile = function (event, previewId) {
    if (previewId == "queryImage" && event.target.files[0]) {
        flagEditPhoto = 1;
        var passPortPhotoPreview = document.getElementById('imagePreview');
        passPortPhotoPreview.src = URL.createObjectURL(event.target.files[0]);
        passPortPhotoPreview.style.height = 200;
        passPortPhotoPreview.style.width = 180;
        passPortPhotoPreview.onload = function () {
            URL.revokeObjectURL(passPortPhotoPreview.src) // free memory
        }
    } else if (previewId == "queryImageModal" && event.target.files[0]) {
        flagEditPhotoModal = 1;
        var attachmentPreviewModal = document.getElementById('attachmentPreviewModal');
        attachmentPreviewModal.src = URL.createObjectURL(event.target.files[0]);
        attachmentPreviewModal.style.height = 200;
        attachmentPreviewModal.style.width = 180;
        attachmentPreviewModal.onload = function () {
            URL.revokeObjectURL(attachmentPreviewModal.src) // free memory
        }
    }
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("queryRaisedTo")) {
            if (i == 0) {
                options.value = options.text = "QUERY RAISED TO";
                theSelect.add(options);
                options.selected = true;
                options.disabled = true;
                options = document.createElement("option");
            }
            options.value = results[i].userid;
            if (results[i].user_type != '') options.text = results[i].firstname + " " + results[i].lastname + " (" + results[i].user_type + ")".toUpperCase();
            else options.text = results[i].firstname + " " + results[i].lastname.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function selectDropdownValue(selectName, val) {
    val = val.toUpperCase();
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function loadData() {
    $.post('queryDetails.php', {
        'studentId': studentId,
    }, function (data) {
        $('#queryDetails').html(data);
    });
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

function showError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function showModalError(id, color, message) {
    if (id != '') document.getElementById(id).style.backgroundColor = color;
    document.getElementById('modalErrorMessage').innerHTML = message;
}

function queryValidation() {
    queryId = '';
    queryRaisedTo = '';
    studentQuery = '';
    queryImageFlag = "false";
    queryImage = '';

    queryId = document.getElementById('queryId').value.trim();
    queryRaisedTo = document.getElementById('queryRaisedTo').value.trim();
    studentQuery = document.getElementById('query').value.trim();

    if (queryRaisedTo == 'QUERY RAISED TO') {
        document.getElementById("queryRaisedTo").style.backgroundColor = "#ffc2b3";
        showError('queryRaisedTo', "#ffc2b3", "Select whom you want to raise query");
        return 0;
    } else {
        document.getElementById("queryRaisedTo").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (studentQuery == '') {
        document.getElementById("query").style.backgroundColor = "#ffc2b3";
        showError('query', "#ffc2b3", "Enter your query");
        return 0;
    } else {
        document.getElementById("query").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (studentQuery.length <= 40) {
        document.getElementById("query").style.backgroundColor = "#ffc2b3";
        showError('query', "#ffc2b3", "Query should contain at least 40 characters.");
        return 0;
    } else {
        document.getElementById("query").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (charLimitExceed == 'true') {
        document.getElementById("query").style.backgroundColor = "#ffc2b3";
        showError('query', "#ffc2b3", "Character limit exceeded");
        return 0;
    } else {
        document.getElementById("query").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    var input = document.getElementById("queryImage");
    if (input.files.length > 0) {
        queryImageFlag = "true";
        queryImage = input.files[0];
    }
    if (input.files.length > 0) {
        queryImageFlag = "true";
        checkProof = input.files[0];
        var imgSize = (parseFloat(input.files[0].size / 1024) / 1024).toFixed(2);
        if (imgSize > 1) {
            showError('', '', "Image size should not exceed 1 MB.");
            return 0;
        } else showError('', '', '');
    }
    return 1;

}

function saveQuery(studentId) {
    saveFlag = 'saveQuery';
    document.getElementById('successMessage').innerHTML = '';
    document.getElementById('saveButton').disabled = true;
    if (queryValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    userDetails = [];
    for (i = 0; i < queryRaisedToArray.length; i++) {
        if (queryRaisedTo == queryRaisedToArray[i]['userid']) {
            userDetails.push(obj = {
                "userEmailId": queryRaisedToArray[i].username,
                "userFirstName": queryRaisedToArray[i].firstname,
                "userLastName": queryRaisedToArray[i].lastname,
                "userId": queryRaisedToArray[i].userid,
                "userType": queryRaisedToArray[i].user_type,
            });
        }
    }

    studentQuery = escapeSpecialCharacters(studentQuery);
    formData = new FormData();
    formData.append("saveFlag", saveFlag);
    formData.append("queryId", queryId);
    formData.append("studentId", studentId);
    formData.append("queryRaisedTo", queryRaisedTo);
    formData.append("studentQuery", studentQuery);
    formData.append("userDetails", JSON.stringify(userDetails));
    formData.append("studentDetails", JSON.stringify(studentDetails));
    formData.append("queryImageFlag", queryImageFlag);
    formData.append("queryImage", queryImage);
    document.getElementById('successMessage').innerHTML = 'Saving Query.Please wait...';
    $.ajax({
        url: "saveQuery.php",
        type: "POST",
        enctype: 'multipart/form-data',
        data: formData,
        processData: false,
        contentType: false,
        success: function (data) {
            document.getElementById('successMessage').innerHTML = 'Saved successfully';
            document.getElementById('query').value = '';
            document.getElementById('queryRaisedTo').value = 'QUERY RAISED TO';
            queryId = parseInt(queryId) + 1;
            document.getElementById('queryId').value = queryId;
            document.getElementById("saveButton").disabled = false;
            loadData();
        }
    });
}

function resetModal() {
    document.getElementById('ModalQueryMessage').value = '';
    document.getElementById('modalQueryId').innerHTML = '';
    document.getElementById('modalQueryRaisedTo').innerHTML = '';
    document.getElementById('modalErrorMessage').innerHTML = '';
    document.getElementById('modelsuccessMessage').innerHTML = '';
    document.getElementById('attachmentPreviewModal').src = '';
    document.getElementById('attachmentPreviewModal').style.height = '';
    document.getElementById('attachmentPreviewModal').style.width = '';
    document.getElementById('editButton').disabled = false;
    document.getElementById('ModalQueryMessage').style.backgroundColor = '';
    document.getElementById('characterLeftEdit').innerHTML = '';
    charLimitExceedEdit = 'false';
}

function addDataToModal(modalQuery, modalQueryId, modalQueryRaisedTo, modalQueryAttachment) {
    resetModal();
    document.getElementById('ModalQueryMessage').value = modalQuery;
    document.getElementById('modalQueryId').innerHTML = modalQueryId;
    document.getElementById('modalQueryRaisedTo').innerHTML = modalQueryRaisedTo;

    if (modalQueryAttachment.length > 0) {
        var attachmentPreviewModal = document.getElementById('attachmentPreviewModal');
        attachmentPreviewModal.src = "../../../dist/img/studentQueryImages/" + modalQueryAttachment;
        attachmentPreviewModal.style.height = 200;
        attachmentPreviewModal.style.width = 180;
    }
}

function queryEditValidation() {
    studentQuery = '';
    queryId = '';
    queryAttachment = '';
    queryAttachmentInput = '';
    queryAttachmentFlag = 'false';

    studentQuery = document.getElementById('ModalQueryMessage').value.trim();
    queryId = document.getElementById('modalQueryId').innerHTML.trim();
    queryAttachmentInput = document.getElementById("queryImageModal");

    if (queryAttachmentInput.files.length > 0) {
        queryAttachmentFlag = "true";
        queryAttachment = queryAttachmentInput.files[0];
    }
    if (queryAttachmentInput.files.length > 0) {
        queryAttachmentFlag = "true";
        queryAttachmentProof = queryAttachmentInput.files[0];
        var imgSize = (parseFloat(queryAttachmentInput.files[0].size / 1024) / 1024).toFixed(2);
        if (imgSize > 1) {
            showModalError('', '', "Image size should not exceed 1 MB.");
            return 0;
        } else showModalError('', '', '');
    }

    if (studentQuery == '') {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
        showModalError('ModalQueryMessage', "#ffc2b3", "Enter your query");
        return 0;
    } else {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "";
        showModalError('modalErrorMessage', '', '');
    }
    if (studentQuery.length <= 40) {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
        showModalError('ModalQueryMessage', "#ffc2b3", "Query should contain at least 40 characters.");
        return 0;
    } else {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "";
        showModalError('modalErrorMessage', '', '');
    }
    if (charLimitExceedEdit == 'true') {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
        showModalError('ModalQueryMessage', "#ffc2b3", "Character limit exceeded");
        return 0;
    } else {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "";
        showModalError('modalErrorMessage', '', '');
    }
    return 1;
}

function editQuery() {
    saveFlag = 'editQuery';
    document.getElementById('editButton').disabled = true;
    if (queryEditValidation() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }

    studentQuery = escapeSpecialCharacters(studentQuery);
    formData = new FormData();
    formData.append("saveFlag", saveFlag);
    formData.append("queryId", queryId);
    formData.append("studentQuery", studentQuery);
    formData.append("queryAttachment", queryAttachment);
    formData.append("queryAttachmentFlag", queryAttachmentFlag);
        document.getElementById('modelsuccessMessage').innerHTML = 'Saving.Please wait...';
        $.ajax({
            url: "saveQuery.php",
            type: "POST",
            enctype: 'multipart/form-data',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                document.getElementById('modelsuccessMessage').innerHTML = 'Saved successfully';
                loadData();
                document.getElementById("closeModal").click();
            }
        });
    }

function viewSolution(id) {
    encodedValue_id = btoa(id);
    encodedKey_queryId = btoa('qId');
    window.location.href = "viewSolution.php?" + encodedKey_queryId + "=" + encodedValue_id;
}

function viewRevision(id) {
    encodedValue_id = btoa(id);
    encodedKey_queryId = btoa('qId');
    window.location.href = "viewRevision.php?" + encodedKey_queryId + "=" + encodedValue_id;
}

function viewRejectreason(id) {
    encodedValue_id = btoa(id);
    encodedKey_queryId = btoa('qId');
    window.location.href = "viewRejectReason.php?" + encodedKey_queryId + "=" + encodedValue_id;
}