<?php
session_start();
if (isset($_SESSION['studLoginSuccess'])) {
    if ($_SESSION['studLoginSuccess'] > 0) {
    } else {
        header('Location: ../../studentLogin.php');
        exit;
    }
} else {
    header('Location: ../../studentLogin.php');
    exit;
}
$studentId = $_SESSION['studentId'];

require_once '../../common/connectToDB.php';
require '../../common/header.php';

$resultBySemester = [];
$studentName = '';
$batch = '';
$academicYear = '';


$sql = "SELECT es.*, ls.firstname, ls.lastname, s.subjectName, s.subjectId, s.semester,
               esm.batchName, esm.academicYear
        FROM examinationscore es
        INNER JOIN loginstudents ls ON ls.studentId = es.studentId
        INNER JOIN subjects s ON s.subjectId = es.subjectId
        LEFT JOIN examinationscoremaster esm ON esm.subjectId = es.subjectId
        WHERE es.studentId = '$studentId'
        ORDER BY s.semester, s.subjectId, es.examType";



$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $studentName = $row['firstname'] . ' ' . $row['lastname'];
        $batch = $row['batchName'];
        $academicYear = $row['academicYear'];

        preg_match('/\d+/', $row['semester'], $matches);
        $semester = isset($matches[0]) ? (int)$matches[0] : 0;

        $subjectId = $row['subjectId'];
        $examType = trim($row['examType']);

        if (!isset($resultBySemester[$semester][$subjectId])) {
            $resultBySemester[$semester][$subjectId] = [
                'subjectName' => $row['subjectName'],
                'examType' => []
            ];
        }

        $resultBySemester[$semester][$subjectId]['examType'][$examType] = (int)$row['examScore'];
    }
}


// Fetch subject examScore structure (max/min marks)
$subjectScoreDetails = [];
$sqlSubjects = "SELECT * FROM subjects";
$resultSubjects = $conn->query($sqlSubjects);

if ($resultSubjects && $resultSubjects->num_rows > 0) {
    while ($subject = $resultSubjects->fetch_assoc()) {
        $subjectId = $subject['subjectId'];
        $subjectScoreDetails[$subjectId] = [
            'subjectName' => $subject['subjectName'],
            'semester' => $subject['semester'],
            'examType' => []
        ];

        $sqlScores = "SELECT examType, examTotalMarks, examPassingMarks 
                      FROM subjectscore 
                      WHERE subjectId = '$subjectId'";
        $resScores = $conn->query($sqlScores);

        if ($resScores && $resScores->num_rows > 0) {
            while ($row = $resScores->fetch_assoc()) {
                $subjectScoreDetails[$subjectId]['examType'][$row['examType']] = [
                    'max' => (int)$row['examTotalMarks'],
                    'min' => (int)$row['examPassingMarks']
                ];
            }
        }
    }
}

// Collect all distinct exam types
$allExamTypes = [];
foreach ($subjectScoreDetails as $subject) {
    foreach ($subject['examType'] as $et => $val) {
        if (!in_array($et, $allExamTypes)) {
            $allExamTypes[] = $et;
        }
    }
}
require '../../common/navbar.php';
?>

<!-- HTML & table rendering -->
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
          <ul class="nav nav-tabs">
    <?php for ($sem = 1; $sem <= 6; $sem++): ?>
        <li class="nav-item">
            <a class="nav-link <?= ($sem === 1 ? 'active' : '') ?>" href="#sem<?= $sem ?>" data-toggle="tab">SEMESTER-<?= $sem ?></a>
        </li>
    <?php endfor; ?>
</ul>


           <div class="tab-content">
<?php for ($sem = 1; $sem <= 6; $sem++): ?>
    <div class="tab-pane fade <?= ($sem === 1 ? 'show active' : '') ?>" id="sem<?= $sem ?>">
        <div class="card mt-3">
            <div class="card-body">
                <form>
                    <div class="row">
                        <div class="col-md-2">
                            <label>Student Id</label>
                            <input type="text" class="form-control" value="<?= $studentId ?>" disabled>
                        </div>
                        <div class="col-md-4">
                            <label>Student Name</label>
                            <input type="text" class="form-control" value="<?= $studentName ?>" disabled>
                        </div>
                        <div class="col-md-3">
                            <label>Batch</label>
                            <input type="text" class="form-control" value="<?= $batch ?>" disabled>
                        </div>
                        <div class="col-md-3">
                            <label>Acadmic Year</label>
                            <input type="text" class="form-control" value="<?= $academicYear ?>" disabled>
                        </div>
                        
                    </div>
                </form>
                <br>
                <?php if (isset($resultBySemester[$sem])): ?>
                <table class="table table-bordered text-center">
                    <thead>
                        <tr>
                            <th>SUBJECT NAME</th>
                            <?php foreach ($allExamTypes as $et): ?>
                                <th><?= strtoupper($et) ?></th>
                            <?php endforeach; ?>
                            <th>TOTAL</th>
                            <th>REMARK</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $semTotalMax = $semTotalObt = 0;
                        $semRemark = 'SUCCESSFUL';

                        foreach ($resultBySemester[$sem] as $subjectId => $data) {
                            $subjectName = $data['subjectName'];
                            $examScores = $data['examType'];
                            $rowMax = $rowObt = 0;

                            echo "<tr><td>$subjectName</td>";

                            foreach ($allExamTypes as $et) {
                                $max = 0;
                                $obt = 0;

                                if (isset($subjectScoreDetails[$subjectId]['examType'][$et])) {
                                    $max = $subjectScoreDetails[$subjectId]['examType'][$et]['max'];
                                }
                                if (isset($examScores[$et])) {
                                    $obt = $examScores[$et];
                                }

                                $rowMax += $max;
                                $rowObt += $obt;

                                echo "<td>$obt / $max</td>";
                            }

                            $remark = ($rowObt >= $rowMax * 0.4) ? 'PASS' : 'FAIL';
                            if ($remark === 'FAIL') $semRemark = 'FAILED';

                            $semTotalMax += $rowMax;
                            $semTotalObt += $rowObt;

                            echo "<td>$rowObt / $rowMax</td>";
                            echo "<td><span class='badge badge-" . ($remark == 'PASS' ? 'success' : 'danger') . "'>$remark</span></td></tr>";
                        }
                        ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="<?= 1 + count($allExamTypes) ?>"></td>
                            <td><?= "$semTotalObt / $semTotalMax" ?></td>
                            <td><span class="badge badge-<?= ($semRemark == 'SUCCESSFUL') ? 'success' : 'danger' ?>"><?= $semRemark ?></span></td>
                        </tr>
                    </tfoot>
                </table>
                <?php else: ?>
                    <div class="text-center text-danger">No records found for Semester <?= $sem ?></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endfor; ?>
</div> <!-- tab content -->

        </div>
    </section>
</div>


<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<?php require '../../common/footer.php'; ?>