<?php
session_start();
if (isset($_SESSION['studLoginSuccess'])) {
    if ($_SESSION['studLoginSuccess'] > 0) {
    } else {
        header('Location: ../../studentLogin.php');
        exit;
    }
} else {
    header('Location: ../../studentLogin.php');
    exit;
}
require_once '../../common/connectToDB.php';

$lifeCoach = [];
$sql = "SELECT * FROM lifecoachdetails";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($lifeCoach, $row);
    }
}

require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="card-title">BOOK A MEETING</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="mt-5">Date:</label>
                                        <input type="date" class="form-control" id="meetingDate"
                                            onChange="onDateChange(this.id)">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="mt-5">Start Time:</label>
                                        <input type="time" class="form-control" id="meetingStartTime">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="mt-5">End Time:</label>
                                        <input type="time" class="form-control" id="meetingEndTime">
                                        <!-- <input type="text" class="form-control" id="meetingEndTime" disabled> -->
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="mt-5">Meeting Type</label><br>
                                        <span class="badge badge-success fs18" id="MeetingType">Booster Meeting</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label>Agenda:</label>
                                    <div class="input-group my-colorpicker2">
                                        <textarea class="form-control" rows="3" placeholder="Agenda"
                                            id="meetingAgenda"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Book a meeting with:</label>
                                        <select class="form-control custom-select" id="bookAMeetingWith">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer tAC mt-5">
                                <input type="button" class="btn btn-primary" value="Book A Meeting" id="bookMeeting"
                                    onclick="bookMeeting()" />
                                    <p id='meetingErrorMessage' class="text-center"
                                        style="color: red; font-size: 1.2em;   text-align: center;">
                                    </p>
                                    <p id='meetingSuccessMessage' class="text-center"
                                        style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                    </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="meetings.js?v=<?php echo $fileVersion; ?>"></script>
<script>
var lifeCoach = "";
lifeCoach = <?php echo json_encode($lifeCoach) ?>;
loadDataDropdown("bookAMeetingWith", lifeCoach, "");
</script>
<?php require '../../common/footer.php'; ?>