var referenceId = '',
    firstName = '',
    lastName = '',
    contactNo = '',
    emailId = '',
    duplicatEmail = '';

    function loadDataDropdown(selectName, results, centerId) {
        var theSelect = document.getElementById(selectName);
        var options = theSelect.getElementsByTagName("option");
        theSelect.innerHTML = "";
        for (var i = 0; i < results.length; i++) {
            options = document.createElement("option");
            if (i == 0) {
                options.value = options.text = "SELECT ACADEMIC YEAR";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            if (selectName.includes("academicYear")) {
                academicYear1 = results[i].firstAcademicYear.split("-");
                academicYear2 = results[i].thirdAcademicYear.split("-");
                academicYear = academicYear1[0] + '-' + academicYear2[1];
                options.value = options.text = academicYear;
                theSelect.add(options);
            }    }
        return;
    }
function setHeaders() {

    referenceId = document.getElementById('referenceId').value.trim();
    firstName = document.getElementById('firstName').value.trim().toUpperCase();
    lastName = document.getElementById('lastName').value.trim().toUpperCase();
    contactNo = document.getElementById('contactNo').value.trim();
    emailId = document.getElementById('emailId').value.trim();
    leadCity = document.getElementById("leadCity").value.trim();
    academicYear = document.getElementById("academicYear").value.trim();
}

function resetLead() {
    document.getElementById('firstName').value = '';
    document.getElementById('lastName').value = '';
    document.getElementById('contactNo').value = '';
    document.getElementById('emailId').value = '';
    document.getElementById("leadCity").value = '';
    document.getElementById("academicYear").value = '';
}
function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('editErrorMessage').innerHTML = message;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('emailId', '', 'Email Alredy Exist. Please Change it...');
                document.getElementById("emailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return;
            } else {
                document.getElementById("emailId").style.backgroundColor = "";
                showError('emailId', '', '');
                duplicatEmail = false;
            }
        }
    );
}

function leadValidation() {
    if (firstName == '') {
        showError('firstName', '#ff6666', 'Add First Name');
        return 0;
    } else {
        showError('firstName', '', '');

    }
    if (lastName == '') {
        showError('lastName', '#ff6666', 'Add Last Name');
        return 0;
    } else {
        showError('lastName', '', '');

    }

    // lead Phone number validation
    if (contactNo.length <= 0) {
        showError('contactNo', '#ff6666', "Enter  your phone number");
        return 0;
    } else {
        document.getElementById("contactNo").style.backgroundColor = "";
        showError('contactNo', '', '');
    }

    if (contactNo.length != '' && contactNo.length != 10) {
        showError('contactNo', '#ff6666', "Phone No. should be of 10 digits only.");
        return 0;
    } else {
        document.getElementById("contactNo").style.backgroundColor = "";
        showError('contactNo', '', '');
    }
    if (emailId == '') {
        showError('emailId', '#ff6666', "Email ID Cannot be Blank");
        return 0;
    } else {
        showError('emailId', '', '');
    }
    if (!validateEmail(emailId)) {
        showError('emailId', '#ff6666', "Email ID is not in correct format");
        return 0;
    } else {
        showError('emailId', '', '');
    }
    if (duplicatEmail == true) {
        document.getElementById("emailId").style.backgroundColor = "#ffc2b3";
        showError('emailId', '', "Email ID Alredy Exist. Please Change it...");
        return 0;
    } else {
        document.getElementById("emailId").style.backgroundColor = "";
        showError('emailId', '', '');
    }

}


function saveLead() {
    var saveFlag = 'SAVELEAD';
    if (setHeaders() == 0) return;
    console.log(leadCity
        , academicYear);
    if (leadValidation() == 0) {
        document.getElementById("editbutton").disabled = false;
        return;
    }
    document.getElementById('modelsuccessMessage').innerHTML = 'Updating Please wait...';
    document.getElementById("editbutton").disabled = true;
    $.post('saveLead.php', {
        'saveFlag': saveFlag,
        'studentId': studentId,
        'referenceId': referenceId,
        'firstName': firstName,
        'lastName': lastName,
        'contactNo': contactNo,
        'emailId': emailId,
        'leadCity':leadCity,
        'academicYear':academicYear,

    }, function (data) {
        console.log(data);
        document.getElementById('modelsuccessMessage').innerHTML = 'Referral Successfully Added:<br> Thank you for Embodied Trust and for your Valuable Recommendation!!';
        document.getElementById("editbutton").disabled = false;
        // location.reload();
    });
}