<?php 
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] <= 0) {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
$examType = [];
$examTotalMarks = [];
$examPassingMarks = [];
$examDescription = [];

$subjectRow = [];

if (isset($_GET['subjectId'])) {
    $subjectId = $_GET['subjectId'];

    // Fetch all rows from subjectscore for the given subjectId
    $sql1 = "SELECT * FROM subjectscore WHERE subjectId = '$subjectId'";
    $result1 = $conn->query($sql1);
    if ($result1->num_rows > 0) {
        while ($row = $result1->fetch_assoc()) {
            $examType[] = $row['examType'];
            $examTotalMarks[] = $row['examTotalMarks'];
            $examPassingMarks[] = $row['examPassingMarks'];
            $examDescription[] = $row['examDescription'];
        }
    }

    // Fetch subject details from subjects table
    $sql2 = "SELECT * FROM subjects WHERE subjectId = '$subjectId'";
    $result2 = $conn->query($sql2);
    if ($result2->num_rows > 0) {
        $subjectRow = $result2->fetch_assoc();
    }
}


require '../../common/header.php';
require '../../common/navbar.php';
?> 

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="card-title">SUBJECT DETAILS</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Subject Id</label>
                                        <input type="number" class="form-control" id="subjectId"
                                            value="<?php echo htmlspecialchars($subjectId); ?>" disabled>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Semester</label>
                                        <input type="text" class="form-control" id="semester"
                                            value="<?php echo htmlspecialchars($subjectRow['semester'] ?? ''); ?>" disabled>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <input type="text" class="form-control" id="subjectName"
                                            value="<?php echo htmlspecialchars($subjectRow['subjectName'] ?? ''); ?>" disabled>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Total Marks</label>
                                        <input type="number" class="form-control" id="subjectGrandTotalMarks"
                                            value="<?php echo htmlspecialchars($subjectRow['grandTotalMarks'] ?? ''); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="util1 fSB">
                            <h3 class="tAC fSB" id="pageTitle">MARKS BREAKUP</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="subjectTable">
                                <thead>
                                    <tr>
                                        <th style="width: 24%"> Title </th>
                                        <th style="width: 24%"> Total Marks </th>
                                        <th style="width: 24%"> Passing Marks </th>
                                        <th style="width: 24%"> Description </th>
                                    </tr>
                                </thead>
                                <tbody id="subjectTableBody">
                                    <?php
                                    for ($i = 0; $i < count($examType); $i++) {
                                        $et = htmlspecialchars($examType[$i] ?? '');
                                        $tm = htmlspecialchars($examTotalMarks[$i] ?? '');
                                        $pm = htmlspecialchars($examPassingMarks[$i] ?? '');
                                        $desc = htmlspecialchars($examDescription[$i] ?? '');
                                        echo "
                                        <tr>
                                            <td><input type='text' class='form-control tAC' value='$et' disabled /></td>
                                            <td><input type='number' class='form-control tAC' value='$tm' disabled /></td>
                                            <td><input type='number' class='form-control tAC' value='$pm' disabled /></td>
                                            <td><input type='text' class='form-control tAC' value='$desc' disabled /></td>
                                        </tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div> <!-- card-body -->
                    </div> 
                </div> 
            </div> 
        </div> 
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<?php require '../../common/footer.php'; ?>
