<?php
require_once '../../common/connectToDB.php';
$conn->begin_transaction();
session_start();
date_default_timezone_set('Asia/Kolkata');
$logTimestamp = date("Y-m-d H:i:s");

$centerManagerName = $_SESSION['userNameCM'] ?? 'Unknown';
$centerManagerId = $_SESSION['userid'] ?? '0';
$userType = $_SESSION['userRightsAPT'] ?? 'APT';

try {
    if ($_POST['saveFlag'] === 'addScore') {
        $studentScoreDetails = $_POST['studentScoreDetails'];
        $scoreMasterData = $_POST['scoreMasterData'][0];
        $subjectScoreStructure = $_POST['subjectScoreStructure'];

        $examScoreMasterId = $scoreMasterData['masterScoreId'];
        $batchId = $scoreMasterData['batchId'];
        $batchName = $scoreMasterData['batchName'];
        $academicYear = $scoreMasterData['academicYear'];
        $semester = $scoreMasterData['semester'];
        $subjectId = $scoreMasterData['subjectId'];
        $subjectName = $scoreMasterData['subjectName'];
        $resultStatus = $scoreMasterData['resultStatus'];

        // ✅ Get next Row ID from seriesnumber
        $seriesRes = $conn->query("SELECT seriesValue FROM seriesnumber WHERE seriesName = 'examScoreRowId'");
        if (!$seriesRes)
            throw new Exception("Series query failed: " . $conn->error);
        $nextRowId = (int) $seriesRes->fetch_assoc()['seriesValue'];

        // ✅ Clear old scores for this exam master (optional)
        $conn->query("DELETE FROM examinationscore WHERE examScoreMasterId = '$examScoreMasterId'");

        // ✅ Loop and insert each score with pass/fail
        foreach ($studentScoreDetails as $student) {
            $studentId = $conn->real_escape_string($student['studentId']);
            $rollNo = $conn->real_escape_string($student['rollNo']);
            $firstName = $conn->real_escape_string($student['studentFirstName']);
            $lastName = $conn->real_escape_string($student['studentLastName']);
            $scores = $student['scores'];

            foreach ($scores as $examType => $score) {
                $scoreInt = (int) $score;

                // Find pass mark for this exam type
                $passMark = 0;
                foreach ($subjectScoreStructure as $row) {
                    if ($row['examType'] === $examType) {
                        $passMark = (int) $row['examPassingMarks'];
                        break;
                    }
                }

                $status = ($scoreInt >= $passMark) ? 'PASS' : 'FAIL';

                $insert = "INSERT INTO examinationscore (
                    examScoreMasterId, examScoreRowId, studentId, rollNo, studentFirstName, studentLastName,
                    academicYear, batchId, batchName, semester,
                    subjectId, subjectName, examType, examScore, internalExamStatus, created_at
                ) VALUES (
                    '$examScoreMasterId', '$nextRowId', '$studentId', '$rollNo', '$firstName', '$lastName',
                    '$academicYear', '$batchId', '$batchName', '$semester',
                    '$subjectId', '$subjectName', '$examType', '$scoreInt', '$status', '$logTimestamp'
                )";

                if (!$conn->query($insert)) {
                    throw new Exception("Insert failed: " . $conn->error);
                }

                $nextRowId++;
            }
        }

        // ✅ Update result status in master table
        $conn->query("UPDATE examinationscoremaster SET resultStatus = '$resultStatus' WHERE examScoreMasterId = '$examScoreMasterId'");

        // ✅ Update seriesnumber with latest rowId
        $conn->query("UPDATE seriesnumber SET seriesValue = $nextRowId WHERE seriesName = 'examScoreRowId'");

        $conn->commit();
        echo "Scores saved successfully.";
    } else {
        throw new Exception("Invalid saveFlag.");
    }
} catch (Exception $e) {
    $conn->rollback();
    echo "Error: " . $e->getMessage();
}
?>