var subjectscoreID = "",
  subjectId = "",
  subjectName = "",
  examType = "",
  totalMarks = "",
  passingMarks = "",
  description = "";
var sumTotalMarks = "";
var sumPassMarks = "";

function loadDataDropdown(selectName, results, centerId) {
  var theSelect = document.getElementById(selectName);

  var options = theSelect.getElementsByTagName("option");
  theSelect.innerHTML = "";

  for (var i = 0; i < results.length; i++) {
    options = document.createElement("option");
    if (selectName.includes("semester")) {
      if (i == 0) {
        options.value = options.text = "SELECT SEMESTER";
        theSelect.add(options);
        options.selected = true;
        options = document.createElement("option");
      }
      options.value = results[i].semesterValue.toUpperCase();
      options.text = results[i].semesterValue.toUpperCase();
      theSelect.add(options);
    }
  }
  return;
}

function selectDropdownValue(selectName, val) {
  let theSelect = document.getElementById(selectName);
  for (let j = 0; j < theSelect.options.length; j++) {
    let optVal = theSelect.options[j].value.trim();
    if (optVal == val.trim()) {
      theSelect.options[j].selected = true;
    }
  }
  return;
}

// function addTableRowEdit(masterList, flag) {
//     var mytable = document.getElementById("subjectTableBody");
//     var newRow,
//         newCell;

//     mytable.innerHTML = '';
//     var examTypeList = masterList[0].examType.split("::");
//     var examTotalMarksList = masterList[0].examTotalMarks.split("::");
//     var examPassingMarksList = masterList[0].examPassingMarks.split("::");
//     var examDescription = masterList[0].examDescription.split("::");
//     for /(let i = 0; i < examTypeList.length; i++) {
//         var newRow = document.createElement("tr");
//         mytable.appendChild(newRow);

//         newCell = document.createElement("td");
//         var input = document.createElement("input");
//         input.setAttribute("class", "form-control tAC");
//         input.setAttribute("type", "");
//         input.setAttribute("id", "examType" + i);
//         input.setAttribute("value", examTypeList[i]);
//         input.setAttribute('disabled', 'disabled');
//         newCell.appendChild(input);
//         newRow.appendChild(newCell);

//         newCell = document.createElement("td");
//         var totalMarks = document.createElement("input");
//         totalMarks.setAttribute("class", "form-control tAC");
//         totalMarks.setAttribute("id", "totalMarks" + i);
//         totalMarks.setAttribute("type", "number");
//         totalMarks.setAttribute("placeholder", "Total Marks");
//         totalMarks.setAttribute("value", examTotalMarksList[i]);
//         newCell.appendChild(totalMarks);
//         newRow.appendChild(newCell);

//         newCell = document.createElement("td");
//         var passingMarks = document.createElement("input");
//         passingMarks.setAttribute("class", "form-control tAC");
//         passingMarks.setAttribute("id", "passingMarks" + i);
//         passingMarks.setAttribute("type", "number");
//         passingMarks.setAttribute("placeholder", "Passing Marks");
//         passingMarks.setAttribute("value", examPassingMarksList[i]);
//         newCell.appendChild(passingMarks);
//         newRow.appendChild(newCell);

//         newCell = document.createElement("td");
//         var description = document.createElement("input");
//         description.setAttribute("class", "form-control tAC");
//         description.setAttribute("id", "description" + i);
//         description.setAttribute("type", "text");
//         description.setAttribute("placeholder", "Description");
//         description.setAttribute("value", examDescription[i]);
//         newCell.appendChild(description);
//         newRow.appendChild(newCell);
//     }
// }

function addNewRow() {
  const tableBody = document.getElementById("subjectTableBody");
  const newRow = document.createElement("tr");

  // --- Title ---
  let newCell = document.createElement("td");
  let titleInput = document.createElement("input");
  titleInput.setAttribute("type", "text");
  titleInput.setAttribute("class", "form-control");
  titleInput.setAttribute("name", "title[]");
  titleInput.setAttribute("placeholder", "Enter Title");
  newCell.appendChild(titleInput);
  newRow.appendChild(newCell);

  // --- Total Marks ---
  newCell = document.createElement("td");
  let marksInput = document.createElement("input");
  marksInput.setAttribute("type", "number");
  marksInput.setAttribute("class", "form-control");
  marksInput.setAttribute("name", "marks[]");
  marksInput.setAttribute("placeholder", "Total Marks");
  newCell.appendChild(marksInput);
  newRow.appendChild(newCell);

  // --- Passing Marks ---
  newCell = document.createElement("td");
  let passingInput = document.createElement("input");
  passingInput.setAttribute("type", "number");
  passingInput.setAttribute("class", "form-control");
  passingInput.setAttribute("name", "passingMarks[]");
  passingInput.setAttribute("placeholder", "Passing Marks");
  newCell.appendChild(passingInput);
  newRow.appendChild(newCell);

  // --- Description ---
  newCell = document.createElement("td");
  let descInput = document.createElement("input");
  descInput.setAttribute("type", "text");
  descInput.setAttribute("class", "form-control");
  descInput.setAttribute("name", "description[]");
  descInput.setAttribute("placeholder", "Description");
  newCell.appendChild(descInput);
  newRow.appendChild(newCell);

  // --- Remove Button ---
  newCell = document.createElement("td");
  let removeButton = document.createElement("button");
  removeButton.setAttribute("type", "button");
  removeButton.setAttribute("class", "btn btn-danger");
  removeButton.setAttribute("onclick", "removeRow(this)");

  let icon = document.createElement("i");
  icon.setAttribute("class", "fas fa-trash");
  removeButton.appendChild(icon);

  newCell.appendChild(removeButton);
  newRow.appendChild(newCell);

  tableBody.appendChild(newRow);
  updateRowButtons();
}

function removeRow(btn) {
  const row = btn.closest("tr");
  row.remove();
}

function addRow(button) {
  const tableBody = document.getElementById("subjectTableBody");

  // Clone last row
  const newRow = button.closest("tr").cloneNode(true);

  // Clear all inputs in new row
  newRow.querySelectorAll("input").forEach((input) => (input.value = ""));

  tableBody.appendChild(newRow);

  updateRowButtons();
}

function updateRowButtons() {
  const tableBody = document.getElementById("subjectTableBody");
  const rows = tableBody.querySelectorAll("tr");

  rows.forEach((row, index) => {
    const actionCell = row.cells[row.cells.length - 1];
    actionCell.innerHTML = "";

    const deleteBtn = document.createElement("button");
    deleteBtn.setAttribute("type", "button");
    deleteBtn.className = "btn btn-danger";
    deleteBtn.setAttribute("onclick", "deleteRow(this)");

    const deleteIcon = document.createElement("i");
    deleteIcon.className = "fa fa-trash";
    deleteBtn.appendChild(deleteIcon);

    actionCell.appendChild(deleteBtn);

    if (index === 0) {
      const addBtn = document.createElement("button");
      addBtn.setAttribute("type", "button");
      addBtn.className = "btn btn-success ms-1";
      addBtn.setAttribute("onclick", "addRow(this)");

      const addIcon = document.createElement("i");
      addIcon.className = "fa fa-plus";
      addBtn.appendChild(addIcon);

      actionCell.insertBefore(addBtn, deleteBtn);
    }
  });
}

const deletedExamTypes = [];

function deleteRow(button) {
  const row = button.closest("tr");
  const examTypeInput = row.querySelector("input[name='title[]']");

  if (examTypeInput && examTypeInput.value.trim() !== "") {
    deletedExamTypes.push(examTypeInput.value.trim());
  }

  const tableBody = document.getElementById("subjectTableBody");
  const rows = tableBody.querySelectorAll("tr");

  if (rows.length > 1) {
    row.remove();
    updateRowButtons(); // <- This makes sure the plus button is added to the new last row
  }
}

function showError(id, color, message) {
  if (id != "") document.getElementById(id).style.backgroundColor = color;
  document.getElementById("errorMessage").innerHTML = message;
}

function setHeaders() {
  subjectId = "";
  semester = "";
  subjectName = "";
  subjectGrandTotalMarks = "";
  (subjectTotalPassMarks = ""), (examType = "");
  totalMarks = "";
  passingMarks = "";
  description = "";

  subjectId = document.getElementById("subjectId").value.trim();
  semester = document.getElementById("semester").value.trim().toUpperCase();
  subjectName = document
    .getElementById("subjectName")
    .value.trim()
    .toUpperCase();
  subjectGrandTotalMarks = document
    .getElementById("subjectGrandTotalMarks")
    .value.trim();
  subjectTotalPassMarks = document
    .getElementById("subjectTotalPassMarks")
    .value.trim();
  return 1;
}

function resetTableErrors() {
  var table = document.getElementById("subjectTableBody");
  for (var r = 0, n = table.rows.length; r < n; r++) {
    table.rows[r].cells[0].getElementsByTagName(
      "input"
    )[0].style.backgroundColor = "";

    table.rows[r].cells[1].getElementsByTagName(
      "input"
    )[0].style.backgroundColor = "";
    table.rows[r].cells[2].getElementsByTagName(
      "input"
    )[0].style.backgroundColor = "";
    table.rows[r].cells[3].getElementsByTagName(
      "input"
    )[0].style.backgroundColor = "";
  }
}

function addNewSubjectValidation() {
  // select semester validation
  if (semester == "SELECT SEMESTER") {
    showError("semester", "#ffc2b3", "Select Semester");
    return 0;
  } else showError("semester", "", "");

  // subject name validation
  if (subjectName.length <= 0) {
    showError("subjectName", "#ffc2b3", "Enter Subject Name");
    return 0;
  } else showError("subjectName", "", "");

  // Total Marks validation
  if (subjectGrandTotalMarks.length <= 0) {
    showError("subjectGrandTotalMarks", "#ffc2b3", "Enter Total Marks");
    return 0;
  } else showError("subjectGrandTotalMarks", "", "");

  if (parseInt(subjectGrandTotalMarks) < 0) {
    showError(
      "subjectGrandTotalMarks",
      "#ffc2b3",
      "Total Marks cannot be negative"
    );
    return 0;
  } else showError("subjectGrandTotalMarks", "", "");
  if (subjectTotalPassMarks.length <= 0) {
    showError("subjectTotalPassMarks", "#ffc2b3", "Enter Passing Marks");
    return 0;
  } else showError("subjectTotalPassMarks", "", "");

  if (parseInt(subjectTotalPassMarks) < 0) {
    showError(
      "subjectTotalPassMarks",
      "#ffc2b3",
      "Passing Marks cannot be negative"
    );
    return 0;
  } else showError("subjectTotalPassMarks", "", "");
  if (parseInt(subjectTotalPassMarks) > parseInt(subjectGrandTotalMarks)) {
    showError(
      "subjectTotalPassMarks",
      "#ffc2b3",
      "Passing Marks cannot exceed Total Marks"
    );
    return 0;
  } else showError("subjectTotalPassMarks", "", "");

  // Validate each exam row
  const table = document.getElementById("subjectTableBody");
  for (let r = 0; r < table.rows.length; r++) {
    const cells = table.rows[r].cells;
    const title = cells[0].querySelector("input").value.trim();
    const total = cells[1].querySelector("input").value.trim();
    const pass = cells[2].querySelector("input").value.trim();

    if (!title) {
      cells[0].querySelector("input").style.backgroundColor = "#ffc2b3";
      showError("", "", "Title cannot be empty in row " + (r + 1));
      return 0;
    }

    if (!total || parseInt(total) < 0) {
      cells[1].querySelector("input").style.backgroundColor = "#ffc2b3";
      showError("", "", "Invalid total marks in row " + (r + 1));
      return 0;
    }

    if (!pass || parseInt(pass) < 0 || parseInt(pass) > parseInt(total)) {
      cells[2].querySelector("input").style.backgroundColor = "#ffc2b3";
      showError("", "", "Invalid passing marks in row " + (r + 1));
      return 0;
    }
  }

  showError("", "", "");
  return 1;
}
function validateDescriptions() {
  const table = document.getElementById("subjectTableBody");

  for (let r = 0; r < table.rows.length; r++) {
    const descriptionInput = table.rows[r].cells[3].querySelector("input");
    if (!descriptionInput.value.trim()) {
      descriptionInput.style.backgroundColor = "#ffc2b3";
      alert("Description cannot be empty in row " + (r + 1));
      return false;
    } else {
      descriptionInput.style.backgroundColor = "";
    }
  }
  return true;
}

function marksBreakupTableValidation() {
  resetTableErrors();
  var table = document.getElementById("subjectTableBody");
  var isValid = true;

  for (var r = 0, n = table.rows.length; r < n; r++) {
    const titleInput = table.rows[r].cells[0].getElementsByTagName("input")[0];
    const totalMarksInput =
      table.rows[r].cells[1].getElementsByTagName("input")[0];
    const passingMarksInput =
      table.rows[r].cells[2].getElementsByTagName("input")[0];
    const descriptionInput =
      table.rows[r].cells[3].getElementsByTagName("input")[0];

    // Exam Type / Title validation
    if (titleInput.value.trim() === "") {
      titleInput.style.backgroundColor = "#ffc2b3";
      showError("", "", "Enter Exam Type in all rows");
      isValid = false;
    }

    // Total Marks validation
    if (
      totalMarksInput.value.trim() === "" ||
      parseInt(totalMarksInput.value) < 0
    ) {
      totalMarksInput.style.backgroundColor = "#ffc2b3";
      showError("", "", "Enter valid Total Marks in all rows");
      isValid = false;
    }

    // Passing Marks validation
    if (
      passingMarksInput.value.trim() === "" ||
      parseInt(passingMarksInput.value) < 0
    ) {
      passingMarksInput.style.backgroundColor = "#ffc2b3";
      showError("", "", "Enter valid Passing Marks in all rows");
      isValid = false;
    }

    // Optional: Description can be empty, but validate length if needed
    if (descriptionInput.value.trim().length > 100) {
      descriptionInput.style.backgroundColor = "#ffc2b3";
      showError("", "", "Description too long (max 100 characters)");
      isValid = false;
    }
  }

  if (!isValid) return 0;

  showError("", "", "");
  return 1;
}

let subjectScoreArray = [];

function prepareTableData() {
  subjectScoreArray = []; // reset array
  let table = document.getElementById("subjectTableBody");

  for (let r = 0, n = table.rows.length; r < n; r++) {
    let tempExamType = table.rows[r].cells[0]
      .getElementsByTagName("input")[0]
      .value.toUpperCase();
    let tempTotalMarks =
      table.rows[r].cells[1].getElementsByTagName("input")[0].value;
    let tempPassingMarks =
      table.rows[r].cells[2].getElementsByTagName("input")[0].value;
    let tempDescription =
      table.rows[r].cells[3].getElementsByTagName("input")[0].value;

    subjectScoreArray.push({
      examType: tempExamType,
      totalMarks: tempTotalMarks,
      passingMarks: tempPassingMarks,
      description: tempDescription,
    });
  }

  return 1;
}

function calculateSumMarks() {
  grandTotalMarks = 0;
  grandPassMarks = 0;

  const table = document.getElementById("subjectTableBody");

  for (let r = 0, n = table.rows.length; r < n; r++) {
    let total = parseFloat(
      table.rows[r].cells[1].getElementsByTagName("input")[0].value
    );
    let pass = parseFloat(
      table.rows[r].cells[2].getElementsByTagName("input")[0].value
    );

    if (!isNaN(total)) grandTotalMarks += total;
    if (!isNaN(pass)) grandPassMarks += pass;
  }

  subjectGrandTotalMarks = parseFloat(subjectGrandTotalMarks);
  subjectTotalPassMarks = parseFloat(subjectTotalPassMarks);
}

function showError(id, color, message) {
  if (id != "") document.getElementById(id).style.backgroundColor = color;
  document.getElementById("errorMessage").innerHTML = message;
}

function updateSubject() {
  // var flagForEdit=true;
  document.getElementById("editButton").disabled = true;
  var saveFlag = "editSubject";
  if (setHeaders() == 0) {
    document.getElementById("editButton").disabled = false;
    return 0;
  }
  if (addNewSubjectValidation() == 0) {
    document.getElementById("editButton").disabled = false;
    return 0;
  }
  if (marksBreakupTableValidation() == 0) {
    document.getElementById("editButton").disabled = false;
    return 0;
  }
  if (prepareTableData() == 0) {
    document.getElementById("editButton").disabled = false;
    return 0;
  }
  calculateSumMarks();
  if (confirm("Are you sure you want to edit subject details.")) {
    document.getElementById("successMessage").innerHTML =
      "Updating Details. Please wait...";
    document.getElementById("editButton").disabled = true;
    $.post(
      "updateSubject.php",
      {
        saveFlag: saveFlag,
        subjectscoreID: subjectscoreID,
        subjectId: subjectId,
        semester: semester,
        subjectName: subjectName,
        subjectGrandTotalMarks: subjectGrandTotalMarks,
        subjectTotalPassMarks: subjectTotalPassMarks,
        subjectScoreArray: subjectScoreArray,
      },
      function (response) {
        console.log(errorMessage);
        document.getElementById("successMessage").innerHTML = response;
        document.getElementById("editButton").disabled = false;
        console.log(errorMessage);
        //location.reload();
      }
    );
  } else document.getElementById("editButton").disabled = false;
}
