<?php
require_once '../../common/connectToDB.php';

header('Content-Type: application/json');

$response = [];

if (isset($_POST['rowId']) && is_numeric($_POST['rowId'])) {
    $rowId = (int) $_POST['rowId'];

    // Soft delete: set deleted_at to current datetime
    $query = "UPDATE subjectscore SET deleted_at = NOW(6) WHERE subjectscoreId = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $rowId);

    if ($stmt->execute()) {
        $response['success'] = true;
        $response['message'] = "Row soft deleted successfully.";
    } else {
        $response['success'] = false;
        $response['message'] = "Failed to update deleted_at field.";
    }

    $stmt->close();
} else {
    $response['success'] = false;
    $response['message'] = "Invalid or missing row ID.";
}

echo json_encode($response);
?>
