var subjectId = '',
    semester = '',
    subjectName = '',
    subjectGrandTotalMarks = '',
    examType = '',
    totalMarks = '',
    passingMarks = '',
    description = '';

var sumTotalMarks = '';

function loadDataDropdown(selectName, results, centerId) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            if (i == 0) {
                options.value = options.text = "SELECT SEMESTER";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].semesterValue.toUpperCase();
            options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function selectDropdownValue(selectName, val) {
    let theSelect = document.getElementById(selectName);
    for (let j = 0; j < theSelect.options.length; j++) {
        let optVal = theSelect.options[j].value.trim();
        if (optVal == val.trim()) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function addTableRowEdit(masterList, flag) {
    var mytable = document.getElementById("subjectTableBody");
    var newRow,
        newCell;

    mytable.innerHTML = '';
    var examTypeList = masterList[0].examType.split("::");
    var examTotalMarksList = masterList[0].examTotalMarks.split("::");
    var examPassingMarksList = masterList[0].examPassingMarks.split("::");
    var examDescription = masterList[0].examDescription.split("::");
    for (let i = 0; i < examTypeList.length; i++) {
        var newRow = document.createElement("tr");
        mytable.appendChild(newRow);

        newCell = document.createElement("td");
        var input = document.createElement("input");
        input.setAttribute("class", "form-control tAC");
        input.setAttribute("type", "");
        input.setAttribute("id", "examType" + i);
        input.setAttribute("value", examTypeList[i]);
        input.setAttribute('disabled', 'disabled');
        newCell.appendChild(input);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var totalMarks = document.createElement("input");
        totalMarks.setAttribute("class", "form-control tAC");
        totalMarks.setAttribute("id", "totalMarks" + i);
        totalMarks.setAttribute("type", "number");
        totalMarks.setAttribute("placeholder", "Total Marks");
        totalMarks.setAttribute("value", examTotalMarksList[i]);
        newCell.appendChild(totalMarks);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var passingMarks = document.createElement("input");
        passingMarks.setAttribute("class", "form-control tAC");
        passingMarks.setAttribute("id", "passingMarks" + i);
        passingMarks.setAttribute("type", "number");
        passingMarks.setAttribute("placeholder", "Passing Marks");
        passingMarks.setAttribute("value", examPassingMarksList[i]);
        newCell.appendChild(passingMarks);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var description = document.createElement("input");
        description.setAttribute("class", "form-control tAC");
        description.setAttribute("id", "description" + i);
        description.setAttribute("type", "text");
        description.setAttribute("placeholder", "Description");
        description.setAttribute("value", examDescription[i]);
        newCell.appendChild(description);
        newRow.appendChild(newCell);
    }
}

function addTableBody() {
    var mytable = document.getElementById("subjectTableBody"),
        newRow,
        newCell;

    for (i = 0; i < 4; i++) {
        var newRow = document.createElement("tr");
        mytable.appendChild(newRow);

        // exam type
        newCell = document.createElement("td");
        var input = document.createElement("input");
        input.setAttribute("class", "form-control tAC");
        input.setAttribute("id", "examType" + i);
        if (i == 0) input.setAttribute("value", "CE-1");
        if (i == 1) input.setAttribute("value", "CE-2");
        if (i == 2) input.setAttribute("value", "ATTENDANCE MARKS");
        if (i == 3) input.setAttribute("value", "SEMESTER EXAM");
        input.setAttribute("disabled", "disabled");
        newCell.appendChild(input);
        newRow.appendChild(newCell);

        // total marks
        newCell = document.createElement("td");
        var totalMarks = document.createElement("input");
        totalMarks.setAttribute("class", "form-control tAC");
        totalMarks.setAttribute("id", "totalMarks" + i);
        totalMarks.setAttribute("type", "number");
        totalMarks.setAttribute("placeholder", "Total Marks");
        newCell.appendChild(totalMarks);
        newRow.appendChild(newCell);

        // passing marks
        newCell = document.createElement("td");
        var passingMarks = document.createElement("input");
        passingMarks.setAttribute("class", "form-control tAC");
        passingMarks.setAttribute("id", "passingMarks" + i);
        passingMarks.setAttribute("type", "number");
        passingMarks.setAttribute("placeholder", "Passing Marks");
        newCell.appendChild(passingMarks);
        newRow.appendChild(newCell);

        // description
        newCell = document.createElement("td");
        var description = document.createElement("input");
        description.setAttribute("class", "form-control tAC");
        description.setAttribute("id", "description" + i);
        description.setAttribute("type", "text");
        description.setAttribute("placeholder", "Description");
        newCell.appendChild(description);
        newRow.appendChild(newCell);
    }
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    subjectId = '';
    semester = '';
    subjectName = '';
    subjectGrandTotalMarks = '';
    examType = '';
    totalMarks = '';
    passingMarks = '';
    description = '';

    subjectId = document.getElementById("subjectId").value.trim();
    semester = document.getElementById("semester").value.trim().toUpperCase();
    subjectName = document.getElementById("subjectName").value.trim().toUpperCase();
    subjectGrandTotalMarks = document.getElementById("subjectGrandTotalMarks").value.trim();

    return 1;
}

function resetTableErrors() {
    var table = document.getElementById("subjectTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[0].getElementsByTagName("input")[0].style.backgroundColor = "";

        table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
}

function addNewSubjectValidation() {
    // select semester validation
    if (semester == "SELECT SEMESTER") {
        showError('semester', '#ffc2b3', "Select Semester");
        return 0;
    } else showError('semester', '', '');

    // subject name validation
    if (subjectName.length <= 0) {
        showError('subjectName', '#ffc2b3', "Enter Subject Name");
        return 0;
    } else showError('subjectName', '', '');

    // Total Marks validation
    if (subjectGrandTotalMarks.length <= 0) {
        showError('subjectGrandTotalMarks', '#ffc2b3', "Enter Total Marks");
        return 0;
    } else showError('subjectGrandTotalMarks', '', '');

    if (parseInt(subjectGrandTotalMarks) < 0) {
        showError('subjectGrandTotalMarks', '#ffc2b3', "Total Marks cannot be negative");
        return 0;
    } else showError('subjectGrandTotalMarks', '', '');

    showError('', '', '');
    return 1;
}

function marksBreakupTableValidation() {
    resetTableErrors();
    var table = document.getElementById("subjectTableBody");

    for (var r = 0, n = table.rows.length; r < n; r++) {
        // Total Marks   
        if (table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter Total Marks.");
            return 0;
        } else table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[1].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Total Marks Can Not be Nagative.");
            return 0;
        } else table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

        // Passing Marks
        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter Passing Marks.");
            return 0;
        } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (parseFloat(table.rows[r].cells[2].getElementsByTagName("input")[0].value) > parseFloat(table.rows[r].cells[1].getElementsByTagName("input")[0].value)) {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Passing Marks cannot be greater than total marks.");
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value.trim() < 0) {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Passing Marks Can Not be Nagative.");
            return 0;
        } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        // Description
        if (table.rows[r].cells[3].getElementsByTagName("input")[0].value.trim() == '') {
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Enter Description.");
            return 0;
        } else table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
    showError('', '', '');
    return 1;
}

function prepareTableData() {
    var table = document.getElementById("subjectTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempExamType = table.rows[r].cells[0].getElementsByTagName("input")[0].value.toUpperCase();
        let tempTotalMarks = table.rows[r].cells[1].getElementsByTagName("input")[0].value;
        let tempPassingMarks = table.rows[r].cells[2].getElementsByTagName("input")[0].value;
        let tempDescription = table.rows[r].cells[3].getElementsByTagName("input")[0].value;
        examType += tempExamType + "::";
        totalMarks += tempTotalMarks + "::";
        passingMarks += tempPassingMarks + "::";
        description += tempDescription + "::";
    }
    examType = examType.slice(0, -2).trim();
    totalMarks = totalMarks.slice(0, -2).trim();
    passingMarks = passingMarks.slice(0, -2).trim();
    description = description.slice(0, -2).trim();

    totalMarksList = totalMarks.split("::");
    sumTotalMarks = 0;
    if (totalMarksList[0] != '') {
        for (i = 0; i < totalMarksList.length; i++) {
            sumTotalMarks = sumTotalMarks += parseInt(totalMarksList[i]);
        }
    }
    return 1;
}

function checkTotal() {
    if (subjectGrandTotalMarks != sumTotalMarks) {
        showError('errorMessage', '', "Sum of Marks doesn't match with the total declared");
        return 0;
    }
    return 1;
}

function updateSubject() {
    // var flagForEdit=true;
    document.getElementById("editButton").disabled = true;
    var saveFlag = 'editSubject';
    if (setHeaders() == 0) {
        document.getElementById("editButton").disabled = false;
        return 0;
    }
    if (addNewSubjectValidation() == 0) {
        document.getElementById("editButton").disabled = false;
        return 0;
    }
    if (marksBreakupTableValidation() == 0) {
        document.getElementById("editButton").disabled = false;
        return 0;
    }
    if (prepareTableData() == 0) {
        document.getElementById("editButton").disabled = false;
        return 0;
    }
    if (checkTotal() == 0) {
        document.getElementById("editButton").disabled = false;
        return 0;
    }
    if (confirm("Are you sure you want to edit subject details.")) {
        document.getElementById('successMessage').innerHTML = 'Updating Details. Please wait...';
        document.getElementById("editButton").disabled = true;
        $.post('updateSubject.php', {
            'saveFlag': saveFlag,
            'subjectId': subjectId,
            'semester': semester,
            'subjectName': subjectName,
            'subjectGrandTotalMarks': subjectGrandTotalMarks,
            'examType': examType,
            'totalMarks': totalMarks,
            'passingMarks': passingMarks,
            'description': description
        }, function (data) {
            document.getElementById('successMessage').innerHTML = ' Details Successfuly Updated. Please wait The page will get auto-refresh...';
            document.getElementById("editButton").disabled = false;
            location.reload();
        });
    } else document.getElementById("editButton").disabled = false;
}