<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';

require_once '../../common/connectToDB.php';
$encodedKey_studentId = base64_encode('studentId');
if (isset($_GET[$encodedKey_studentId])) {
    $studentId = base64_decode($_GET[$encodedKey_studentId]);
}

$sql    = "SELECT * FROM scholarshipapplication WHERE studentId = $studentId; ";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $scholarshipId = $row['scholarshipId'];
        $firstRow = $row;
    }
}

$studentFee = [];
$sql2    = "SELECT * FROM studentfee WHERE studentId = $studentId; ";
$result2 = $conn->query($sql2);

if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($studentFee, $row2);
    }
}

$scholarShipStatus = "";
if ($firstRow['scholarshipFee'] == '0' || $firstRow['scholarshipFee'] == NULL) {
    $scholarShipStatus = "PENDING";
} else if ($firstRow['scholarshipFee'] == '-1') {
    $scholarShipStatus = "REJECT";
} else {
    $scholarShipStatus = "APPROVED";
}

require '../../common/navbar.php'; ?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-10 mt-3">
                                    <h3 class="card-title">Scholarship Details</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <!--  -->
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Application Date:</label>
                                        <input type="text" class="form-control" id="applicationDate"
                                            value="<?php echo $firstRow['applicationDate'] ?>" disabled>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Scholarship Status</label>
                                        <br>
                                        <select class="form-control custom-select" id="scholarshipStatus"
                                            onchange="scholarshipAmount()">
                                            <option value="SELECT STATUS">SELECT STATUS</option>
                                            <option value="PENDING">PENDING</option>
                                            <option value="REJECT">REJECT</option>
                                            <option value="APPROVED">APPROVED</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-1 mt-4">
                                    <input type="button" class="btn btn-danger" value="Update" onclick="editStatus()"
                                        id="saveButton" />
                                </div>
                                <div class="col-md-3">
                                    <label id="scholarshipAmountLabel" hidden>Scholarship Amount</label>
                                    <input type="number" class="form-control" id="scholarshipAmount"
                                        placeholder="Enter scholarship amount" hidden>
                                </div>
                                <div class="col-md-4 mt-4">
                                    <p id='errorMessage' class="text-center"
                                        style="color: red; font-size: 1.2em;   text-align: center;">
                                    </p>
                                </div>
                            </div>
                            <!--  -->
                            <div class="row">
                                <table class="table table-striped tAC" id="documentTable">
                                    <thead>
                                        <tr>
                                            <th style="width:5%;">Sr No.</th>
                                            <th style="width:35%;">Document</th>
                                            <th style="width:25%;">Document Type</th>
                                            <th style="width:35%;">Document Preview</th>
                                        </tr>
                                    </thead>
                                    <tbody id="documentTable">
                                        <tr>
                                            <td>
                                                <div class="form-group">
                                                    <label>1</label>
                                                </div>
                                            </td>
                                            <td>
                                                <label>Parents Id Proof.</label>
                                            </td>
                                            <td>
                                                <label id="idProofType"><?php echo $firstRow['idProofType'] ?></label>
                                            </td>
                                            <td>
                                                <div class="form-group" id="idProofPreview">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="form-group">
                                                    <label>2</label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group">
                                                    <label>Parents Address Proof.</label>
                                                </div>
                                            </td>
                                            <td>
                                                <label
                                                    id="addressProofType"><?php echo $firstRow['addressProofType'] ?></label>
                                            </td>
                                            <td>
                                                <div class="form-group" id="addressProofPreview">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="form-group">
                                                    <label>3</label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group">
                                                    <label>Parents Last Year Income Proof</label>
                                                </div>
                                            </td>
                                            <td>
                                                <label
                                                    id="lastYearITProofType"><?php echo $firstRow['lastYearIncomeTaxProofType'] ?></label>
                                            </td>
                                            <td>
                                                <div class="form-group" id="lastYearITProofPreview">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="form-group">
                                                    <label>4</label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group">
                                                    <label>Parents Second Last Year Income Proof</label>
                                                </div>
                                            </td>
                                            <td>
                                                <label
                                                    id="secondLastYearITProofType"><?php echo $firstRow['secondLastYearIncomeTaxProofType'] ?></label>
                                            </td>
                                            <td>
                                                <div class="form-group" id="secondLastYearITProofPreview">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="form-group">
                                                    <label>5</label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group">
                                                    <label>Parents Third Last Year Income Proof</label>
                                                </div>
                                            </td>
                                            <td>
                                                <label
                                                    id="thirdLastYearITProofType"><?php echo $firstRow['thirdLastYearIncomeTaxProofType'] ?></label>
                                            </td>
                                            <td>
                                                <div class="form-group" id="thirdLastYearITProofPreview">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="scholarship.js?v=<?php echo $fileVersion; ?>"></script>

<script>
studentId = <?php echo json_encode($studentId) ?>;
var studentFee = <?php echo json_encode($studentFee) ?>;
var scholarshipStatus = <?php echo json_encode($scholarShipStatus) ?>;
var tempIdProof = "<?php echo $firstRow['idProof']; ?>";
var tempAddress = "<?php echo $firstRow['addressProof']; ?>";
var tempLastYearITPD = "<?php echo $firstRow['lastYearIncomeTaxProof']; ?>";
var tempSecondLastYearITPD = "<?php echo $firstRow['secondLastYearIncomeTaxProof'];?>";
var tempThirdLastYearITPD = "<?php echo $firstRow['thirdLastYearIncomeTaxProof']; ?>";

$(document).ready(function() {
    if (scholarshipStatus == 'APPROVED') {
        document.getElementById("scholarshipAmount").type = "text";
        document.getElementById("scholarshipAmount").value =
            '<?php echo 'Rs.' . $firstRow['scholarshipFee']; ?>';
        document.getElementById("scholarshipAmount").hidden = false;
        document.getElementById("scholarshipAmountLabel").hidden = false;
        document.getElementById("scholarshipAmount").disabled = true;
    } else {
        document.getElementById("scholarshipAmount").type = "number";
    }
    if (tempIdProof.length > 0) {
        var test = document.createElement("a");
        test.href = "../../../dist/img/scholarshipDocuments/" + studentId + "/" + tempIdProof;
        test.target = '_blank';
        test.title = 'Click hear to view the Document';
        test.className = 'btn btn-primary fS10 p10 mL10 tAC';

        var icon = document.createElement("i");
        icon.className = 'fas fa-eye';

        document.getElementById("idProofPreview").appendChild(test);
        test.appendChild(icon);
    }
    if (tempAddress.length > 0) {
        var test = document.createElement("a");
        test.href = "../../../dist/img/scholarshipDocuments/" + studentId + "/" + tempAddress;
        test.target = '_blank';
        test.title = 'Click hear to view the Document';
        test.className = 'btn btn-primary fS10 p10 mL10 tAC';

        var icon = document.createElement("i");
        icon.className = 'fas fa-eye';

        document.getElementById("addressProofPreview").appendChild(test);
        test.appendChild(icon);
    }
    if (tempLastYearITPD.length > 0) {
        var test = document.createElement("a");
        test.href = "../../../dist/img/scholarshipDocuments/" + studentId + "/" + tempLastYearITPD;
        test.target = '_blank';
        test.title = 'Click hear to view the Document';
        test.className = 'btn btn-primary fS10 p10 mL10 tAC';

        var icon = document.createElement("i");
        icon.className = 'fas fa-eye';

        document.getElementById("lastYearITProofPreview").appendChild(test);
        test.appendChild(icon);
    }
    if (tempSecondLastYearITPD.length > 0) {
        var test = document.createElement("a");
        test.href = "../../../dist/img/scholarshipDocuments/" + studentId + "/" + tempSecondLastYearITPD;
        test.target = '_blank';
        test.title = 'Click hear to view the Document';
        test.className = 'btn btn-primary fS10 p10 mL10 tAC';

        var icon = document.createElement("i");
        icon.className = 'fas fa-eye';

        document.getElementById("secondLastYearITProofPreview").appendChild(test);
        test.appendChild(icon);
    }
    if (tempThirdLastYearITPD.length > 0) {
        var test = document.createElement("a");
        test.href = "../../../dist/img/scholarshipDocuments/" + studentId + "/" + tempThirdLastYearITPD;
        test.target = '_blank';
        test.title = 'Click hear to view the Document';
        test.className = 'btn btn-primary fS10 p10 mL10 tAC';

        var icon = document.createElement("i");
        icon.className = 'fas fa-eye';

        document.getElementById("thirdLastYearITProofPreview").appendChild(test);
        test.appendChild(icon);
    }
});
selectDropdownValue("scholarshipStatus", '<?php echo $scholarShipStatus ?>');
</script>

<?php require '../../common/footer.php'; ?>