<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../../loginPage.php');
    exit;
}

require_once '../../../common/connectToDB.php';
require '../../../common/header.php';
require '../../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PAYMENT HISTORY</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="paymentHistoryTable">
                                <thead>
                                    <tr>
                                        <th>
                                            PAYMENT ID
                                        </th>
                                        <th>
                                            PAYMENT DATE
                                        </th>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT NAME
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            UNIT NO
                                        </th>
                                        <th>
                                            AMOUNT PAID
                                        </th>
                                        <th>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../../common/connectToDB.php';
                                    $sql = "SELECT DISTINCT p.paymentId,p.accountsId,p.assignmentId,p.paymentDate,p.amountPaid,a.semester,a.subjectName,p.facultyName,ac.unitNo,p.facultyBankName,ac.paymentType,p.companyBankName,p.companyAccountNo,p.transactionId,p.amountPaid,p.tdsPercent,p.notes,(SELECT (CAST(SUM(a2.totalMinutes) AS DECIMAL (10 , 2 )) * perhrs) FROM remuneration AS r, f_assignment AS a2 WHERE a2.assignmentId = a.assignmentId AND a2.assignmentId = r.assignmentId) AS totalAmount FROM f_payment AS p,f_assignment AS a,f_accounts AS ac WHERE p.assignmentId = a.assignmentId AND p.accountsId = ac.accountsId AND 1 GROUP BY p.paymentId ORDER BY p.paymentId DESC;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = $row['paymentId'];
                                             $paymentDateString = $row["paymentDate"];
                                            $paymentDate = explode(' ', $paymentDateString)[0]; 
                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $row["paymentId"] . "</td>
                                                <td>" . $paymentDate . "</td>
                                                <td>" . $row["assignmentId"] . "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row["subjectName"] . "</td> 
                                                <td>" . $row["facultyName"] . "</td>
                                                <td>" . $row["unitNo"] . "</td>
                                                <td>" . $row['amountPaid'] . "</td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm ' href='#' onclick='showDetails(this.id)' id = " . $id . " title='Click hear to view Payment Details'>
                                                    <i class='fas fa-eye'></i>
                                                </a>
                                                </td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../../plugins/moment/moment.min.js"></script>
<script src="../../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
    $(function() {
        $("#paymentHistoryTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });

    function showDetails(paymentId) {
        encodedValue_paymentId = btoa(paymentId);
        encodedKey_pId = btoa('pId');
        window.location.href = 'viewFacultyPaymentDetails.php?' + encodedKey_pId + "=" + encodedValue_paymentId;
    }
</script>
<?php require '../../../common/footer.php'; ?>