const oldData = {
    facultyId: '',
    facultyFirstName: '',
    facultyLastName: '',
    subjectOffered: '',
    facultyLoginId: '',
    facultyPassword: '',
        facultyType:''


}

function loadOldValues() {
    oldData.facultyId = facultyId;
    oldData.facultyFirstName = document.getElementById('facultyFirstName').value.trim().toUpperCase();
    oldData.facultyLastName = document.getElementById('facultyLastName').value.trim().toUpperCase();
    oldData.subjectOffered = getSelectValues('text', document.getElementById("subjectOffered")).slice(0, -1);
    oldData.facultyLoginId = document.getElementById('facultyLoginId').value.trim();
    oldData.facultyPassword = document.getElementById('facultyPassword').value.trim();
        oldData.facultyType = document.getElementById('facultyType').value.trim();

}

function compareNewValuesWithOld() {
    statement = "UPDATE done in Faculty details. Name- " + oldData.facultyFirstName + " " + oldData.facultyLastName + ". ";
    var flagForStatement = 0;



    if (oldData.facultyFirstName != facultyFirstName) {
        flagForStatement = 1;
        statement = statement + "First name changed from " + oldData.facultyFirstName + " to " + facultyFirstName + "<br>";
    }
    if (oldData.facultyLastName != facultyLastName) {
        flagForStatement = 1;
        statement = statement + "Last name changed from " + oldData.facultyLastName + " to " + facultyLastName + "<br>";
    }
    if (oldData.subjectOffered != subjectOffered) {
        flagForStatement = 1;
        statement = statement + "Subject changed from " + oldData.subjectOffered + " to " + subjectOffered + "<br>";
    }
      if (oldData.facultyType != facultyType) {
        flagForStatement = 1;
        statement = statement + "Subject changed from " + oldData.facultyType + " to " + facultyType + "<br>";
    }
    if (oldData.facultyLoginId != facultyLoginId) {
        flagForStatement = 1;
        statement = statement + "faculty Login Id changed from " + oldData.facultyLoginId + " to " + facultyLoginId + "<br>";
    }
    if (oldData.facultyPassword != facultyPassword) {
        flagForStatement = 1;
        statement = statement + "Password changed from " + oldData.facultyPassword + " to " + facultyPassword + "<br>";
    }

    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    } else showError('', '', '');
    return 1;
}


function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("facultyCenter")) {
            if (i == 0) {
                options.value = options.text = "SELECT CENTER NAME";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].centerId;
            options.text = results[i].centerCode + " - " + results[i].centerLocation.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectOffered")) {
            // if (i == 0) {
            //     options.value = options.text = "SELECT SUBJECT NAME";
            //     theSelect.add(options);
            //     options.selected = true;
            //     options.disabled = true;
            //     options = document.createElement("option");
            // }
            options.value = results[i].subjectId.toUpperCase();
            options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function selectDropdownValue(selectName, val) {
    console.log(val,'dfg')
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function checkForDuplicate(userEmail) {
    flagForDuplicate = false;
    for (i = 0; i < masterFacultyList.length; i++) {
        if (userEmail.trim().toLowerCase() != masterFacultyList[i].emailId.trim().toLowerCase()) flagForDuplicate = true;
    }
}
function facultyValidation() {
    facultyFirstName = '';
    facultyLastName = '';
    facultyLoginId = '';
    facultyPassword = '';
        facultyType='';


    facultyFirstName = document.getElementById('facultyFirstName').value.trim().toUpperCase();
    facultyLastName = document.getElementById('facultyLastName').value.trim().toUpperCase();
    facultyLoginId = document.getElementById('facultyLoginId').value.trim();
    facultyPassword = document.getElementById('facultyPassword').value.trim();
    subjectOffered = getSelectValues('text', document.getElementById("subjectOffered")).slice(0, -1);
        facultyType = document.getElementById('facultyType').value.trim();

    subjectId = getSelectValues('value', document.getElementById("subjectOffered")).slice(0, -1);

    if (facultyFirstName == '') {
        showError('facultyFirstName', '#ff6666', "First name cannot be blank.");
        document.getElementById("editButton").disabled = false;
        return 0;
    } else showError('facultyFirstName', '', '');

    if (facultyLastName == '') {
        showError('facultyLastName', '#ff6666', "Last name cannot be blank.");
        document.getElementById("editButton").disabled = false;
        return 0;
    } else showError('facultyLastName', '', '');

    if (facultyLoginId == '') {
        showError('facultyLoginId', '#ff6666', "Login Id cannot be blank.");
        document.getElementById("editButton").disabled = false;
        return 0;
    } else showError('facultyLoginId', '', '');

    if (!validateEmail(facultyLoginId)) {
        document.getElementById("facultyLoginId").style.backgroundColor = "#ffc2b3";
        showError('facultyLoginId', '', "Login Id is not in correct format.");
        document.getElementById("editButton").disabled = false;
        return 0;
    } else {
        document.getElementById("facultyLoginId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    checkForDuplicate(facultyLoginId);
    if (flagForDuplicate) {
        document.getElementById("editButton").disabled = false;
        showError('facultyLoginId', '#ff6666', "Duplicate Login Id found. Please change it.");
        document.getElementById("editButton").disabled = false;
        return 0;
    } else showError('facultyLoginId', '', '');

    console.log(subjectOffered);
    if (subjectOffered.toUpperCase() == '') {
        showError('subjectOffered', '#ff6666', "Please select valid Subject.");
        return 0;
    } else showError('subjectOffered', '', '');

  if (facultyType.toUpperCase() == '') {
        showError('facultyType', '#ff6666', "Please select valid Subject.");
        return 0;
    } else showError('facultyType', '', '');

    return 1;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == 'text') {
            if (opt.selected) result += opt.text + "|";
        }
        if (flag == 'value') {
            if (opt.selected) result += opt.value + "|";
        }
    }
    return result.trim();
}

function updateFaculty() {
    // document.getElementById("editButton").disabled = true;
    if (facultyValidation() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }
    console.log(facultyId);
    console.log(statement);
    var saveFlag = 'updateFaculty';
    if (confirm("Are you sure you want to add faculty?")) {
        document.getElementById("editButton").disabled = true;
        document.getElementById('successMessage').innerHTML = 'Adding Faculty Please Wait...';
        $.post('updateFaulty.php', {
            'saveFlag': saveFlag,
            'facultyFirstName': facultyFirstName,
            'facultyLastName': facultyLastName,
            'facultyLoginId': facultyLoginId,
            'facultyPassword': facultyPassword,
            'subjectOffered': subjectOffered,
                        'facultyType': facultyType,
 
            'subjectId': subjectId,
            'statement': statement,
            'facultyId':facultyId
        }, function (data) {
            document.getElementById('successMessage').innerHTML = 'Faculty added successfully. Please wait. The page will get auto-refresh...';
            document.getElementById("editButton").disabled = false;
                        console.log(data);

            location.reload();
        });
    }
    else document.getElementById("editButton").disabled = false;
}