<?php
session_start();
if (isset($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';

$masterFacultyList = [];
$sql = "SELECT * FROM faculty";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterFacultyList, $row);
    }
}

$masterSubjectName = [];
$sql4 = "SELECT * FROM subjects;";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) {
    while ($row4 = $result4->fetch_assoc()) {
        array_push($masterSubjectName, $row4);
    }
}


require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB" id="pageTitle">ADD NEW FACULTY</h3>
                            <br>
                            <br>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>First Name <span class="star">*</span></label>
                                        <input type="text" class="form-control" id="facultyFirstName" placeholder='Enter First Name'>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Last Name <span class="star">*</span></label>
                                        <input type="text" class="form-control" id="facultyLastName" placeholder='Enter Last Name'>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Subject Obtained <span class="star">*</span></label>
                                        <select class="select2" multiple id="subjectOffered" style="width: 100%;" data-placeholder="Select Subject">
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Faculty Type <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="facultyType">
                                            <option>SELECT FACULTY TYPE</option>
                                            <option>FULL TIME</option>
                                            <option>PART TIME</option>
                                            <option>VISITING</option>
                                        </select>
                                    </div>
                                </div>
                            

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Login Id <span class="star">*</span></label>
                                    <input type="email" class="form-control" id="facultyLoginId" onchange="checkForDuplicate(this.value)" placeholder='Enter Login Id'>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Password</label>
                                    <input type="text" value="" class="form-control" id="facultyPassword" placeholder='Enter Password' disabled>
                                </div>
                            </div>

                        </div>
                        <div class="card-footer tAC">
                            <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                            <input type="button" class="btn btn-primary" value="Add" id="saveButton" onclick="addFaculty()" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card mT10">
                    <div class="card-header">
                        <h3 class="tAC fSB">Manage Faculty</h3>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group" style="margin-left: 21px;">
                                <label class="fS13">FILTER BY STATUS</label>
                                <select class="select2" multiple="multiple" id="userStatusFilter" data-placeholder="SELECT USER STATUS" style="width: 100%;" onchange="filterOtherDropDown('statusOfuser')" ;>
                                    <option value='ACTIVE' selected>ACTIVE</option>
                                    <option value='BLOCK'>BLOCKED</option>
                                    <option value='TERMINATE'>TERMINATE</option>
                                    <option value='RELIEVE'>RELIEVE</option>
                                    <option value='PENDING'>PENDING</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table  table-striped projects tAC" id="usersTable">
                                    <thead>
                                        <tr>
                                            <th style="width: 15%">
                                                Faculty Name
                                            </th>
                                            <th style="width: 25%">
                                                Login ID
                                            </th>
                                            <th style="width: 15%">
                                                Password
                                            </th>

                                            <th style="width: 10%">
                                                Status
                                            </th>

                                            <th style="width: 10%">
                                                Actions
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql2 = "SELECT * from faculty order by facultyId desc;";
                                        $utilityType = '';
                                        $result = $conn->query($sql2);
                                        if ($result->num_rows > 0) {
                                            while ($row = $result->fetch_assoc()) {


                                                $statusCss = '';
                                                $facultyId = '"' . $row["facultyId"] . '"';
                                                $firstName = '"' . $row["firstName"] . '"';
                                                $lastName = '"' . $row["lastName"] . '"';
                                                $emailId = '"' . $row["emailId"] . '"';
                                                $password = '"' . $row["pass"] . '"';
                                                $flag = '"' . 'profile' . '"';



                                                if ($row["facultyStatus"] == 'BLOCK') $statusCss = 'badge badge-danger';
                                                if ($row["facultyStatus"] == 'ACTIVE') $statusCss = 'badge badge-success';
                                                if ($row["facultyStatus"] == 'TERMINATE') $statusCss = 'badge badge-info';
                                                if ($row["facultyStatus"] == 'RELIEVE') $statusCss = 'badge badge-warning';

                                                echo "
                                                    <tr  class='tAC'>   
                                                        <td>" . $row["firstName"] . ' ' . $row["lastName"] . "</td> 
                                                        <td>" . $row["emailId"] . "</td> 
                                                        <td>" . $row["pass"] . "</td>  
                                                        <td><span class = '" . $statusCss . "'>" . $row["facultyStatus"] . "</span></td> 
                                                        <td class='project-actions'><a class='btn btn-primary btn-sm' href='#' onclick='showDetails($facultyId,$flag)' id=" . $facultyId . "  title='click hear to view Lead Details'>
                                                            <i class='fas fa-eye'></i>
                                                        </a>
                                                       <a class='btn btn-secondary btn-sm' href='#' title='Click here to Edit User.' onclick='userEdit($facultyId)' >
                                                                <i class='fas fa-user-edit'></i>
                                                            </a>
                                                   </td>
                                                            </tr>";
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>
</section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="addFaculty.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var masterFacultyList = <?php echo json_encode($masterFacultyList); ?>;
    var masterSubjectName = <?php echo json_encode($masterSubjectName) ?>;
    document.getElementById('facultyPassword').value = randomString(10, '#a!');
    $(function() {
        $(document).ready(function() {
            $('.select2').select2();
            loadDataDropdown("subjectOffered", masterSubjectName);
        });

        $(document).ready(function() {
            $.fn.dataTableExt.afnFiltering.push(
                function(settings, data, dataIndex) {
                    selecteduserStatus = getSelectValues1('', document.getElementById("userStatusFilter")).trim();

                    var rowuserStatus = data[3].trim();


                    if (selecteduserStatus != '') {
                        inuserStatus = (selecteduserStatus.indexOf(rowuserStatus) != -1) ? rowuserStatus : false;
                    } else inuserStatus = true;
                    return inuserStatus;
                }
            );
            $("#usersTable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "aLengthMenu": [
                    [5, 10, 25, 50, 75, -1],
                    [5, 10, 25, 50, 75, "All"]
                ],
                "pageLength": -1,
                'aSorting': []
            });
        });
    });
</script>

<?php require '../../common/footer.php'; ?>