function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) result += opt.text;
        }
        if (flag == "multiple") {
            if (opt.selected) result += opt.text + "|";
        }
    }
    return result.trim();
}

function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    theSelect.innerHTML = "";

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("facultyNameDropdown")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = options.text = facultyName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("filterBatchCode")) {
            options.text = results[i]['batchTitle'];
            options.value = results[i]['batchId'];
            theSelect.add(options);
        }
    }
    return;
}

function filterOtherDropDown(flag) {
    tempSubject = getSelectValues('multiple', document.getElementById("subjectName")).trim();
    tempSubjectArray = tempSubject.split('|');
    tempSubjectName = [];
    tempFacultyName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "subject") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            for (let j = 0; j < tempSubjectArray.length; j++) {
                if (masterAssignmentData[i].subjectName == tempSubjectArray[j]) {
                    newAssignmentIdArray.push(obj = {
                        "assignmentId": masterAssignmentData[i].assignmentId.trim()
                    });
                }
            }
        }
        loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
        for (let i = 0; i < masterFacultyName.length; i++) {
            tempSubjectList = masterFacultyName[i].facultySubject.split("|");
            for (j = 0; j < tempSubjectList.length; j++) {
                for (k = 0; k < tempSubjectArray.length; k++) {
                    if (tempSubjectList[j] == tempSubjectArray[k]) {
                        tempFacultyName.push(obj = {
                            "firstName": masterFacultyName[i].firstName.trim().toUpperCase(),
                            "lastName": masterFacultyName[i].lastName.trim().toUpperCase()
                        });
                    }
                }
            }
        }
        loadDataDropdown("facultyNameDropdown", tempFacultyName);
    }
    var table = $('#example1').DataTable();
    table.draw();
}

function addReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');

    window.location.href = "addReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}

$("#generateDetails").click(() => {
    filteredSubject = getSelectValues('multiple', document.getElementById("subjectName")).trim().slice(0, -1);
    batchNameFiter = getSelectValues('multiple', document.getElementById("filterBatchCode")).trim().slice(0, -1);
    facultyNameFilter = getSelectValues('multiple', document.getElementById("facultyNameDropdown")).trim().slice(0, -1);
    filteredAssignmentId = getSelectValues('multiple', document.getElementById("assignmentIdDrpodown")).trim().slice(0, -1);
    flag = 'showDetails';

    // if (batchNameFiter == '' && filteredSubject == '' && facultyNameFilter == '' && filteredAssignmentId == '') {
    //     showError('', '#ffc2b3', 'Select atlest 1 dropdown To generate the list.');
    //     return;
    // } else showError('', '', '');

    document.getElementById('generateDetails').disabled = true;
    document.getElementById("successMessage").innerHTML = "Please wait while we load the data.";
    $.post('pendingAssignmentReviewDetails.php', {
        'filteredSubject': filteredSubject.split('|'),
        'batchNameFiter': batchNameFiter.split('|'),
        'facultyNameFilter': facultyNameFilter.split('|'),
        'filteredAssignmentId': filteredAssignmentId.split('|'),
        'flag': flag
    }, function (data) {
        $('#paeDetails').html(data);
        document.getElementById("successMessage").innerHTML = "";
        document.getElementById('generateDetails').disabled = false;
    });
});