function calculateDuration() {
    if (checkTableContentIsNotEmpty() == 0) return 0;
    grandTotalMin = 0;
    var table = document.getElementById("tableBody");
    for (let i = 0; i < table.rows.length; i++) {
        var totalMin = 0;
        sTime = document.getElementById("lectureStartTime" + i).value;
        eTime = document.getElementById("lectureEndTime" + i).value;

        if (sTime > eTime) {
            showError('lectureStartTime' + i, '#ff6666', "");
            showError('lectureEndTime' + i, '#ff6666', "Start Time cannot be greater than End Time.");
            return 0;
        } else {
            showError('lectureStartTime' + i, '', '');
            showError('lectureEndTime' + i, '', '');
        }

        sTime = sTime.split(':');
        eTime = eTime.split(':');

        var hours1 = parseInt(sTime[0], 10),
            hours2 = parseInt(eTime[0], 10),
            mins1 = parseInt(sTime[1], 10),
            mins2 = parseInt(eTime[1], 10);
        var hours = hours2 - hours1,
            mins = 0;

        if (hours < 0) hours = 24 + hours;

        if (mins2 >= mins1) {
            mins = mins2 - mins1;
        } else {
            mins = (mins2 + 60) - mins1;
            hours--;
        }

        if (hours > 0) {
            totalMin = 60 * hours;
        }
        totalMin = parseFloat(totalMin) + parseFloat(mins);
        $("#lectureDuration" + i).val(totalMin);
        grandTotalMin = parseFloat(grandTotalMin) + parseFloat(totalMin);
    }
    document.getElementById("totalHrs").innerHTML = grandTotalMin;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
}

function checkTableContentIsNotEmpty() {
    resetTableErrors();
    const table = document.getElementById("tableBody");

    if (table.rows[0].cells[0].className != "dataTables_empty") {
        for (let r = 0, n = table.rows.length; r < n; r++) {

            // Lecture Date
            if (table.rows[r].cells[1].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Lecture Date.");
                return 0;
            } else
                table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";

            // Lecture Date
            if (table.rows[r].cells[2].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter Start Time.");
                return 0;
            } else
                table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

            // Lecture Date
            if (table.rows[r].cells[3].getElementsByTagName("input")[0].value == '') {
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
                showError('', '#ff6666', "Please Enter End Time.");
                return 0;
            } else
                table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
    }
    showError('', '', '');
    return 1;
}

function resetTableErrors() {
    const table = document.getElementById("tableBody");
    if (table.rows[0].cells[0].className != "dataTables_empty")
        for (let r = 0, n = table.rows.length; r < n; r++) {
            table.rows[r].cells[1].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        }
}

function addLectureDetailsRow(result, disFlag) {
    const mytable = document.getElementById("tableBody");
    mytable.innerHTML = '';

    const currentIndex = mytable.rows.length;
    const newRow = document.createElement("tr");
    mytable.appendChild(newRow);

    let lectureDate = '';
    let lectureStartTime = '';
    let lectureEndTime = '';

    if (result.length > 0) {
        lectureDate = formatLectureDate(result[0]['lectureDate']); // Convert to DD-MM-YYYY
        lectureStartTime = result[0]['startTime'];
        lectureEndTime = result[0]['endTime'];
    }

    // Index cell
    let newCell = document.createElement("td");
    newCell.style.fontSize = "20px";
    newCell.innerHTML = currentIndex + 1;
    newRow.appendChild(newCell);

    // Lecture date cell
    newCell = document.createElement("td");
    const divMain = cDP(currentIndex, lectureDate || '', disFlag);
    newCell.appendChild(divMain);
    newRow.appendChild(newCell);

    // Lecture start time cell
    newCell = document.createElement("td");
    const startTime = document.createElement("div");
    startTime.className = "form-group";
    const inputSt = document.createElement("input");
    inputSt.className = "form-control";
    inputSt.type = 'time';
    inputSt.disabled = disFlag;
    inputSt.id = "lectureStartTime" + currentIndex;
    startTime.append(inputSt);
    newCell.appendChild(startTime);
    newRow.appendChild(newCell);

    // Lecture end time cell
    newCell = document.createElement("td");
    const endTime = document.createElement("div");
    endTime.className = "form-group";
    const inputEt = document.createElement("input");
    inputEt.className = "form-control";
    inputEt.type = 'time';
    inputEt.disabled = disFlag;
    inputEt.id = "lectureEndTime" + currentIndex;
    endTime.append(inputEt);
    newCell.appendChild(endTime);
    newRow.appendChild(newCell);

    // Lecture duration cell
    newCell = document.createElement("td");
    const lDuration = document.createElement("div");
    lDuration.className = "form-group";
    const inputDt = document.createElement("input");
    inputDt.className = "form-control tAC";
    inputDt.id = "lectureDuration" + currentIndex;
    inputDt.setAttribute("placeholder", "Lecture Duration");
    inputDt.disabled = true;

    if (lectureStartTime && lectureEndTime) {
        const start = lectureStartTime.split(':');
        const end = lectureEndTime.split(':');
        const startMinutes = parseInt(start[0]) * 60 + parseInt(start[1]);
        const endMinutes = parseInt(end[0]) * 60 + parseInt(end[1]);
        const duration = endMinutes - startMinutes;

        inputDt.value = duration >= 0 ? duration : 0; // Set the calculated duration
    }

    lDuration.append(inputDt);
    newCell.appendChild(lDuration);
    newRow.appendChild(newCell);

    $('#lectureStartTime' + currentIndex).datetimepicker({
        format: 'H:m a',
        datepicker: false,
    });
    $('#lectureEndTime' + currentIndex).datetimepicker({
        format: 'H:m a',
        datepicker: false,
    });
    
    $("#lectureStartTime" + currentIndex).on('change keyup paste', function () {
        calculateDuration();
    });

    $("#lectureEndTime" + currentIndex).on('change keyup paste', function () {
        calculateDuration();
    });

    if (result.length > 0) {
        document.getElementById("lectureStartTime" + currentIndex).value = lectureStartTime;
        document.getElementById("lectureEndTime" + currentIndex).value = lectureEndTime;
        if (lectureStartTime !== '' && lectureEndTime !== '') calculateDuration();
    }
    resetTableErrors();
}

function formatLectureDate(dateString) {
    
    console.log("Input to formatLectureDate:", dateString);

    // Check if the input is in DD/MM/YYYY format
    const ddmmyyyyPattern = /^\d{2}\/\d{2}\/\d{4}$/;
    if (ddmmyyyyPattern.test(dateString)) {
        // If it's in DD/MM/YYYY format, convert to DD-MM-YYYY
        return dateString.replace(/\//g, '-'); // Replace slashes with dashes
    }

    // Check if the input is in DD-MM-YYYY format
    const ddmmyyyyPatternDash = /^\d{2}-\d{2}-\d{4}$/;
    if (ddmmyyyyPatternDash.test(dateString)) {
        return dateString; // Return as is
    }

    // Otherwise, assume the input is in YYYY-MM-DD format
    const dateParts = dateString.split(' ')[0].split('-'); // Split date and ignore time
    if (dateParts.length !== 3) {
        console.error("Unexpected date format:", dateString);
        return ""; // Return an empty string or handle error as needed
    }
    const year = dateParts[0];  // Year
    const month = dateParts[1]; // Month
    const day = dateParts[2];   // Day
    return `${day}-${month}-${year}`; // Return in DD-MM-YYYY format
}

function enableLectureDateOnly() {
  var table = document.getElementById("tableBody");
  for (var i = 0; i < table.rows.length; i++) {
    // Enable only the Lecture Date field
    var lectureDateField = document.getElementById("lectureDate" + i);
    if (lectureDateField) {
      lectureDateField.disabled = false; // Enable the Lecture Date
    }

    // Disable other fields (Start Time, End Time, Duration)
    var startTimeField = document.getElementById("lectureStartTime" + i);
    var endTimeField = document.getElementById("lectureEndTime" + i);
    var durationField = document.getElementById("lectureDuration" + i);

    if (startTimeField) startTimeField.disabled = true;
    if (endTimeField) endTimeField.disabled = true;
    if (durationField) durationField.disabled = true;

    $("#lectureDate" + i).datetimepicker({
      format: "DD/MM/YYYY",
      dateFormat: "DD/MM/YYYY",
      timepicker: false, 
    });
  }
}

function update() {
  var saveFlag = "SAVEFLAG";
  // Loop through each row in the table to fetch the lecture date
  var table = document.getElementById("tableBody");
  console.log(lectureSplitId, "lectureSplitId");
  for (var i = 0; i < table.rows.length; i++) {
    // Get the lectureDate input element using the correct ID
    var lectureDateInput = document
      .getElementById("lectureDate" + i)
      .getElementsByTagName("input")[0];

    // Check if the input element exists
    if (lectureDateInput) {
      // Get the value of the lecture date (you can change the format here if needed)
      var lectureDate = lectureDateInput.value;
      console.log("Lecture Date: " + lectureDate); // Log the lecture date value
    }
    {
      if (confirm("Are you sure you want to Update Lecture??? ")) {
        document.getElementById("successMessage").innerHTML =
          "Updating Lecture. Please wait...";
        document.getElementById("update").disabled = true;
        $.post(
          "updateAssignmentExecution.php",
          {
            saveFlag: saveFlag,
            lectureSplitId: lectureSplitId,
            lectureDate: lectureDate,
            assignmentId: assignmentId,
            lecId: lecId,


          },
          function (data) {
            console.log(data);
            document.getElementById("successMessage").innerHTML =
              "Lecture Updated Successfully.";
          }
        );
      }
    }
  }
}

