<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';

if (isset($_GET['sessionPlanId'])) {
    // Retrieve and decode the URL-encoded parameters
    $id = $_GET['id'];
    $sessionPlanId = urldecode($_GET['sessionPlanId']);
    $subjectNameP = urldecode($_GET['subjectName']);
    $tableunitno = urldecode($_GET['tableunitno']);
    $semesterP = urldecode($_GET['semester']);
    $academicYear = urldecode($_GET['academicYear']);
    $batchName = urldecode($_GET['batchName']);
}


$assignmentId = '';
$sql    = "SELECT * FROM seriesnumber where seriesName ='assignmentId';";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $assignmentId = $row['seriesValue'];
    }
}

$semester = [];
$subjectNames = [];
$sql3 = "SELECT * FROM subjects;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($subjectNames, $row3);
    }
}

$sessionCodeList = [];
$tempSemesterList = [];
$sql2 = "SELECT sessionPlanId,semester,subjectName FROM sessionplan order by sessionPlanId;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        if (in_array($row2['semester'], $tempSemesterList)) {
        } else {
            array_push($semester, array("semester" => $row2['semester']));
            array_push($tempSemesterList, $row2['semester']);
        }
        array_push($sessionCodeList, $row2);
    }
}

$academicYearList = [];
$sql4 = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) {
    while ($row4 = $result4->fetch_assoc()) {
        array_push($academicYearList, $row4);
    }
}

$batchList = [];
$sql5 = "SELECT * FROM batchmaster";
$result5 = $conn->query($sql5);
if ($result5->num_rows > 0) {
    while ($row5 = $result5->fetch_assoc()) {
        array_push($batchList, $row5);
    }
}

$tempUnitNoList = [];
$sql = "SELECT DISTINCT sessionPlanId, tableunitno FROM sessionplan;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($tempUnitNoList, $row);
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header">
                            <h3 class="card-title fSB">1. Assignment Create
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Assignment Id</label>
                                        <input type="text" class="form-control tAC" id="assignmentId" value="<?php echo $assignmentId; ?>" placeholder="Enter Id" disabled>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Semester <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="semester" style="width: 100%;" onchange="filterOtherDropDown('semester');">
                                            <option disabled selected>SELECT SEMESTER</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Subject <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="subjectNames" onchange="filterOtherDropDown('subject');" style=" width: 100%;">
                                            <option disabled selected>SELECT SUBJECT</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Session Plan <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="sessionPlan" style=" width: 100%;" onchange="filterOtherDropDown('sessionPlan');">
                                            <option disabled selected>SELECT SESSION PLAN CODE</option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>UNIT NO <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="unitNo" style=" width: 100%;">
                                            <option disabled selected>SELECT UNIT NO</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>From To Date <span class="star">*</span></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="assignmentDate" placeholder="Start And End Date*" />
                                            <div class="input-group-append" data-target="#assignmentDate">
                                                <div class="input-group-text"> <i class="fa fa-calendar" data-toggle="daterangepicker"> </i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Academic Year <span class="star">*</span></label>
                                        <select class="form-control custom-select" id="academicYear" style="width: 100%;" onchange="filterOtherDropDown('aYear')">
                                            <option disabled selected>SELECT ACADEMIC YEAR</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Batch <span class="star">*</span></label>
                                        <select class="select2" multiple id="batchCode" style="width: 100%;" data-placeholder="Select Batch">
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card card-warning">
                        <div class="card-header">
                            <h3 class="card-title fSB">2.AssignmentForm Details
                            </h3>
                        </div>
                        <?php require 'assignmentTableDetails.php' ?>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card card-info">
                        <div class="card-header">
                            <h3 class="card-title tCW">3. Faculty Remuneration
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <table class="table table-striped p0 tAC" id="facultyPaymentTable">
                                    <thead>
                                        <tr>
                                            <th style="width:30%;">Faculty Name</th>
                                            <th style="width:10%;">Total Minutes</th>
                                            <th style="width:20%;">Type of Payment <span class="star">*</span></th>
                                            <th style="width:20%;">Per hrs</th>
                                            <th style="width:20%;">Total Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody id='facultyPaymentTableBody'>
                                    </tbody>
                                    <tfoot>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer tAC">
                            <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                            <span id="savedData"></span>
                            <input type="button" class="btn btn-primary" value="SAVE" onclick="saveAssignmentUnit(<?php echo $id; ?>)" id="saveButton" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="../../../plugins/datePicker/js/bootstrap-datepicker.js"> </script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="createAssignment.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var semester = <?php echo json_encode($semester); ?>;
    var subjectNames = <?php echo json_encode($subjectNames); ?>;
    var sessionCodeList = <?php echo json_encode($sessionCodeList); ?>;
    var academicYearList = <?php echo json_encode($academicYearList); ?>;
    var batchList = <?php echo json_encode($batchList); ?>;
    var tempUnitNoList = <?php echo json_encode($tempUnitNoList); ?>;
    var sessionPlanId = <?php echo json_encode($sessionPlanId); ?>;
    var subjectNameP = <?php echo json_encode($subjectNameP); ?>;
    var tableunitno = <?php echo json_encode($tableunitno); ?>;
    var semesterP = <?php echo json_encode($semesterP); ?>;
    var academicYear = <?php echo json_encode($academicYear); ?>;
    var batchName = <?php echo json_encode($batchName); ?>;

    console.log(subjectNameP,'subjectNameP');
    console.log(batchName,'batchName');
    $(function() {
        $(document).ready(function() {
            $('#assignmentDate').daterangepicker({
                autoApply: true,
                "alwaysShowCalendars": true,
                locale: {
                    format: 'DD/MM/YYYY',
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment()
                        .subtract(1, 'month').endOf('month')
                    ]
                },
            });
            $('#assignmentDate').val("");

            // $("#unitNo").change(function() {
            //     if (checkOnline() == false) return;
                // var tempSemester = getSelectValues('', document.getElementById("semester")).trim();
                // var tempSubjectName = getSelectValues('', document.getElementById("subjectNames")).trim();
                // var tempSessionPlan = getSelectValues('', document.getElementById("sessionPlan")).trim();
                // var tempUnitNo = getSelectValues('', document.getElementById("unitNo")).trim();


            //     console.log(tempSubjectName, 'tempSubjectName');
            //     if (tempSemester == "SELECT SEMESTER") {
            //         showError('semester', '#ff6666', "Select Semester");
            //         return 0;
            //     } else showError('semester', '', "");

            //     if (tempSubjectName == "SELECT SUBJECT") {
            //         showError('subjectNames', '#ff6666', "Select Subject");
            //         return 0;
            //     } else showError('subjectNames', '', "");
            //     if (tempSessionPlan == "SELECT SESSION PLAN CODE") {
            //         showError('sessionPlan', '#ff6666', "Select SessionPlan");
            //         return 0;
            //     } else showError('sessionPlan', '', "");
            //     if (tempUnitNo == "SELECT UNIT NO") {
            //         showError('unitNo', '#ff6666', "Select Unit No");
            //         return 0;
            //     } else showError('unitNo', '', "");
            //     $.post('assignmentTableDetails.php', {
            //         'sessionPlanCode': tempSessionPlan,
            //         'unitNo': tempUnitNo,
            //     }, function(data) {
            //         $('#sTable').html(data);
            //     });

            //     deleteRow([]);
            // });
            $('.select2').select2();

            // loadDataDropdown("semester", semester);
            // loadDataDropdown("academicYear", academicYearList);
            // loadDataDropdown("batchCode", []);
        });
    });

    $(document).ready(function() {
        // loadDataDropdown("projectNames", projactNameList, '');
        // loadDataDropdown("batchCodeName", batchCodeManterList, '');
console.log(subjectNameP,'subjectNameP');
        
            loadDataDropdown("semester", semester);
            loadDataDropdown("academicYear", academicYearList);
            loadDataDropdown("batchCode", []);

        selectDropdownValue("semester", semesterP);
        selectDropdownValue("subjectNames", subjectNameP);
        selectDropdownValue("sessionPlan", sessionPlanId);
        selectDropdownValue("academicYear", academicYear);
        selectDropdownValue("batchCode", batchName);
        selectDropdownValue("unitNo", tableunitno);

        function loadSessionPlanTable() {
            if (checkOnline() == false) return;
            var tempSemester = getSelectValues('', document.getElementById("semester")).trim();
                var tempSubjectName = getSelectValues('', document.getElementById("subjectNames")).trim();
                var tempSessionPlan = getSelectValues('', document.getElementById("sessionPlan")).trim();
                var tempUnitNo = getSelectValues('', document.getElementById("unitNo")).trim();
                if (tempSemester == "SELECT SEMESTER") {
                    showError('semester', '#ff6666', "Select Semester");
                    return 0;
                } else showError('semester', '', "");

                console.log(tempSemester);
                if (tempSubjectName == "SELECT SUBJECT") {
                    showError('subjectNames', '#ff6666', "Select Subject");
                    return 0;
                } else showError('subjectNames', '', "");
                if (tempSessionPlan == "SELECT SESSION PLAN CODE") {
                    showError('sessionPlan', '#ff6666', "Select SessionPlan");
                    return 0;
                } else showError('sessionPlan', '', "");
                if (tempUnitNo == "SELECT UNIT NO") {
                    showError('unitNo', '#ff6666', "Select Unit No");
                    return 0;
                } else showError('unitNo', '', "");
                $.post('assignmentTableDetails.php', {
                    'sessionPlanCode': tempSessionPlan,
                    'unitNo': tempUnitNo,
                }, function(data) {
                    $('#sTable').html(data);
                });

            // Reset rows (if needed)
            deleteRow([]);
        }

        // Bind the change event for unitNo dropdown
        $("#unitNo").change(function() {
            loadSessionPlanTable();
        });

        // Immediately load the table on page load (if unitNo is already selected)
        var initialUnitNo = getSelectValues('', document.getElementById("unitNo")).trim();
        if (initialUnitNo && initialUnitNo !== 'select Subject') {
            loadSessionPlanTable();
        }
    });
</script>
<?php require '../../common/footer.php'; ?>