function addTicketCharacterLimit() {
    var msg = document.getElementsByClassName("msg")[0],
        charLeftLabel = "char-left",
        charLeft = document.getElementsByClassName(charLeftLabel)[0],
        maxChar = 240,
        maxCharWarn = 0;
    charLeft.innerHTML = maxChar + '/' + maxChar;

    msg.onkeydown = function () {
        setTimeout(function () {
            charLeft.innerHTML = (maxChar - msg.value.length) + '/' + maxChar;
            var warnLabel = msg.value.length > maxChar - maxCharWarn ? " warning" : "";
            charLeft.className = charLeftLabel + warnLabel;
            if (warnLabel.trim() == 'warning') {
                document.getElementById("ticketMessage").style.backgroundColor = "#ffc2b3";
                charLimitExceed = 'true';
            } else {
                document.getElementById("ticketMessage").style.backgroundColor = "";
                charLimitExceed = 'false';
            }
        }, 1);
    };
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = dropowntext;
}
function filterOtherDropdown1(flag) {
    tempticketRaisedTofaculty = [];
    newAssignmentIdArray = [];

    if (flag == "FACULTY") {
        for (let i = 0; i < ticketRaisedTofacultyArray.length; i++) {

            newAssignmentIdArray.push(obj = {
                "firstName": ticketRaisedTofacultyArray[i].firstName.trim(),
                "lastName": ticketRaisedTofacultyArray[i].lastName.trim(),
                "Id": ticketRaisedTofacultyArray[i].facultyId,
            }
            )
        }
        loadDataDropdown("ticketTo", newAssignmentIdArray);
    }
    else if (flag == "LIFECOACH") {
        for (let i = 0; i < ticketRaisedTolifeCoachArray.length; i++) {

            newAssignmentIdArray.push(obj = {
                "firstName": ticketRaisedTolifeCoachArray[i].firstName.trim(),
                "lastName": ticketRaisedTolifeCoachArray[i].lastName.trim(),
                "Id": ticketRaisedTolifeCoachArray[i].lifeCoachId,
            }
            )
        }
        loadDataDropdown("ticketTo", newAssignmentIdArray);
    }
    else if (flag == "USER") {
        for (let i = 0; i < ticketRaisedToUserArray.length; i++) {
            newAssignmentIdArray.push(obj = {
                "firstName": ticketRaisedToUserArray[i].firstname.trim(),
                "lastName": ticketRaisedToUserArray[i].lastname.trim(),
                "Id": ticketRaisedToUserArray[i].userid,
            }
            )
        }
        loadDataDropdown("ticketTo", newAssignmentIdArray);
    }
    else if (flag == "AUDITOR") {
        for (let i = 0; i < ticketRaisedToAuditorArray.length; i++) {
            newAssignmentIdArray.push(obj = {
                "firstName": ticketRaisedToAuditorArray[i].firstName.trim(),
                "lastName": ticketRaisedToAuditorArray[i].lastName.trim(),
                "Id": ticketRaisedToAuditorArray[i].auditorId,
            }
            )
        }
        loadDataDropdown("ticketTo", newAssignmentIdArray);
    }
    else if (flag == "SELECT USER TYPE") {
        loadDataDropdown("ticketTo", []);
    }

}
function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    if (selectName == "ticketTo") dummyOptions(theSelect, options, "TICKET RAISED TO");
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("ticketTo")) {
            options.value = results[i].Id;
            options.text = results[i].firstName + " " + results[i].lastName;
            theSelect.add(options);
        }
    }
    return;
}


function resetData() { }

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text + '';
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}
function saveTicket() {
    var ticketId = '',
        ticketDeadLineDate = '',
        ticketFrom = '',
        ticketToType = '',
        ticketTo = '',
        ticketMessage = '';

    var saveFlag = 'SAVETICKET';
    ticketId = document.getElementById('ticketId').value;
    ticketDeadLineDate = document.getElementById('ticketDeadLineDate').value;
    ticketFrom = document.getElementById('ticketFrom').value.toUpperCase();
    ticketToType = document.getElementById('ticketToType').value.toUpperCase();
    ticketTo = document.getElementById('ticketTo').value;
    var ticketTotext = document.getElementById('ticketTo').options[document.getElementById('ticketTo').selectedIndex].text;
    console.log(ticketTotext);
    ticketMessage = document.getElementById('ticketMessage').value.trim();

    if (ticketDeadLineDate == '') {
        showError('ticketDeadLineDate', '#ff6666', "Dead Line Date Cannot Be Blank");
        return 0;
    } else {
        showError('ticketDeadLineDate', '', "");
    }

    if (ticketFrom == '') {
        showError('ticketFrom', '#ff6666', 'Ticket Raise From Cannot Be Blank');
        return 0;
    } else {
        showError('ticketFrom', '', "");
    }
    if (ticketToType == 'SELECT USER TYPE') {
        showError('ticketToType', '#ff6666', 'Please Select User type of Whom You want to raise Ticket');
        return 0;
    } else {
        showError('ticketToType', '', "");
    }
    if (ticketTo == '') {
        showError('ticketTo', '#ff6666', 'Please Select Whom You want to raise Ticket');
        return 0;
    } else {
        showError('ticketTo', '', "");
    }
    if (ticketMessage == '') {
        showError('ticketMessage', '#ff6666', 'Message cannot be blank');
        return 0;
    } else {
        showError('ticketMessage', '', "");
    }
    if (confirm("Are you sure you want to raise ticket?")) {
        document.getElementById("saveButton").disabled = true;
        document.getElementById('successMessage').innerHTML = 'Saving ticket please wait';
        $.post('saveTicket.php', {
            'saveFlag': saveFlag,
            'ticketId': ticketId,
            'ticketDeadLineDate': ticketDeadLineDate,
            'ticketFrom': ticketFrom,
            'ticketTo': ticketTo,
            'ticketToType': ticketToType,
            'ticketMessage': ticketMessage,
            'ticketTotext': ticketTotext,
        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = 'TIcket added successfully. Please wait. The page will get auto-refresh...';
            document.getElementById("saveButton").disabled = true;
        });
    }
    else document.getElementById("saveButton").disabled = false;
}

// ResolveMessage VIEW AND EDIT

function addValuesToResolveModal(ticketId) {
    document.getElementById('ticketResolveId').value = ticketId;
}

function addValuesToViewResolveModal(ticketId, resolvedMessage) {
    document.getElementById('ticketResolveIdView').value = ticketId;
    document.getElementById('ticketResolveMessageView').value = resolvedMessage;
}

function resetDataResolve() {
    document.getElementById('ticketResolveId').value = '';
    document.getElementById('ticketResolveMessage').value = '';
}

function showErrorResolve(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessageModalResolve').innerHTML = message;
}

function saveResolveMsg() {
    var saveFlag = 'SAVERESOLVEMSG';
    var resolveTicketId = document.getElementById('ticketResolveId').value;
    var ticketResolveMessage = document.getElementById('ticketResolveMessage').value.trim();

    if (ticketResolveMessage == '') {
        showErrorResolve('ticketResolveMessage', '#ff6666', 'Message cannot be blank');
        return 0;
    } else {
        showErrorResolve('ticketResolveMessage', '', "");
    }
    if (confirm("Are you sure you want to resolve ticket?")) {
        document.getElementById("saveResolveMessage").disabled = true;
        document.getElementById('successMessageModalResolve').innerHTML = 'Saving ticket please wait';
        $.post('saveTicket.php', {
            'saveFlag': saveFlag,
            'ticketId': resolveTicketId,
            'ticketResolveMessage': ticketResolveMessage,

        }, function (data) {
            console.log(data);
            document.getElementById('successMessageModalResolve').innerHTML = 'TIcket Resolved....';
            document.getElementById("saveResolveMessage").disabled = true;
            location.reload();
        });
    }
    else document.getElementById("saveResolveMessage").disabled = false;
}



// DELETE TICKET

function deleteTicket(ticketId) {
    console.log(ticketId);
    var saveFlag = 'DELETETICKET';
    if (confirm("Are you sure you want to Delete ticket?")) {
        $.post('saveTicket.php', {
            'saveFlag': saveFlag,
            'ticketId': ticketId,

        }, function (data) {
            location.reload();
        });
    }

}



function filterOtherDropDown(flag) {

    var table = $('#myticketListTable').DataTable();
    table.draw();
}
