<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">ALL STUDENTS</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="studentTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ACADEMIC YEAR
                                        </th>
                                        <th>
                                            ADMISSION DATE
                                        </th>
                                        <th>
                                            STUDENT ID
                                        </th>
                                        <th>
                                            NAME
                                        </th>
                                        <th>
                                            PROFILE COMPLETION STATUS
                                        </th>
                                        <th>
                                            STATUS
                                        </th>
                                        <th>
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT ls.*,sf.academicYear from loginstudents ls INNER JOIN studentfee sf ON ls.studentId = sf.studentId WHERE ls.admissionStatus='CONFIRMED' order by ls.studentId desc; ";
                                    $result = $conn->query($sql);
                                    $sr = 0;
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $studentId = $row['studentId'];
                                            $sr = $sr + 1;

                                            $profilePercentage = 0;
                                            $personalDetails = 0;
                                            $communicationAddress = 0;
                                            $guardianInformation = 0;
                                            $studentDocument = 0;
                                            $educationDetails = 0;

                                            if (strlen($row['firstname']) > 0) $personalDetails += 2;
                                            if (strlen($row['lastname']) > 0) $personalDetails += 2;
                                            if (strlen($row['dateOfBirth']) > 0) $personalDetails += 4;
                                            if (strlen($row['phoneNumber']) > 0) $personalDetails += 2;
                                            if (strlen($row['whatsappNo']) > 0) $personalDetails += 2;
                                            if (strlen($row['username']) > 0) $personalDetails += 3;
                                            if (strlen($row['pass']) > 0) $personalDetails += 3;
                                            if (strlen($row['imageName']) > 0) $personalDetails += 2;

                                            if (strlen($row['addressLine1']) > 0) $communicationAddress += 5;
                                            if (strlen($row['city']) > 0) $communicationAddress += 5;
                                            if (strlen($row['state']) > 0) $communicationAddress += 5;
                                            if (strlen($row['pinCode']) > 0) $communicationAddress += 5;

                                            $parentName = $row['parentFirstname'] . '' . $row['parentLastname'];
                                            if (strlen($parentName) > 0) $guardianInformation += 5;
                                            if (strlen($row['guardianType']) > 0) $guardianInformation += 5;
                                            if (strlen($row['contactNumber']) > 0) $guardianInformation += 5;
                                            if (strlen($row['emailId']) > 0) $guardianInformation += 5;

                                            if (strlen($row['aadharCard']) > 0 || strlen($row['leavingCertificate']) > 0) $studentDocument += 10;
                                            if (strlen($row['categoryOfCast']) > 0) $studentDocument += 5;
                                            if (strlen($row['religion']) > 0) $studentDocument += 5;

                                            $sql2 = "SELECT * FROM studenteducation WHERE studentid='$studentId';";
                                            $result2 = $conn->query($sql2);
                                            if ($result2->num_rows > 0) {
                                                while ($row2 = $result2->fetch_assoc()) {
                                                    if (strlen($row2['degree']) >= 2) {
                                                        $educationDetails += 10;
                                                    }
                                                }
                                            }
                                            $profilePercentage =  $personalDetails + $communicationAddress + $guardianInformation + $studentDocument + $educationDetails;

                                            if ($profilePercentage < 35) $badgeCss = "badge badge-danger";
                                            elseif ($profilePercentage > 35 && $profilePercentage < 75) $badgeCss = "badge badge-warning";
                                            else $badgeCss = "badge badge-primary";

                                            if ($row['studentStatus'] == 'ACTIVE') $statusCss = 'badge badge-success fs16';
                                            if ($row['studentStatus'] == 'BLOCKED') $statusCss = 'badge badge-danger fS16';

                                            echo "
                                                <tr  class='tAC'>
                                                <td >" . $row['academicYear'] . "</a></td>
                                                <td>" . date('d-m-Y', strtotime($row['admissionDate'])) . "</td> 
                                                <td ><a class='tCW' href='#' onclick='showDetails(this.id)' id = " . $studentId . ">" . $studentId . "</a></td>
                                                <td ><a class='tCW' href='#' onclick='showDetails(this.id)' id = " . $studentId . "> " . $row['firstname'] . ' ' . $row['lastname']  . "</a></td> 
                                                <td ><span class='" . $badgeCss . "' style='font-size:16px;'>" . $profilePercentage  . '%' .  "</td>
                                                <td ><span class = '" . $statusCss . "'style='font-size:16px;'>" . $row['studentStatus'] . "</td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm' href='#' onclick='showDetails(this.id)' id = " . $studentId . " title='click hear to view Lead Details'>
                                                    <i class='fas fa-eye'>
                                                    </i>
                                                </a>
                                                </td>
                                            </tr>
                                          ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
    function showDetails(id) {
        var studentId = id;
        encodedValue_studentId = btoa(studentId);
        encodedKey_studentId = btoa('studentId');
        window.location.href = "viewStudentDetails.php?" + encodedKey_studentId + "=" + encodedValue_studentId;
    }
    $(function() {
        $("#studentTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>