<?php
session_start();
if (strlen($_SESSION['loginsuccessCM'])) {
    if ($_SESSION['loginsuccessCM'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">STUDENT LIST</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="studentListTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>STUDENT ID</th>
                                        <th width='15%'>NAME</th>
                                        <th width='30%'>PAYMENT DESCRIPTION</th>
                                        <th width='15%'>AMOUNT</th>
                                        <th width='10%'>PAYMENT STATUS</th>
                                        <th width='20%'>APPROVE AMOUNT</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from payablepaymenthistory WHERE paymentDescription = 'ADMISSION CANCELLATION REFUND';";
                                    $result = $conn->query($sql);
                                    $index = 0;
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $statusCss = '';
                                            $approveButtonCss = '';

                                            $studentId = $row['studentId'];
                                            $studentFirstName = $row['studentFirstName'];
                                            $studentLastName = $row['studentLastName'];
                                            $studentName = $studentFirstName . ' ' . $studentLastName;
                                            $refundAmount = $row['amount'];
                                            $payablePaymentRowId = '"'.$row['rowId'].'"';
                                            $amountId = '"' . 'approvedAmount' . $index . '"';
                                            $buttonId = '"' . 'approveButton' . $index . '"';
                                            $errorMessageId = '"' . 'errorMessage' . $index . '"';
                                            $successMessageId = '"' . 'successMessageId' . $index . '"';

                                            if ($row['payablePaymentStatus'] == 'PENDING') $statusCss = 'badge badge-danger';
                                            if ($row['payablePaymentStatus'] == 'COMPLETED') $statusCss = 'badge badge-success';
                                            if ($row['centerMasterApproval'] == 'PENDING') $approveButtonCss = "";
                                            if ($row['centerMasterApproval'] == 'APPROVED') $approveButtonCss = "disabled";

                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $studentId . "> " . $studentId  . "</td>                                                       
                                                    <td>" . $studentName . "</td>                                                       
                                                    <td>" . $row['paymentDescription'] . "</td>                                                       
                                                    <td><input type='number' value='$refundAmount' class='form-control' id=$amountId placeholder='Refund'></td>                                                                                                                                                                                                                          
                                                    <td><span class = '$statusCss'>" . $row['payablePaymentStatus'] . "</span></td>                                                       
                                                    <td><input type='button' class='btn btn-success' value='APPROVE' onclick='approveAdmissionCancellationRefund($buttonId,$amountId,$errorMessageId,$successMessageId,$payablePaymentRowId)' id=$buttonId $approveButtonCss/>
                                                    <p id=$errorMessageId class='text-center'
                                                    style='color: red; font-size: 1.0em;   text-align: center;'>
                                                    </p>
                                                    <p id=$successMessageId class='text-center'
                                                    style='color: green; font-size: 1.0em;   text-align: center;'>
                                                    </td>                                                                                                             
                                                </tr>
                                            ";
                                            $index += 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="cancelAdmission.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    $(function() {
        $("#studentListTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>