<?php
session_start();
echo "<!DOCTYPE html>";
if (isset($_SESSION['parentLoginSuccess'])) {
    if ($_SESSION['parentLoginSuccess'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
$studentId = $_SESSION['studentId'];
$userType = $_SESSION['userType'];

require '../../common/header.php';
require '../../common/navbar.php';
?>
<style>
    .warning {
        color: #c00;
    }

    .char-left {
        text-align: right;
    }
</style>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="card-title fSB">ADD REMINDER</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Date <span class="star">*</span></label>
                                        <input type="date" class="form-control" id="reminderDate">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Time <span class="star">*</span></label>
                                        <input type="time" class="form-control" id="reminderTime">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label>Agenda <span class="star">*</span></label>
                                    <div class="form-group">
                                        <textarea class="form-control msg" rows="3" placeholder="Agenda" id="reminderAgenda"></textarea>
                                        <p class="char-left"></p>
                                    </div>
                                </div>
                                <div class="col-md-1 mt-5">
                                    <input type="button" class="btn btn-primary" value="Save" onclick="saveReminder()" id="saveButton" />
                                </div>
                                <div class="col-md-3 mt-5">
                                    <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                    </p>
                                    <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card card-info mT10">
                        <div class="card-header newCardHeader">
                            <h3 class="tAC fSB">ALL REMINDERS</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="remindersTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>ID#</th>
                                        <th width='15%'>DATE</th>
                                        <th width='10%'>TIME</th>
                                        <th width='40%'>AGENDA</th>
                                        <th width='25%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from reminders where reminderstatus= 'PENDING' AND userId = '$studentId'AND userType='$userType' ORDER BY reminderDate desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $notificationId = '';
                                            $convertedTime = date('h:i a ', strtotime($row['reminderTime']));
                                            $notificationId = '"' . $row['notificationId'] . '"';
                                            $reminderDate = explode("-", $row['reminderDate']);
                                            $convertedDate = $reminderDate[2] . '-' . $reminderDate[1] . '-' . $reminderDate[0];
                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $row['reminderId'] . "> " . $row['reminderId']  . "</td>                                                                                                          
                                                    <td> " . $convertedDate  . "</td>                                                                                                          
                                                    <td> " . $convertedTime  . "</td>                                                                                                        
                                                    <td> " . $row['reminderAgenda']  . "</td>                                                                                                        
                                                    <td><a class='btn btn-success btn-sm' href='#!' title='Click here to confirm reminder.' id='" . $row['reminderId'] . "' onclick='confirmReminder(this.id,$notificationId)'>
                                                            <i class='fas fa-check-circle'></i>
                                                        </a>
                                                        <a class='btn btn-secondary btn-sm' href='#' id='" . $row['reminderId'] . "' onclick='editRemainder(this.id)' title='Click here to edit reminder.'>
                                                            <i class='fas fa-user-edit'></i>
                                                        </a>
                                                        <a class='btn btn-danger btn-sm' href='#!' title='Click here to delete reminder.' id='" . $row['reminderId'] . "' onclick='deleteReminder(this.id)'>
                                                            <i class='fas fa-trash'></i>
                                                        </a>
                                                    </td>                                                                                                      
                                                </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script>
    var charLimitExceed = 'false';
    var studentId = '';
    (function() {
        studentId = <?php echo '"' . $studentId . '"' ?>;
        var table = $("#remindersTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 30,
            "aaSorting": [],
        });
        
       
        
        var msg = document.getElementsByClassName("msg")[0],
        charLeftLabel = "char-left",
        charLeft = document.getElementsByClassName(charLeftLabel)[0],
        maxChar = 160,
        maxCharWarn = 0;
        
        // show characters left at start
        charLeft.innerHTML = maxChar + '/' + maxChar;
        
        // update while typing
        msg.onkeydown = function() {
            setTimeout(function() {
                charLeft.innerHTML = (maxChar - msg.value.length) + '/' + maxChar;
                // whether or not to display warning class based on characters left
                var warnLabel = msg.value.length > maxChar - maxCharWarn ? " warning" : "";
                charLeft.className = charLeftLabel + warnLabel;
                if (warnLabel.trim() == 'warning') {
                    document.getElementById("reminderAgenda").style.backgroundColor = "#ffc2b3";
                    charLimitExceed = 'true';
                } else {
                    document.getElementById("reminderAgenda").style.backgroundColor = "";
                    charLimitExceed = 'false';
                }
            }, 1);
        };


         // to disable previous date
         var dtToday = new Date();
        var month = dtToday.getMonth() + 1;
        var day = dtToday.getDate();
        var year = dtToday.getFullYear();
        if (month < 10)
        month = '0' + month.toString();
        if (day < 10)
        day = '0' + day.toString();
        var maxDate = year + '-' + month + '-' + day;
        $('#reminderDate').attr('min', maxDate);
        // end
    })();
</script>
    <script src="addReminders.js?v=<?php echo $fileVersion; ?>"></script>
<?php require '../../common/footer.php'; ?>
