function selectDropdownValue(selectName, val) {
    val = val.toUpperCase();
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].value;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function loadData() {
    $.post('queryDetails.php', {
        'studentId': studentId,
    }, function (data) {
        $('#queryDetails').html(data);
    });
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function showModalError(id, color, message) {
    if (id != '')
        // document.getElementById(id).style.backgroundColor = color;
    document.getElementById('modalErrorMessage').innerHTML = message;
}

function showUnresolvedError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('unresolvedErrorMessage').innerHTML = message;
}

function showRatingError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('ratingErrorMessage').innerHTML = message;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\-/g, "\-")
        .replace(/\&/g, "\&")
        .replace(/\|/g, "\|")
        .replace(/\!/g, "\!")
        .replace(/\(/g, "\(")
        .replace(/\)/g, "\)")
        .replace(/\{/g, "\{")
        .replace(/\}/g, "\}")
        .replace(/\[/g, "\[")
        .replace(/\]/g, "\]")
        .replace(/\^/g, "\^")
        .replace(/\~/g, "\~")
        .replace(/\*/g, "\*")
        .replace(/\?/g, "\?")
        .replace(/\:/g, "\:")
        .replace(/\\/g, "\\")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");
    return output;
}

var queryId = '',
    queryRaisedTo = '',
    studentQuery = '',
    userDetails = [];

function queryValidation() {
    queryId = '';
    queryRaisedTo = '';
    studentQuery = '';

    queryId = document.getElementById('queryId').value.trim();
    queryRaisedTo = document.getElementById('queryRaisedTo').value.trim();
    studentQuery = document.getElementById('query').value.trim();

    if (queryRaisedTo == 'QUERY RAISED TO') {
        document.getElementById("queryRaisedTo").style.backgroundColor = "#ffc2b3";
        showError('queryRaisedTo', "#ffc2b3", "Select whom you want to raise query");
        return 0;
    } else {
        document.getElementById("queryRaisedTo").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (studentQuery == '') {
        document.getElementById("query").style.backgroundColor = "#ffc2b3";
        showError('query', "#ffc2b3", "Enter your query");
        return 0;
    } else {
        document.getElementById("query").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (studentQuery.length <= 40) {
        document.getElementById("query").style.backgroundColor = "#ffc2b3";
        showError('query', "#ffc2b3", "Query should contain at least 40 characters.");
        return 0;
    } else {
        document.getElementById("query").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (charLimitExceed == 'true') {
        document.getElementById("query").style.backgroundColor = "#ffc2b3";
        showError('query', "#ffc2b3", "Character limit exceeded");
        return 0;
    } else {
        document.getElementById("query").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    return 1;
}

function escapeEnterWithSpace(text) {
    text.replace("\n", " ");
    return text;
}

queryImage = '';
flaglpImage = "false";
function saveQuery(studentId) {
    var input = document.getElementById("queryImage");
    if (input.files.length > 0) {
        flaglpImage = "true";
        queryImage = input.files[0];
    }
    if (input.files.length > 0) {
        flaglpImage = "true";
        queryDocument = input.files[0];
        var imgSize = (parseFloat(input.files[0].size / 1024) / 1024).toFixed(2);
        if (imgSize > 1) {
            showError('imgButton', '', "Image size should not exceed 1 MB.");
            return 0;
        } else showError('imgButton', '', '');
    }
    document.getElementById('successMessage').innerHTML = '';
    saveFlag = 'saveQuery';
    document.getElementById('saveButton').disabled = true;
    if (queryValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    userDetails = [];
    for (i = 0; i < queryRaisedToArray.length; i++) {
        if (queryRaisedTo == queryRaisedToArray[i]['userid']) {
            userDetails.push(obj = {
                "userEmailId": queryRaisedToArray[i].username,
                "userFirstName": queryRaisedToArray[i].firstname,
                "userLastName": queryRaisedToArray[i].lastname,
            });
        }
    }
    // studentQuery = escapeEnterWithSpace(studentQuery);
    // document.getElementById('successMessage').innerHTML = 'Saving.Please wait...';

    studentQuery = escapeSpecialCharacters(studentQuery);
    formData = new FormData();
    formData.append("saveFlag", saveFlag);
    formData.append("queryId", queryId);
    formData.append("studentId", studentId);
    formData.append("parentFirstName", parentFirstName);
    formData.append("parentLastName", parentLastName);
    formData.append("queryRaisedTo", queryRaisedTo);
    formData.append("studentQuery", studentQuery);
    formData.append("userDetails", JSON.stringify(userDetails));
    formData.append("studentDetails", JSON.stringify(studentDetails));
    formData.append("flaglpImage", flaglpImage);
    formData.append("queryImage", queryImage);
    document.getElementById('successMessage').innerHTML = 'Saving Query.Please wait...';
    $.ajax({
        url: "saveQuery.php",
        type: "POST",
        enctype: 'multipart/form-data',
        data: formData,
        processData: false,
        contentType: false,
        success: function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = 'Saved successfully';
            document.getElementById('query').value = '';
            document.getElementById('queryRaisedTo').value = 'QUERY RAISED TO';
            queryId = parseInt(queryId) + 1;
            document.getElementById('queryId').value = queryId;
            document.getElementById("saveButton").disabled = false;
            loadData();
            location.reload();
        }
    });
}


function resetModal() {
    document.getElementById('ModalQueryMessage').value = '';
    document.getElementById('modalQueryId').innerHTML = '';
    document.getElementById('modalQueryRaisedTo').innerHTML = '';
    document.getElementById('modalErrorMessage').innerHTML = '';
    document.getElementById('modelsuccessMessage').innerHTML = '';
    document.getElementById('attachmentPreviewModal').src = '';
    document.getElementById('attachmentPreviewModal').style.height = '';
    document.getElementById('attachmentPreviewModal').style.width = '';
    document.getElementById('editButton').disabled = false;
    document.getElementById('ModalQueryMessage').style.backgroundColor = '';
    // document.getElementById('queryImage').value= '';
    document.getElementById('characterLeftEdit').innerHTML = '';
    charLimitExceedEdit = 'false';
}

function addDataToModal(modalQuery, modalQueryId, modalQueryRaisedTo, modalQueryAttachment) {
    // console.log(modalQueryImage);
    resetModal();
    document.getElementById('ModalQueryMessage').value = modalQuery;
    document.getElementById('modalQueryId').innerHTML = modalQueryId;
    document.getElementById('modalQueryRaisedTo').innerHTML = modalQueryRaisedTo;
    // document.getElementById('modalQueryImage').value= modalQueryImage;

    if (modalQueryAttachment.length > 0) {
        var attachmentPreviewModal = document.getElementById('attachmentPreviewModal');
        attachmentPreviewModal.src = "../../../dist/img/studentQueryImages/" + modalQueryAttachment;
        attachmentPreviewModal.style.height = 200;
        attachmentPreviewModal.style.width = 180;
    }
}

var queryAttachment = '';
queryAttachmentInput = '';
queryAttachmentFlag = 'false';
function queryEditValidation() {
    studentQuery = '';
    queryId = '';
    queryAttachment = '';
    queryAttachmentInput = '';
    queryAttachmentFlag = 'false';
    studentQuery = document.getElementById('ModalQueryMessage').value.trim();
    queryId = document.getElementById('modalQueryId').innerHTML.trim();
    queryAttachmentInput = document.getElementById("queryImageModal");

    if (queryAttachmentInput.files.length > 0) {
        queryAttachmentFlag = "true";
        queryAttachment = queryAttachmentInput.files[0];
    }
    if (queryAttachmentInput.files.length > 0) {
        queryAttachmentFlag = "true";
        queryAttachmnetDocument = queryAttachmentInput.files[0];
        var imgSize = (parseFloat(queryAttachmentInput.files[0].size / 1024) / 1024).toFixed(2);
        if (imgSize > 1) {
            showModalError('modalImgButton', '', "Image size should not exceed 1 MB.");
            return 0;
        } else showModalError('modalImgButton', '', '');
    }

    if (studentQuery == '') {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
        showModalError('ModalQueryMessage', "#ffc2b3", "Enter your query");
        return 0;
    } else {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "";
        showModalError('modalErrorMessage', '', '');
    }
    if (studentQuery.length <= 40) {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
        showModalError('ModalQueryMessage', "#ffc2b3", "Query should contain at least 40 characters.");
        return 0;
    } else {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "";
        showModalError('modalErrorMessage', '', '');
    }
    if (charLimitExceedEdit == 'true') {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "#ffc2b3";
        showModalError('ModalQueryMessage', "#ffc2b3", "Character limit exceeded");
        return 0;
    } else {
        document.getElementById("ModalQueryMessage").style.backgroundColor = "";
        showModalError('modalErrorMessage', '', '');
    }
    return 1;
}

function editQuery() {
    saveFlag = 'editQuery';
    document.getElementById('editButton').disabled = true;
    if (queryEditValidation() == 0) {
        document.getElementById('editButton').disabled = false;
        return;
    }
    studentQuery = escapeSpecialCharacters(studentQuery);

    formData = new FormData();
    formData.append("saveFlag", saveFlag);
    formData.append("queryId", queryId);
    formData.append("studentQuery", studentQuery);
    formData.append("queryAttachment", queryAttachment);
    formData.append("queryAttachmentFlag", queryAttachmentFlag);
    if (confirm("Are you sure you want update query?")) {
        document.getElementById('modelsuccessMessage').innerHTML = 'Saving.Please wait...';
        $.ajax({
            url: "saveQuery.php",
            type: "POST",
            enctype: 'multipart/form-data',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                console.log(data);
                document.getElementById('modelsuccessMessage').innerHTML = 'Saved successfully';
                loadData();
                document.getElementById("closeModal").click();
            }
        });
    }
    document.getElementById('editButton').disabled = false;
}

function viewSolution(id) {
    encodedValue_id = btoa(id);
    encodedKey_queryId = btoa('qId');
    // window.location.href = "viewSolution.php?queryId=" + id;
    window.location.href = "viewSolution.php?" + encodedKey_queryId + "=" + encodedValue_id;
}
function viewRevision(id) {
    encodedValue_id = btoa(id);
    encodedKey_queryId = btoa('qId');
    window.location.href = "viewRevision.php?" + encodedKey_queryId + "=" + encodedValue_id;
}
function viewRejectreason(id) {
    encodedValue_id = btoa(id);
    encodedKey_queryId = btoa('qId');
    window.location.href = "viewRejectreason.php?" + encodedKey_queryId + "=" + encodedValue_id;
}

function selectQueryStatus(id) {
    if (id == 'queryResolvedRadio') {
        document.getElementById("queryResolvedDiv").hidden = false;
        document.getElementById("queryPartialDiv").hidden = true;

    }
    if (id == 'queryPartialRadio') {
        document.getElementById("queryResolvedDiv").hidden = true;
        document.getElementById("queryPartialDiv").hidden = false;
    }
   
}

function unresolvedQueryValidation() {
    queryRaisedTo = '';
    studentQuery = '';

    queryRaisedTo = document.getElementById('queryRaisedTo').value.trim();
    studentQuery = document.getElementById('updatedQuery').value.trim();

    if (queryRaisedTo == 'QUERY RAISED TO') {
        document.getElementById("queryRaisedTo").style.backgroundColor = "#ffc2b3";
        showUnresolvedError('queryRaisedTo', "#ffc2b3", "Select whom you want to raise query");
        return 0;
    } else {
        document.getElementById("queryRaisedTo").style.backgroundColor = "";
        showUnresolvedError('unresolvedErrorMessage', '', '');
    }

    if (studentQuery == '') {
        document.getElementById("updatedQuery").style.backgroundColor = "#ffc2b3";
        showUnresolvedError('updatedQuery', "#ffc2b3", "Enter your query");
        return 0;
    } else {
        document.getElementById("updatedQuery").style.backgroundColor = "";
        showUnresolvedError('unresolvedErrorMessage', '', '');
    }

    if (studentQuery.length <= 40) {
        document.getElementById("updatedQuery").style.backgroundColor = "#ffc2b3";
        showUnresolvedError('updatedQuery', "#ffc2b3", "Query should contain at least 40 characters.");
        return 0;
    } else {
        document.getElementById("updatedQuery").style.backgroundColor = "";
        showUnresolvedError('unresolvedErrorMessage', '', '');
    }
    return 1;
}

// function saveUnresolvedQuery() {
//     document.getElementById('saveUnresolvedQueryButton').disabled = true;
//     var saveFlag = 'saveUnresolvedQuery';
//     if (unresolvedQueryValidation() == 0) {
//         document.getElementById('saveUnresolvedQueryButton').disabled = false;
//         return;
//     }
//     userDetails = [];
//     for (i = 0; i < queryRaisedToArray.length; i++) {
//         if (queryRaisedTo == queryRaisedToArray[i]['userid']) {
//             userDetails.push(obj = {
//                 "userEmailId": queryRaisedToArray[i].username,
//                 "userFirstName": queryRaisedToArray[i].firstname,
//                 "userLastName": queryRaisedToArray[i].lastname,
//             });
//         }
//     }
//     // console.log(saveFlag,queryId,studentId,studentFirstName,studentLastName,queryRaisedTo,studentQuery,userDetails);
//     // studentQuery = escapeEnterWithSpace(studentQuery);
//     studentQuery = escapeSpecialCharacters(studentQuery);
//     if (confirm("Are you sure you want to mark query as unresolved?")) {
//         document.getElementById('unresolvedSuccessMessage').innerHTML = 'Saving.Please wait...';
//         $.post('saveQuery.php', {
//             'saveFlag': saveFlag,
//             'queryId': queryId,
//             'studentId': studentId,
//             'parentFirstName': parentFirstName,
//             'parentLastName': parentLastName,
//             'queryRaisedTo': queryRaisedTo,
//             'studentQuery': studentQuery,
//             'userDetails': userDetails,
//         }, function (data) {
//             document.getElementById('unresolvedSuccessMessage').innerHTML = 'Saved successfully';
//             document.getElementById("saveUnresolvedQueryButton").disabled = true;
//             document.getElementById('saveRatingButton').disabled = true;
//             location.reload();
//         });
//     }
//     document.getElementById("saveUnresolvedQueryButton").disabled = false;
//     document.getElementById('saveRatingButton').disabled = false;
// }

function saveRatings() {
    document.getElementById('saveRatingButton').disabled = true;
    var saveFlag = 'saveRatings';

    if (rateCount == '') {
        showRatingError('', "", "Please rate your experience.");
        document.getElementById('saveRatingButton').disabled = false;
        return 0;
    } else {
        showRatingError('', '', '');
    }
    document.getElementById('ratingSuccessMessage').innerHTML = 'Saving.Please wait...';
    document.getElementById('saveRatingButton').disabled = true;
    $.post('saveQuery.php', {
        'saveFlag': saveFlag,
        'queryId': queryId,
        'rateCount': rateCount,
    }, function (data) {
        // console.log(data);
        document.getElementById('ratingSuccessMessage').innerHTML = 'Saved successfully';
        // document.getElementById("saveUnresolvedQueryButton").disabled = true;
        document.getElementById('saveRatingButton').disabled = true;
        location.reload();
    });
}
var loadFile = function (event, previewId) {
    if (previewId == "queryImage" && event.target.files[0]) {
        flagEditPhoto = 1;
        var passPortPhotoPreview = document.getElementById('imagePreview');
        passPortPhotoPreview.src = URL.createObjectURL(event.target.files[0]);
        passPortPhotoPreview.style.height = 200;
        passPortPhotoPreview.style.width = 180;
        passPortPhotoPreview.onload = function () {
            URL.revokeObjectURL(passPortPhotoPreview.src) // free memory
        }
    } else if (previewId == "queryImageModal" && event.target.files[0]) {
        flagEditPhotoModal = 1;
        var attachmentPreviewModal = document.getElementById('attachmentPreviewModal');
        attachmentPreviewModal.src = URL.createObjectURL(event.target.files[0]);
        attachmentPreviewModal.style.height = 200;
        attachmentPreviewModal.style.width = 180;
        attachmentPreviewModal.onload = function () {
            URL.revokeObjectURL(attachmentPreviewModal.src) // free memory
        }
    }
}
function showReviseError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessagerevised').innerHTML = message;
}
revisedQuery = '';
function saveRevisedQuery(studentId) {
    var saveFlag = 'revisedQuery';
    var queryId = document.getElementById('queryId').innerHTML.trim();
    var revisedQuery = document.getElementById('revisedQuery').value.trim();
    if (revisedQuery == '') {
        document.getElementById('revisedQuery').style.backgroundColor = '#ff6666';
        showReviseError('', "", "revised Query cannot be blank");
        return 0;
    } else {
        showReviseError('', '', '');
    }
    if (revisedQuery.length <= 40) {
        document.getElementById('revisedQuery').style.backgroundColor = '#ff6666';
        showReviseError('', "", "Revised Query should contain at least 40 characters.");
        return 0;
    } else {
        showReviseError('', '', '');
    }

    document.getElementById('RevisedMessage').innerHTML = 'Updating Please wait...';
    document.getElementById('saveRevisionButton').disabled = true;
    $.post('saveRevisonQuery.php', {
        'saveFlag': saveFlag,
        'studentId':studentId, 
        'queryId': queryId,
        'revisedQuery': revisedQuery,
        'queryDetails' : queryDetails,
        'studentDetails' : studentDetails,
    }, function (data) {
        document.getElementById('RevisedMessage').innerHTML = 'Saved successfully';
        document.getElementById('saveRevisionButton').disabled = true;
        location.reload();
    });
}
function partialResolve() {
    console.log(queryId);
    var saveFlag = 'partiallyeResolve'
    if (confirm("Are you sure you want to mark query as partially Resolved?")) {
        document.getElementById('partialsuccessMessage').innerHTML = 'Updating Please wait...';
        $.post('saveQuery.php', {
            'saveFlag': saveFlag,
            'queryId': queryId,
        }, function (data) {
            document.getElementById('partialsuccessMessage').innerHTML = 'Saved successfully';
            document.getElementById("queryResolvedRadio").hidden = true;
            location.reload();
        });
    }
}