<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING WORKSHOP PAYMENT</h3>
                                </div>
                            </div>
                        </div>
                   
                <div class="card-body">
                    <table class="table table-striped projects tAC" id="allInvoiceTable">
                        <thead>
                            <tr>
                                <th>
                                    WORKSHOP ID
                                </th>
                                <th>
                                    INVOICE DATE
                                </th>
                                <th>
                                    WORKSHOP TITLE
                                </th>
                                <th>
                                    FACULTY NAME
                                </th>
                                <th>
                                    INVOICE STATUS
                                </th>
                                <th>
                                    INVOICE
                                </th>
                                <th>
                                    ACTIONS
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            require_once '../../common/connectToDB.php';
                            $sql = "SELECT distinct  la.accountsId,la.invoiceRaisedTimestamp,la.workshopId,wp.facultyId,wp.workshopTitle,wp.facultyName,la.flag,la.totalAmount,la.penaltyAmount,f.facultyId AS fId,f.invoiceType,la.invoice,la.invoiceStatus FROM l_accounts as la ,workshopmaster as wp,faculty as f where f.facultyId = wp.facultyId AND wp.workshopId = la.workshopId AND la.invoice != 'PENDING' AND la.invoiceStatus!=''  ORDER BY la.accountsId DESC";

                            $result = $conn->query($sql);
                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    $tempPendingAmount = '';
                                    $tempPenaltyAmount = '';
                                    $invoice = '';
                                    $facultyId = '';
                                    $invoiceCss = '';

                                    $tempPendingAmount = $row['totalAmount'];
                                    $tempPenaltyAmount = $row['penaltyAmount'];
                                    $invoice = $row['invoice'];
                                    $invoiceStatus = $row['invoiceStatus'];
                                    $facultyId = $row['facultyId'];
                                    $workshopId = $row['workshopId'];
                                    $accountsId = $row['accountsId'];
                                    $invoiceRaisedTimestamp = $row['invoiceRaisedTimestamp'];
                                    $invoiceRaisedTimestampArray = explode(":", $invoiceRaisedTimestamp);
                                    $invoiceRaisedDate = str_replace('-', '/', $invoiceRaisedTimestampArray[0]);
                                    $workshopTitle = '"' . $row['workshopTitle'] . '"';
                                    $finalAmount = (int)$tempPendingAmount - (int)$tempPenaltyAmount;

                                    if ($row['invoiceStatus'] == 'PENDING AT OWNER') $invoiceStatusCss = "badge badge-primary fS13";
                                    if ($row['invoiceStatus'] == 'PENDING AT AUDITOR') $invoiceStatusCss = "badge badge-warning fS13";
                                    if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') $invoiceStatusCss = "badge badge-light fS13";
                                    if ($row['invoiceStatus'] == 'COMPLETED') $invoiceStatusCss = "badge badge-success fS13";
                                    if ($row['invoiceStatus'] == 'ON HOLD AT OWNER') $invoiceStatusCss = "badge badge-info fS13";

                                    if ($row['invoiceStatus'] == 'COMPLETED') {
                                        $hidBtn = 'hidden';
                                    } else {
                                        $hidBtn = '';
                                    }
                                    if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') {
                                        $disBtn = 'disabled';
                                    } else {
                                        $disBtn = '';
                                    }
                                    if ($row['invoice'] != 'PENDING') {
                                        $invoiceFile = $invoice;
                                        $invoice = "CREATED";
                                        $invoiceCss = "badge badge-success fS13";
                                    } else $invoiceCss = "badge badge-danger fS13";

                                    echo "
                                            <tr  class='tAC'>
                                                <td>" . $row['workshopId'] . "</td>
                                                <td>" . $invoiceRaisedDate . "</td>
                                                <td>" . $row["workshopTitle"] . "</td>
                                                <td>" . $row["facultyName"] . "</td>
                                                <td><span class = '" . $invoiceStatusCss . "'>" . $invoiceStatus . "</span></td>";
                                    if ($invoice != "PENDING") {
                                        echo "<td>
                                                <a class='btn btn-primary btn-sm' target='_blank' id='' href='../../../dist/documents/facultyInvoices/$facultyId/$invoiceFile'>
                                                    <i class='fas fa-eye'></i>
                                                </a>     ";
                                    } else {
                                        echo "<td></tr>";
                                    }
                                    echo " <td>
                                                <a class='btn btn-info btn-sm' target='_blank' id='$accountsId' onclick=viewOwnerInvoiceStatus(this.id,$facultyId)>
                                                    <i class='far fa-eye'></i>
                                                </a>   
                                                </td>";
                                    echo "</tr>";
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div> 
                </div>
                </div>
            </div>
        </div>

    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="allWorkshopInvoices.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    $("#allInvoiceTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

</script>
<?php require '../../common/footer.php'; ?>
