var userType = '',
    userFirstName = '',
    userLastName = '',
    userLoginId = '',
    userPassword = '',
    primaryNumber = '',
    paymentStatus = '';
ctc = '',
    maxSickLeaves = '';
sickLeaves = '';
applicableFrom = '';
flagForDuplicateEmail = false;

function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function checkForDuplicateEmail(userEmail) {
    flagForDuplicateEmail = false;
    for (i = 0; i < masterUserList.length; i++) {
        if (userEmail.trim().toLowerCase() == masterUserList[i].username.trim().toLowerCase()) {
            flagForDuplicateEmail = true;
            showError('loginID', '#ff6666', "Duplicate Email ID found. Please change it.");
            document.getElementById('saveButton').disabled = false;
        }
        else showError('', '', '');
    }
}

function setHeaders() {
    userType = '';
    userFirstName = '';
    userLastName = '';
    userLoginId = '';
    userPassword = '';
    primaryNumber = '';
    dateOfJoining = '';
    paymentStatus='';
    ctc = '';
    maxSickLeaves = '';
    sickLeaves = '';
    applicableFrom = '';

    userType = document.getElementById('userTypeDropdown').value.trim().toUpperCase();
    userFirstName = document.getElementById('firstName').value.trim().toUpperCase();
    userLastName = document.getElementById('lastName').value.trim().toUpperCase();
    primaryNumber = document.getElementById('phoneNumber').value.trim();
    ctc = document.getElementById('ctc').value.trim();
    userLoginId = document.getElementById('loginID').value.trim();
    otherUserType = document.getElementById('otherUserType').value.trim();
    userPassword = document.getElementById('password').value.trim();
    dateOfJoining = document.getElementById('dateOfJoining').value.trim();
    paymentStatus = document.getElementById('paymentStatus').value.trim();
    // sickLeaves = document.getElementById('sickLeaves').value.trim();
    // maxSickLeaves = document.getElementById('maxSickLeaves').value.trim();
    // applicableFrom = document.getElementById('applicableFrom').value.trim();
    seasonThreshold = document.getElementById('seasonThreshold').value.trim();
    seasonTarget = document.getElementById('seasonTarget').value.trim();
}

function formValidation() {
    if (userType == 'SELECT USER TYPE') {
        showError('userTypeDropdown', '#ff6666', "Select Access Privileges.");
        return 0;
    } else showError('userTypeDropdown', '', '');
    if (userType == "OTHER") {
        if (otherUserType == '') {
            showError('otherUserType', '#ff6666', "Other User Type Cannot be blank");
            return 0;
        } else showError('otherUserType', '', '');
    }
    if (userFirstName == '') {
        showError('firstName', '#ff6666', "First Name cannot be Blank.");
        return 0;
    } else showError('firstName', '', '');

    if (userLastName == '') {
        showError('lastName', '#ff6666', "Last Name cannot be Blank.");
        return 0;
    } else showError('lastName', '', '');
    if (primaryNumber == "") {
        showError('phoneNumber', '#ff6666', "Primary number can not be blank.");
        return 0;
    } else showError('phoneNumber', '', '');
    if (primaryNumber.length != 10) {
        showError('phoneNumber', '#ff6666', "Phone number should be of 10 digit only.");
        return 0;
    } else showError('phoneNumber', '', '');


    if (userLoginId == '') {
        showError('loginID', '#ff6666', "Login ID cannot be Blank.");
        return 0;
    } else showError('loginID', '', '');
    if (!validateEmail(userLoginId)) {
        showError('loginID', '#ff6666', "Login ID is not in correct format. Please correct it.");
        return 0;
    } else showError('loginID', '', '');
    if (userPassword == '') {
        showError('password', '#ff6666', "Password cannot be Blank.");
        return 0;
    } else showError('password', '', '');
    checkForDuplicateEmail(userLoginId);
    if (flagForDuplicateEmail) {
        showError('loginID', '#ff6666', "Duplicate Login Id found. Please change it.");
        return 0;
    } else showError('loginID', '', '');
    if (ctc == '') {
        showError('ctc', '#ff6666', "Add CTC");
        return 0;
    } else showError('ctc', '', '');

    if (ctc < 0) {
        showError('ctc', '#ff6666', "CTC can not be negative.");
        return 0;
    } else showError('ctc', '', '');

    if (dateOfJoining == '') {
        showError('dateOfJoining', '#ff6666', "Enter Date Of Joining");
        return 0;
    } else showError('dateOfJoining', '', '');

 if (paymentStatus== 'SELECT PAYMENT STATUS') {
        showError('paymentStatus', '#ff6666', "Please select payment status");
        return 0;
    }
     else showError('paymentStatus', '', '');
    if (user_type == 'BUSINESS DEVELOPMENT OFFICER') {
        if (seasonThreshold == '') {
            showError('seasonThreshold', '#ff6666', "Enter Season Threshold");
            return 0;
        } else showError('seasonThreshold', '', '');

        if (seasonTarget == '') {
            showError('seasonTarget', '#ff6666', "Enter Season target");
            return 0;
        } else showError('seasonTarget', '', '');
    }
    // if (sickLeaves == '') {
    //     showError('sickLeaves', '#ff6666', "Please add total number of sick leaves");
    //     return 0;
    // } else showError('sickLeaves', '', '');

    // if (parseFloat(sickLeaves) < 0) {
    //     showError('sickLeaves', '#ff6666', "Total number of sick leaves cannot be negative");
    //     return 0;
    // } else showError('sickLeaves', '', '');

    // if (maxSickLeaves == '') {
    //     showError('maxSickLeaves', '#ff6666', "Please add Max. number of sick leaves");
    //     return 0;
    // } else showError('maxSickLeaves', '', '');

    // if (parseFloat(maxSickLeaves) < 0) {
    //     showError('maxSickLeaves', '#ff6666', "Max. number of sick leaves cannot be negative");
    //     return 0;
    // } else showError('maxSickLeaves', '', '');
    // if (applicableFrom == '') {
    //     showError('applicableFrom', '#ff6666', "Please select date");
    //     return 0;
    // } else showError('applicableFrom', '', '');

    return 1;
}

function saveUser() {
    var saveFlag = 'addUser';
    document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (formValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return 0;
    }
    if (checkOnline() == false) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    else {
        if (true) {
            console.log(applicableFrom)

            if ("Are you sure you want to save user?") {
                document.getElementById('saveButton').disabled = true;
                document.getElementById('successMessage').innerHTML = 'Adding User.. Please Wait....';
                $.post('saveUser.php', {
                    'userFirstName': userFirstName,
                    'userLastName': userLastName,
                    'primaryNumber': primaryNumber,
                    'userLoginId': userLoginId,
                    'userPassword': userPassword,
                    'userType': userType,
                    'ctc': ctc,
                    'otherUserType': otherUserType,
                    'dateOfJoining': dateOfJoining,
                     'paymentStatus': paymentStatus,
                    'saveFlag': saveFlag,
                    // 'maxSickLeaves': maxSickLeaves,
                    // 'sickLeaves': sickLeaves,
                    // 'applicableFrom': applicableFrom,
                    'seasonThreshold' : seasonThreshold,
                    'seasonTarget' : seasonTarget

                }, function (data) {
                    console.log(data);
                    document.getElementById('successMessage').innerHTML = 'Saved successfully. Please wait. Page will get auto-refresh.';
                    location.reload();
                });
            }
            else document.getElementById('saveButton').disabled = false;
        }
    }
}

function showDetails(userId, userType) {
    if (userType == 'COUNSELOR') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewCouncelorProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    } else if (userType == 'BUSINESS DEVELOPMENT OFFICER') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewCouncelorProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'ACADEMIC EXECUTIVE') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewAcademicProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'ACCOUNTS EXECUTIVE') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewAccountantsProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    } else if (userType == 'ACADEMIC QUALITY MANAGER') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewAQMProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'BUSINESS DEVELOPMENT EXECUTIVE') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        window.location.href = "viewBDEprofile.php?" + encodedKey_userId + "=" + encodedValue_userId;
    }
    else if (userType == 'CENTER MANAGER') {
        encodedKey_userId = btoa('userId');
        encodedValue_userId = btoa(userId);
        // window.location.href = "../UT/companyMaster.php";
                window.location.href = "viewCMProfile.php?" + encodedKey_userId + "=" + encodedValue_userId;

    }
}

function userEdit(userId) {
    encodedKey_userId = btoa('userId');
    encodedValue_userId = btoa(userId);
    window.location.href = 'editUserDetails.php?' + encodedKey_userId + "=" + encodedValue_userId;
}

function showOtherUSerType() {

    user_type = document.getElementById("userTypeDropdown").value.trim().toUpperCase();
    if (user_type == 'OTHER') {
        document.getElementById('otherUserTypeDiv').hidden = false;
    } else {
        document.getElementById('otherUserTypeDiv').hidden = true;
    }

    if (user_type == 'BUSINESS DEVELOPMENT OFFICER') {
        document.getElementById('seasonthresholdDiv').hidden = false;
        document.getElementById('seasontargetDiv').hidden = false;
    } else {
        document.getElementById('seasonthresholdDiv').hidden = true;
        document.getElementById('seasontargetDiv').hidden = true;
    }
}

function filterOtherDropDown(flag) {

    var table = $('#usersTable').DataTable();
    table.draw();
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}