<?php
session_start();
if (isset($_SESSION['ownerLoginsuccessEdj'])) {

    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location: ../../../loginPage.php');
        exit;
    }
} else {
    header('Location: ../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>
<div class="modal fade" id="referralModal" tabindex="-1" role="dialog" aria-labelledby="referralModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Referral Bonus Approval</h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="rowId" name="rowId">

                <div class="row">
                    <div class="form-group col-md-6">
                        <label>Referrer ID</label>
                        <input type="text" id="referrerId" class="form-control" disabled>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Referrer Name</label>
                        <input type="text" id="referrerName" class="form-control" disabled>
                    </div>

                    <div class="form-group col-md-6">
                        <label>Referred ID</label>
                        <input type="text" id="referredId" class="form-control" disabled>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Referred Name</label>
                        <input type="text" id="referredName" class="form-control" disabled>
                    </div>

                    <div class="form-group col-md-6">
                        <label>Payment Purpose</label>
                        <input type="text" id="paymentPurpose" class="form-control" disabled>
                    </div>
                    <div class="form-group col-md-6">
                        <label>Amount (₹)</label>
                        <input type="text" id="amount" class="form-control">
                    </div>
                </div>
                    <div class="row" id='viewaccpetedDiv' hidden>
                        <div class="col-md-4">
                            <label>Payment Approval Status:</label>
                            <label><span class='badge badge-success'>APPROVED</label>
                        </div>
                    </div>
                    <div class="row" id='viewrejectedDiv' hidden>
                        <div class="col-md-4">
                            <label>Payment Approval Status:</label>
                            <label><span class='badge badge-danger'>REJECTED</label>
                        </div>
                    </div>

                    <!-- <div class="form-group col-md-6" id='checkBoxDiv' hidden>
                        <label><strong>Action:</strong></label><br>
                        <div>
                            <input type="radio" name="action" value="APPROVE" id="approveAction" class="mr-2"> Approve &nbsp;&nbsp;
                            <input type="radio" name="action" value="REJECT" id="rejectAction" class="mr-2"> Reject
                        </div>
                    </div> -->

                    <div class="form-group col-md-12" id="commentBoxDiv">
                        <label>Comments</label>
                        <textarea name="commentBox" id="comments" class="form-control" rows="3"></textarea>
                    </div>
                
            </div>

            <div class="modal-footer">
                <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                </p>
                <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                </p>
                <button type="button" class="btn btn-success" id="submitBtn" onclick="submitReferral()">Submit</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING PAYMENT APPROVAL</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="cashBackTable">
                                <thead>
                                    <tr>
                                        <th style="width:20%;">
                                            REFERRER STUDENT NAME
                                        </th>
                                        <th style="width:15%;">
                                            REFERRED STUDENT ID
                                        </th>
                                        <th style="width:20%;">
                                            REFERRED STUDENT NAME
                                        </th>
                                        <th style="width:20%;">
                                            PAYMENT TYPE
                                        </th>
                                        <th style="width:20%;">
                                            AMOUNT
                                        </th>

                                        <th style="width:15%;">
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    // $sql = "SELECT * from payablepaymenthistory WHERE payablePaymentStatus = 'PENDING' AND paymentDescription != 'COLLEGE PAYMENT' ORDER BY studentId desc; ";
                                    $sql = "SELECT * FROM referbonuspayment WHERE ownerApproval='PENDING' or payablePaymentStatus='PENDING' ORDER BY rowId";
                                    $result = $conn->query($sql);

                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $referrerId = $row['studentId'];
                                            $referredId = $row['referredStudentId'];
                                            $paymentPurpose = $row['paymentPurpose'];
                                            $paymentPurpose1 = '"' . $paymentPurpose . '"';
                                            $amount = $row['amount'];
                                            $rowId = $row['rowId'];
                                            $validationStatus = $row['ownerApproval'];
                                            $comments = $row['comments'];
                                            $validationStatus1 = '"' . $validationStatus . '"';
                                            $comments1 = '"' . $comments . '"';

                                            $referrerName = $row['studentFirstName'] . ' ' . $row['studentLastName'];
                                            $referrerName1 = '"' . $referrerName . '"';
                                            $referredName = '';
                                            $sql2 = "SELECT leadFirstName, leadLastName FROM leads WHERE leadId = '$referredId'";
                                            $res2 = $conn->query($sql2);
                                            if ($res2->num_rows > 0) {
                                                $r2 = $res2->fetch_assoc();
                                                $referredName = $r2['leadFirstName'] . ' ' . $r2['leadLastName'];
                                                $referredName1 = '"' . $referredName . '"';
                                            }

                                            echo "<tr class='tAC'>
              <td>$referrerName</td>
              <td>$referredId</td>
              <td>$referredName</td>
              <td>$paymentPurpose</td>
              <td>₹$amount</td>
              <td>
                  <button class='btn btn-primary btn-sm fS18' title='Click to view' 
    onclick='openReferralModal($rowId,$referrerId,$referredId,$referrerName1,$referredName1,$paymentPurpose1,$amount,$validationStatus1,$comments1)'>
    <i class='fas fa-eye fS15'></i>
</button>
              </td>
            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
                var comments='';
    function openReferralModal(rowId, referrerId, referredId, referrerName, referredName, paymentPurpose, amount, validationStatus,comments1) {
        $('#rowId').val(rowId);
        $('#referrerId').val(referrerId);
        $('#referredId').val(referredId);
        $('#referrerName').val(referrerName);
        $('#referredName').val(referredName);
        $('#paymentPurpose').val(paymentPurpose);
        $('#amount').val(amount);
        $('#comments').val(comments1);
       

        $('input[name="action"][value="APPROVE"]').prop('checked', true);
      
        const comments = $('#comments').val().trim();
        if (validationStatus === "APPROVED") {
            $('#submitBtn').prop('disabled', true);
            $('#amount').prop('disabled', true);
            $('#comments').prop('disabled', true);

            // document.getElementById("checkBoxDiv").hidden=true;
            document.getElementById("viewaccpetedDiv").hidden=false;
            document.getElementById("viewrejectedDiv").hidden=true;   

        } else if(validationStatus === "REJECTED"){
            $('#submitBtn').prop('disabled', false).text("Submit");
            $('#amount').prop('disabled', true);
            // document.getElementById("checkBoxDiv").hidden=false;
            document.getElementById("viewaccpetedDiv").hidden=true;
            document.getElementById("viewrejectedDiv").hidden=false;   
        }
        else{
            $('#submitBtn').prop('disabled', false).text("Submit");
            $('#amount').prop('disabled', false);
            // document.getElementById("checkBoxDiv").hidden=false;
            document.getElementById("viewaccpetedDiv").hidden=true;
            document.getElementById("viewrejectedDiv").hidden=true;   

        }
        $('#referralModal').modal('show');

     
    }



    function submitReferral() {
        $('#errorMessage').text('');
        $('#successMessage').text('');

        let hasError = false;

        const requiredFields = [{
                id: 'referrerId',
                name: 'Referrer ID'
            },
            {
                id: 'referrerName',
                name: 'Referrer Name'
            },
            {
                id: 'referredId',
                name: 'Referred ID'
            },
            {
                id: 'referredName',
                name: 'Referred Name'
            },
            {
                id: 'paymentPurpose',
                name: 'Payment Purpose'
            },
            {
                id: 'amount',
                name: 'Amount'
            }
        ];

        requiredFields.forEach(field => {
            $('#' + field.id).css('background-color', '');
        });

        for (let field of requiredFields) {
            const value = $('#' + field.id).val().trim();
            if (!value) {
                $('#' + field.id).css('background-color', 'red');
                $('#errorMessage').text(field.name + ' cannot be empty.');
                hasError = true;
                break;
            }
            comments=$('#comments').val().trim();
            const formData = new FormData();
            formData.append('rowId', $('#rowId').val());
            formData.append('referrerId', $('#referrerId').val());
            formData.append('referredId', $('#referredId').val());
            formData.append('referrerName', $('#referrerName').val());
            formData.append('referredName', $('#referredName').val());
            formData.append('paymentPurpose', $('#paymentPurpose').val());
            formData.append('amount', $('#amount').val());
            // formData.append('action', selectedAction);
            formData.append('comments',comments);

            $.ajax({
                url: "saveReferalPaymentStatus.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                enctype: 'multipart/form-data',
                success: function(response) {
                    console.log(response);
                    $('#successMessage').text("Submission successful.");
                    // $('#referralModal').modal('hide');
                    // setTimeout(() => location.reload(), 1000);
                }
            });
        }
    }

    $(function() {
        $("#cashBackTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>