<span id="lDetails">
    <div class="card-body">
        <table class="table table-striped projects tAC " id="logReportTable">
            <thead>
                <tr>
                    <th class="col-md-2">
                        Date And Time
                    </th>
                    <th class="col-md-3">
                        User Name
                    </th>
                    <th class="col-md-2">
                        Action
                    </th>
                    <th class="col-md-5">
                        Statement
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php
                require_once '../../common/connectToDB.php';
                $firstDay = '';
                $lastDay = '';
                $selectedUserId = '';
                $selectedUserType = '';

                if (isset($_POST['genReport'])) {
                    $firstDay = $_POST['firstDay'];
                    $lastDay = $_POST['lastDay'];
                    $selectedUserId =  $_POST['selectedUserId'];
                    $selectedUserType =  $_POST['selectedUserType'];

                    if ($lastDay == '') $lastDay = date('d-m-Y');
                    $sql = "SELECT * from logtable where ";
                    if ($firstDay != '' && $lastDay != '')
                        $sql = $sql . " str_to_date(timeStamp, '%d-%m-%Y') between str_to_date('" . str_replace("/", "-", $firstDay) . "', '%d-%m-%Y') and str_to_date('" . str_replace("/", "-", $lastDay) . "', '%d-%m-%Y') and ";
                    if (count($selectedUserId) > 0 && strlen($selectedUserId[0]) != 0) {
                        $sql = $sql . " userId IN (";
                        for ($i = 0; $i < count($selectedUserId); $i++) {
                            $sql = $sql . "'" . $selectedUserId[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ') AND';
                    }
                    if (count($selectedUserType) > 0 && strlen($selectedUserType[0]) != 0) {
                        $sql = $sql . " user_type IN (";
                        for ($i = 0; $i < count($selectedUserType); $i++) {
                            $sql = $sql . "'" . $selectedUserType[$i] . "',";
                        }
                        $sql = rtrim($sql, ',');
                        $sql = $sql . ') AND';
                    }
                    $sql = $sql . " 1 order by logid desc;";

                    $result = $conn->query($sql);
                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $statusCss = "badge badge-success fS15";
                            if (strtoupper($row["logtype"]) == 'DELETE') {
                                $statusCss = "badge badge-danger fS15";
                            } else if (strtoupper($row["logtype"]) == 'CREATE') {
                                $statusCss = "badge badge-success fS15";
                            } else if (strtoupper($row["logtype"]) == 'UPDATE') {
                                $statusCss = "badge badge-warning fS15";
                            } else if (strtoupper($row["logtype"]) == "LOGIN") {
                                $statusCss = "badge badge-info fS15";
                            } else if (strtoupper($row["logtype"]) == "LOGOUT") {
                                $statusCss = "badge badge-info fS15";
                            } else if (strtoupper($row["logtype"]) == "APPROVE") {
                                $statusCss = "badge badge-success fS15";
                            }

                            echo "
                                <tr  class='tAC'>
                                    <td>" . $row["timeStamp"] . "</td>  
                                    <td>" . $row["username"] . ' (' . $row["user_type"] . ')' . "</td>
                                    <td ><span class = '" . $statusCss . "'>" . $row["logtype"] . "</span></td> 
                                    <td align='center'>" . $row["statement"] . "</td> 
                                </tr>
                                ";
                        }
                    }
                }
                ?>
            </tbody>
        </table>
    </div>
</span>
<script>
    $(function() {
        $("#logReportTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 15,
            "aaSorting": []
        });
    });
</script>