<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$userDetails = [];
$userType = [];
$facultyDetails = [];
$studentDetails = [];
$lifeCoachDetails = [];

$sql    = "SELECT firstname,lastname,user_type,userid from logindetail order by trim(firstname), trim(lastname) desc;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    $userDetails = [];
    while ($row = $result->fetch_assoc()) {
        array_push($userDetails, $row);
    }
} else {
}

$sql2 = "SELECT DISTINCT user_type from logindetail order by trim(user_type) asc;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    $userType = [];
    while ($row2 = $result2->fetch_assoc()) {
        array_push($userType, $row2['user_type']);
    }
} else {
}
array_push($userType, 'FACULTY', 'LIFE COACH', 'STUDENT');

$sql3 = "SELECT firstName,lastName,facultyId from faculty order by trim(firstName), trim(lastName) desc;";
$result3 = $conn->query($sql3);
if ($result3->num_rows > 0) {
    while ($row3 = $result3->fetch_assoc()) {
        array_push($facultyDetails, $row3);
    }
} else {
}

$sql4 = "SELECT firstname,lastname,studentId from loginstudents order by trim(firstname), trim(lastname) desc;";
$result4 = $conn->query($sql4);
if ($result4->num_rows > 0) {
    while ($row4 = $result4->fetch_assoc()) {
        array_push($studentDetails, $row4);
    }
} else {
}

$sql5 = "SELECT firstName,lastName,lifeCoachId from lifecoachdetails order by trim(firstName), trim(lastName) desc;";
$result5 = $conn->query($sql5);
if ($result5->num_rows > 0) {
    while ($row5 = $result5->fetch_assoc()) {
        array_push($lifeCoachDetails, $row5);
    }
} else {
}
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Log Report </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>Log From To Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="logFromToDate" placeholder="Enter Date" />
                                            <div class="input-group-append" data-target="#logFromToDate">
                                                <div class="input-group-text"> <i class="fa fa-calendar" data-toggle="daterangepicker"> </i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>User Type</label>
                                        <select class="Select2" multiple="multiple" id="userType" onchange="filterOtherDropDown('uType')" data-placeholder="SELECT USER TYPE">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>User Name</label>
                                        <select class="Select2" multiple="multiple" id="userName" onchange="filterOtherDropDown('uName')" data-placeholder="SELECT USER NAME">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <input type="button" class="btn btn-primary mT27" value="Generate Report" id="generate" />
                                </div>
                            </div>
                            <div class="row ">
                                <div class="col-md-12">
                                    <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                    </p>
                                    <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php require 'logReportDetails.php'; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="logReport.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    $(function() {
        $(document).ready(function() {
            // date
            $('.select2').select2();
            $('#logFromToDate').daterangepicker({
                autoApply: true,
                "alwaysShowCalendars": true,
                locale: {
                    format: 'DD/MM/YYYY',
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
            });
            $('#logFromToDate').val("");

            // generate button
            $("#generate").click(function() {
                if (checkOnline() == false) return;
                var fromLogDate = '';
                var toLogDate = '';
                var tempDate = document.getElementById("logFromToDate").value;
                if (tempDate != '') {
                    fromLogDate = (tempDate.split("-"))[0];
                    toLogDate = (tempDate.split(" - "))[1];
                }
                var temp, firstname, lastname, selectedUser = '',
                    selectedUserId = '',
                    selectedUserType = '';
                var selectedUserId = getSelectValues('value', document.getElementById("userName")).trim().slice(0, -1);
                var selectedUserType = getSelectValues('multiple', document.getElementById("userType")).trim().slice(0, -1);

                if (tempDate == '' && selectedUserId == '' && selectedUserType == '') {
                    showError('', '#ff6666', 'Select atlest 1 dropdown To generate the list.');
                    return 0;
                } else showError('', '', '');

                document.getElementById("successMessage").innerHTML = "Please wait while we load the data.";
                document.getElementById("generate").disabled = true;
                $.post('logReportDetails.php', {
                    'firstDay': fromLogDate.trim(),
                    'lastDay': toLogDate.trim(),
                    'selectedUserId': selectedUserId.split('|'),
                    'selectedUserType': selectedUserType.split('|'),
                    'genReport': true
                }, function(data) {
                    $('#lDetails').html(data);
                    document.getElementById("successMessage").innerHTML = "";
                    document.getElementById("generate").disabled = false;
                });
            });
            userDetails = <?php echo json_encode($userDetails); ?>;
            userType = <?php echo json_encode($userType); ?>;
            facultyDetails = <?php echo json_encode($facultyDetails); ?>;
            studentDetails = <?php echo json_encode($studentDetails); ?>;
            lifeCoachDetails = <?php echo json_encode($lifeCoachDetails); ?>;

            for (i = 0; i < facultyDetails.length; i++) {
                userDetails.push(obj = {
                    "firstname": facultyDetails[i].firstName,
                    "lastname": facultyDetails[i].lastName,
                    "user_type": 'FACULTY',
                    "userid": facultyDetails[i].facultyId
                });
            }
            for (i = 0; i < studentDetails.length; i++) {
                userDetails.push(obj = {
                    "firstname": studentDetails[i].firstname,
                    "lastname": studentDetails[i].lastname,
                    "user_type": 'STUDENT',
                    "userid": studentDetails[i].studentId
                });
            }
            for (i = 0; i < lifeCoachDetails.length; i++) {
                userDetails.push(obj = {
                    "firstname": lifeCoachDetails[i].firstName,
                    "lastname": lifeCoachDetails[i].lastName,
                    "user_type": 'LIFE COACH',
                    "userid": lifeCoachDetails[i].lifeCoachId
                });
            }
            userType.sort((a, b) => a.localeCompare(b))
            loadDataDropdown("userType", userType);
            loadDataDropdown("userName", []);
        });
    });
</script>
<?php require '../../common/footer.php'; ?>