<span id="performanceTableDetails">
    <div class="card-body">
        <table class="table table-striped projects tAC" id="performanceTable">
            <thead>
                <tr>
                    <th class="col-md-2">Date</th>
                    <th class="col-md-3">BDO Name</th>
                    <th class="col-md-2">Meetings Booked</th>
                    <th class="col-md-2">Meetings Executed</th>
                </tr>
            </thead>
            <tbody>
            <?php
require_once '../../common/connectToDB.php';

if (isset($_POST['genReport'])) {
    $firstDay = $_POST['firstDay'];
    $lastDay = $_POST['lastDay'];
    $selectedbdoName = $_POST['selectedbdoName'];

    $firstDayFormatted = DateTime::createFromFormat('d/m/Y', $firstDay)->format('Y-m-d');
    $lastDayFormatted = DateTime::createFromFormat('d/m/Y', $lastDay)->format('Y-m-d');

    $meetingsBookedData = [];
    $meetingsExecutedData = [];
    $bdoNames = [];

    $sqlMeetingsBooked = "
        SELECT agency_counselor_Id,
               DATE(STR_TO_DATE(meetingScheduleDateAndTime, '%d-%m-%y : %h:%i:%sp')) AS meetingDate,
               COUNT(*) AS bookedCount
        FROM followup
        WHERE followUpType = 'MEETING'
          
          AND agency_counselor_Id != ''
          AND STR_TO_DATE(meetingScheduleDateAndTime, '%d-%m-%y : %h:%i:%sp') BETWEEN '$firstDayFormatted' AND '$lastDayFormatted'
    ";
    if (!empty($selectedbdoName) && strlen($selectedbdoName[0]) != 0) {
        $sqlMeetingsBooked .= " AND agency_counselor_Id IN ('" . implode("','", $selectedbdoName) . "')";
    }
    $sqlMeetingsBooked .= " GROUP BY meetingDate, agency_counselor_Id";

    // echo $sqlMeetingsBooked;
    $resultBooked = $conn->query($sqlMeetingsBooked);
    while ($row = $resultBooked->fetch_assoc()) {
        $date = date('d-m-Y', strtotime($row['meetingDate']));
        $bdoId = $row['agency_counselor_Id'];
        $meetingsBookedData[$date][$bdoId] = $row['bookedCount'];
    }

    $sqlMeetingsExecuted = "
    SELECT agency_counselor_Id,
           STR_TO_DATE(UPPER(meetingExecutionDateAndTime), '%d-%m-%y : %h:%i:%s%p') AS executionDate,
           COUNT(*) AS executedCount
    FROM followup
    WHERE followUpType = 'MEETING'
      AND followupStatus = 'COMPLETED'
      AND agency_counselor_Id != ''
      AND  STR_TO_DATE(UPPER(meetingExecutionDateAndTime), '%d-%m-%y : %h:%i:%s%p') BETWEEN '$firstDayFormatted' AND '$lastDayFormatted'  ";
    if (!empty($selectedbdoName) && strlen($selectedbdoName[0]) != 0) {
        $sqlMeetingsExecuted .= " AND agency_counselor_Id IN ('" . implode("','", $selectedbdoName) . "')";
    }
    $sqlMeetingsExecuted .= " GROUP BY executionDate, agency_counselor_Id";

    // echo $sqlMeetingsExecuted;
    $resultExecuted = $conn->query($sqlMeetingsExecuted);
    while ($row = $resultExecuted->fetch_assoc()) {
        $date = date('d-m-Y', strtotime($row['executionDate']));
        $bdoId = $row['agency_counselor_Id'];
        $meetingsExecutedData[$date][$bdoId] = $row['executedCount'];
    }

    $allDates = array_unique(array_merge(array_keys($meetingsBookedData), array_keys($meetingsExecutedData)));
    sort($allDates);

    $allBDOs = [];
    foreach (array_merge_recursive($meetingsBookedData, $meetingsExecutedData) as $dayData) {
        foreach (array_keys($dayData) as $bdoId) {
            $allBDOs[$bdoId] = true;
        }
    }
    $bdoIdList = array_keys($allBDOs);

    if (!empty($bdoIdList)) {
        $bdoNamesQuery = "SELECT userid, CONCAT(firstname, ' ', lastname) as bdOUserName 
                          FROM logindetail 
                          WHERE userid IN ('" . implode("','", $bdoIdList) . "')";
        $resultNames = $conn->query($bdoNamesQuery);
        while ($row = $resultNames->fetch_assoc()) {
            $bdoNames[$row['userid']] = $row['bdOUserName'];
        }
    }

    foreach ($allDates as $date) {
        $bdesOnThisDate = array_unique(array_merge(
            isset($meetingsBookedData[$date]) ? array_keys($meetingsBookedData[$date]) : [],
            isset($meetingsExecutedData[$date]) ? array_keys($meetingsExecutedData[$date]) : []
        ));

        foreach ($bdesOnThisDate as $bdoId) {
            $bookedMeetings = $meetingsBookedData[$date][$bdoId] ?? 0;
            $executedMeetings = $meetingsExecutedData[$date][$bdoId] ?? 0;
            $bdoName = $bdoNames[$bdoId] ?? '';

            echo "
                <tr class='tAC'>
                    <td>$date</td>
                    <td>" . htmlspecialchars($bdoName) . "</td>
                    <td>$bookedMeetings</td>
                    <td>$executedMeetings</td>
                </tr>
            ";
        }
    }

    if (empty($meetingsBookedData) && empty($meetingsExecutedData)) {
        echo "<tr><td colspan='4' class='text-center'>No data available for selected filters.</td></tr>";
    }
}
?>

            </tbody>
        </table>
    </div>
</span>

<script>
    $(function() {
        $("#performanceTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 15,
            "aaSorting": []
        });
    });
</script>
