<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';

$userDetails = [];
$bdoName = [];
$facultyDetails = [];
$studentDetails = [];
$lifeCoachDetails = [];

$sql    = "SELECT firstname,lastname,user_type,userid from logindetail order by trim(firstname), trim(lastname) desc;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    $userDetails = [];
    while ($row = $result->fetch_assoc()) {
        array_push($userDetails, $row);
    }
} else {
}

$sql2 = "SELECT userid,concat(firstname,' ',lastname) as bdoName from logindetail where user_type='BUSINESS DEVELOPMENT OFFICER' order by trim(userid) desc;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    $bdoName = [];
    while ($row2 = $result2->fetch_assoc()) {
        array_push($bdoName, $row2);
    }
} else {
}
// array_push($bdoName, 'FACULTY', 'LIFE COACH', 'STUDENT');

?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">BDO Performance Report </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>From To Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control " id="fromToDate" placeholder="Enter Date" />
                                            <div class="input-group-append" data-target="#fromToDate">
                                                <div class="input-group-text"> <i class="fa fa-calendar" data-toggle="daterangepicker"> </i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>BDO</label>
                                        <select class="Select2" multiple="multiple" id="bdoName" data-placeholder="SELECT BDO" style="width: 100%;">
                                        </select>
                                    </div>
                                </div>
                                <!-- <div class="col-md-4">
                                    <div class="form-group">
                                        <label>User Name</label>
                                        <select class="Select2" multiple="multiple" id="userName" onchange="filterOtherDropDown('uName')" data-placeholder="SELECT USER NAME"style="width: 100%;">
                                        </select>
                                    </div>
                                </div> -->
                                <div class="col-md-2" style="margin-top:5px;">
                                    <input type="button" class="btn btn-primary mT27" value="Generate Report" id="generate" />
                                </div>
                            </div>
                            <div class="row ">
                                <div class="col-md-12">
                                    <p id='errorMessage' class="text-center" style="color: red; font-size: 1.2em;   text-align: center;">
                                    </p>
                                    <p id='successMessage' class="text-center" style="color: #25C032; font-size: 1.2em;   text-align: center;">
                                    </p>
                                </div>
                            </div>
                        </div>
                        <?php require 'bdoPerformanceReportDetails.php'; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/moment.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<!-- <script src="logReport.js?v=<?php echo $fileVersion; ?>"></script> -->
<script>
    $(function() {
        $(document).ready(function() {
            // date
            $('.select2').select2();
            $('#fromToDate').daterangepicker({
                autoApply: true,
                "alwaysShowCalendars": true,
                locale: {
                    format: 'DD/MM/YYYY',
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
            });
            $('#fromToDate').val("");

            // generate button
            $("#generate").click(function() {
                if (checkOnline() == false) return;
                var fromLogDate = '';
                var toLogDate = '';
                var tempDate = document.getElementById("fromToDate").value;
                if (tempDate != '') {
                    fromLogDate = (tempDate.split("-"))[0];
                    toLogDate = (tempDate.split(" - "))[1];
                }
                var temp, firstname, lastname, selectedUser = '',
                    selectedUserId = '',
                    selectedbdoName = '';
                // var selectedUserId = getSelectValues('value', document.getElementById("userName")).trim().slice(0, -1);
                var selectedbdoName = getSelectValues('multiple', document.getElementById("bdoName")).trim().slice(0, -1);
                console.log(selectedbdoName, 'selectedbdoName');
                if (tempDate == '' && selectedUserId == '' && selectedbdoName == '') {
                    showError('', '#ff6666', 'Select atlest 1 dropdown To generate the list.');
                    return 0;
                } else showError('', '', '');
                document.getElementById("successMessage").innerHTML = "Please wait while we load the data.";
                document.getElementById("generate").disabled = true;
                $.post('bdoPerformanceReportDetails.php', {
                    'firstDay': fromLogDate.trim(),
                    'lastDay': toLogDate.trim(),
                    'selectedUserId': selectedUserId.split('|'),
                    'selectedbdoName': selectedbdoName.split('|'),
                    'genReport': true
                }, function(data) {
                    $('#performanceTableDetails').html(data);
                    document.getElementById("successMessage").innerHTML = "";
                    document.getElementById("generate").disabled = false;
                });
            });
            bdoName = <?php echo json_encode($bdoName); ?>;
            console.log(bdoName, 'bdoName');
            loadDataDropdown("bdoName", bdoName);
        });
    });
</script>


<script>
    function loadDataDropdown(selectName, results) {
        var theSelect = document.getElementById(selectName);

        var options = theSelect.getElementsByTagName("option");
        theSelect.innerHTML = "";
        options = document.createElement("option");
        options.value = "";

        for (var i = 0; i < results.length; i++) {
            options = document.createElement("option");
            if (selectName == "bdoName") {
                options.text = (results[i]['bdoName']);
                options.value = (results[i]['userid']);
                theSelect.add(options);
            }
            // } else if (selectName == "userType") {
            //     options.value = (results[i]);
            //     options.text = (results[i]).toUpperCase();
            //     theSelect.add(options);
            // }
        }
        return;
    }

    function getSelectValues(flag, selectVar) {
        var result = "";
        var options = selectVar && selectVar.options;
        var opt;
        for (var i = 0, iLen = options.length; i < iLen; i++) {
            opt = options[i];
            if (flag == '') {
                if (opt.selected) {
                    result += opt.text;
                }
            }
            if (flag == "multiple") {
                if (opt.selected) {
                    result += opt.value + "|";
                }
            }
            if (flag == "value") {
                if (opt.selected) {
                    result += opt.value + "|";
                }
            }
        }
        return result.trim();
    }

    function showError(id, color, message) {
        if (id != '')
            document.getElementById(id).style.backgroundColor = color;
        document.getElementById('errorMessage').innerHTML = message;
    }
</script>

<?php require '../../common/footer.php'; ?>