<span id="performanceTableDetails">
    <div class="card-body">
        <table class="table table-striped projects tAC" id="performanceTable">
            <thead>
                <tr>
                    <th class="col-md-2">Date</th>
                    <th class="col-md-3">BDE Name</th>
                    <th class="col-md-2">Attended Calls</th>
                    <th class="col-md-2">Unattended Calls</th>
                    <th>Leads Generated</th>
                </tr>
            </thead>
            <tbody>
                <?php
                require_once '../../common/connectToDB.php';
                if (isset($_POST['genReport'])) {
                    $firstDay = $_POST['firstDay'];
                    $lastDay = $_POST['lastDay'];
                    $selectedbdeName = $_POST['selectedbdeName'];

                    $firstDayObj = DateTime::createFromFormat('d/m/Y', $firstDay);
                    $lastDayObj = DateTime::createFromFormat('d/m/Y', $lastDay);
                    $firstDayFormatted = $firstDayObj->format('Y-m-d');
                    $lastDayFormatted = $lastDayObj->format('Y-m-d');

                    $followupData = [];
                    $leadsData = [];
                    $bdeNames = [];

                    //  FETCH FOLLOW-UP DATA
                    $sql = "SELECT planDate, agency_bde_Id,
                        SUM(CASE WHEN final_outcome = 'ATTENDED' THEN 1 ELSE 0 END) AS attended_count,
                        SUM(CASE WHEN final_outcome = 'NOT_ATTENDED' THEN 1 ELSE 0 END) AS not_attended_count
                    FROM (
                        SELECT 
                            planDate,
                            agency_bde_Id,
                            leadId,
                            CASE 
                                WHEN SUM(CASE WHEN outcome = 'ATTENDED' THEN 1 ELSE 0 END) > 0 THEN 'ATTENDED'
                                ELSE 'NOT_ATTENDED'
                            END AS final_outcome
                        FROM followup
                        WHERE followUpType='CALL'";

                    if (!empty($firstDay) && !empty($lastDay)) {
                        $sql .= " AND STR_TO_DATE(planDate, '%d-%m-%Y') BETWEEN STR_TO_DATE('" . str_replace("/", "-", $firstDay) . "', '%d-%m-%Y')
                                  AND STR_TO_DATE('" . str_replace("/", "-", $lastDay) . "', '%d-%m-%Y')";
                    }

                    if (!empty($selectedbdeName) && strlen($selectedbdeName[0]) != 0) {
                        $sql .= " AND agency_bde_Id IN ('" . implode("','", $selectedbdeName) . "')";
                    }

                    $sql .= " GROUP BY planDate, agency_bde_Id, leadId
                    ) AS filtered
                    GROUP BY planDate, agency_bde_Id ORDER BY CAST(leadId AS UNSIGNED) DESC";

                    $result = $conn->query($sql);
                    while ($row = $result->fetch_assoc()) {
                        $date = $row['planDate'];
                        $bdeId = $row['agency_bde_Id'];
                        $followupData[$date][$bdeId] = [
                            'attended' => $row['attended_count'],
                            'unattended' => $row['not_attended_count']
                        ];
                    }

                    //  FETCH LEADS DATA
                    $sqlLead = "SELECT 
                        STR_TO_DATE(leadCreationTimeStamp, '%d-%m-%Y') AS planDate,
                        leadBDEId,
                        COUNT(*) AS leadCount
                    FROM leads
                    WHERE leadBDEId IS NOT NULL AND leadBDEId != '' AND STR_TO_DATE(leadCreationTimeStamp, '%d-%m-%Y') BETWEEN '$firstDayFormatted' AND '$lastDayFormatted'";

                    if (!empty($selectedbdeName) && strlen($selectedbdeName[0]) != 0) {
                        $sqlLead .= " AND leadBDEId IN ('" . implode("','", $selectedbdeName) . "')";
                    }

                    $sqlLead .= " GROUP BY planDate, leadBDEId ORDER BY CAST(leadId AS UNSIGNED) DESC";
                    $resultLead = $conn->query($sqlLead);
                    while ($row = $resultLead->fetch_assoc()) {
                        $date = date('d-m-Y', strtotime($row['planDate']));
                        $bdeId = $row['leadBDEId'];
                        $leadsData[$date][$bdeId] = $row['leadCount'];
                    }

                    //  GATHER ALL BDE IDs AND DATES
                    $allDates = array_unique(array_merge(array_keys($followupData), array_keys($leadsData)));
                    sort($allDates); 

                    $allBDEs = [];
                    foreach (array_merge_recursive($followupData, $leadsData) as $dayData) {
                        foreach (array_keys($dayData) as $bdeId) {
                            $allBDEs[$bdeId] = true;
                        }
                    }

                    //  BDE NAME 
                    $bdeIdList = array_keys($allBDEs);
                    $bdeNamesQuery = "SELECT userid, CONCAT(firstname, ' ', lastname) as bdeUserName 
                                      FROM logindetail 
                                      WHERE userid IN ('" . implode("','", $bdeIdList) . "')";
                    $resultNames = $conn->query($bdeNamesQuery);
                    while ($row = $resultNames->fetch_assoc()) {
                        $bdeNames[$row['userid']] = $row['bdeUserName'];
                    }

                    // MERGE DATASETS
                    $finalData = [];
                    foreach ($allDates as $date) {
                        $bdesOnThisDate = array_unique(array_merge(
                            isset($followupData[$date]) ? array_keys($followupData[$date]) : [],
                            isset($leadsData[$date]) ? array_keys($leadsData[$date]) : []
                        ));

                        foreach ($bdesOnThisDate as $bdeId) {
                            $attended = $followupData[$date][$bdeId]['attended'] ?? 0;
                            $unattended = $followupData[$date][$bdeId]['unattended'] ?? 0;
                            $leads = $leadsData[$date][$bdeId] ?? 0;
                            $bdeName = $bdeNames[$bdeId] ?? 'Unknown';

                            echo "
                                <tr class='tAC'>
                                    <td>$date</td>
                                    <td>" . htmlspecialchars($bdeName) . "</td>
                                    <td>$attended</td>
                                    <td>$unattended</td>
                                    <td>$leads</td>
                                </tr>
                            ";
                        }
                    }

                    if (empty($finalData) && empty($followupData) && empty($leadsData)) {
                        echo "<tr><td colspan='5' class='text-center'>No data available for selected filters.</td></tr>";
                    }
                }
                ?>
            </tbody>
        </table>
    </div>
</span>

<script>
    $(function() {
        $("#performanceTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 15,
            "aaSorting": []
        });
    });
</script>