<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">UPCOMING PAYMENTS</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="upcomingPaymentTable">
                                <thead>
                                    <tr>
                                        <th width='5%'>STUDENT ID</th>
                                        <th width='20%'>NAME</th>
                                        <th width='15%'>DUE DATE</th>
                                        <th width='15%'>PAYMENT TYPE</th>
                                        <th width='10%'>AMOUNT</th>
                                        <th width='15%'>STATUS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from studentfeestructure WHERE paymentStatus != 'APPROVED' AND amount != '0' ORDER BY STR_TO_DATE(installmentDate, '%d/%m/%Y');";
                                    $result = $conn->query($sql);
                                    $statusCss = '';
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $studentId = $row['studentId'];
                                            $studentName = $row['studentFirstName'] . ' ' . $row['studentLastName'];
                                            $paymentDate = $row['installmentDate'];
                                            $paymentType = '"' . $row['paymentType'] . '"';
                                            $amount = '"' . $row['amount'] . '"';
                                            $feeStructureRowId = '"' . $row['feeStructureRowId'] . '"';

                                            if ($row['paymentStatus'] == 'PENDING') $statusCss = 'badge badge-danger';
                                            if ($row['paymentStatus'] == 'ACCOUNTS APPROVAL PENDING') $statusCss = 'badge badge-warning';

                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $studentId . "> " . $studentId  . "</td>                                                       
                                                    <td>" . $studentName . "</td>                                                       
                                                    <td>" . $paymentDate . "</td>                                                       
                                                    <td>" . $row['paymentType'] . "</td>                                                                                                              
                                                    <td>" . $row['amount']  . "</td>                                                                                                             
                                                    <td><span class = '$statusCss'>" . $row['paymentStatus']  . "</span></td>                                                                                                             
                                                </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
    $(function() {
        $("#upcomingPaymentTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>

<?php require '../../common/footer.php'; ?>
