<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">MANAGE FEE STRUCTURE</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="manageFeeStructureTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>STUDENT ID</th>
                                        <th width='20%'>NAME</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='15%'>CURRENT YEAR</th>
                                        <th width='20%'>YEAR</th>
                                        <th width='20%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $yearCss = '';
                                    $studentCyear = '';
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT distinct studentId,studentFirstName,studentLastName,academicYear,currentYear,year,feeStructureId FROM studentfeestructure ORDER BY studentId desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $studentId = $row['studentId'];
                                            $studentFirstName = $row['studentFirstName'];
                                            $studentLastName = $row['studentLastName'];
                                            $studentName = $studentFirstName . ' ' . $studentLastName;
                                            $studentAcademicYear = $row['academicYear'];
                                            $studentCurrentYear = $row['currentYear'];
                                            $year = $row['year'];
                                            $sYear = '"' . $row['year'] . '"';
                                            $id = $row['feeStructureId'];

                                            $studentCyear = '"' . $studentCurrentYear . '"';
                                            $yearOfStudent = '"' . $year . '"';

                                            if ($year == 'FIRST YEAR') $yearCss = 'badge badge-warning';
                                            if ($year == 'SECOND YEAR') $yearCss = 'badge badge-primary';
                                            if ($year == 'THIRD YEAR') $yearCss = 'badge badge-success';

                                            echo "
                                                <tr  class='tAC'>
                                                    <td id = " . $studentId . "> " . $studentId  . "</td>                                                       
                                                    <td >" . $studentName . "</td>                                                       
                                                    <td >" . $studentAcademicYear . "</td>                                                       
                                                    <td >" . $studentCurrentYear . "</td>                                                                                                              
                                                    <td ><span class = '$yearCss'>" . $year  . "</span></td>
                                                    <td><a class='btn btn-primary btn-sm' onclick='viewFeeStructure(this.id,$studentCyear,$yearOfStudent)' title='click hear to view fee structure' id = " . $studentId . ">
                                                        <i class='fas fa-eye'></i>
                                                        </a>
                                                    </td>                                                                                                              
                                                </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageFeeStructure.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $(function() {
        $("#manageFeeStructureTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>

<?php require '../../common/footer.php'; ?>
