<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';
require '../../common/navbar.php';
?>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">BONUS HISTORY</h3>
                                </div>
                                </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Filter by Payment Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="paymentDateFilter" placeholder="FROM TO DATE" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#paymentDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="paymentHistoryTable">
                                <thead>
                                    <tr>
                                        <th>
                                            PAYMENT TYPE
                                        </th>
                                        <th>
                                            PAYMENT ID
                                        </th>
                                        <th>
                                            PAYMENT DATE
                                        </th>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT NAME
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                   
                                        <th>
                                            AMOUNT PAID
                                        </th>
                                        <th>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT DISTINCT p.paymentId, p.accountsId, p.paymentDate, p.amountPaid, p.assignmentId, p. paymentType, fa.assignmentId,fa.semester, fa.subjectName,p.companyBankName,p.companyAccountNo,p.transactionId,p.notes,
                                    fa.facultyName,p.tdsPercent,p.facultyBankName FROM f_assignment fa, f_payment p,f_bonus fb WHERE p.assignmentId = fa.assignmentId AND  fb.assignmentId = fa.assignmentId AND fb.flag='COMPLETED' ORDER BY p.paymentId DESC";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = $row['paymentId'];

                                            $date = explode(" ", $row['paymentDate']);
                                            $paymentDate = $date[0];

                                            $data = '"' . $row['paymentId'] . '::' . $row['accountsId'] . '::' . $row['facultyName'] . '::' . $row['assignmentId'] . '::' . $row['facultyBankName'] . '::' . $row['paymentDate'] . '::' . $row['companyBankName'] . '::' . $row['companyAccountNo'] . '::' . $row['transactionId'] . '::' . $row['amountPaid'] . '::' . $row['tdsPercent'] . '::' . $row['notes'] . '"';
                                            echo "
                                            <tr class='tAC'>
                                            <td>" . $row['paymentType'] . "</td>
                                                <td>" . $row["paymentId"] . "</td>
                                                <td>" . $paymentDate . "</td>
                                                <td>" . $row["assignmentId"] . "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row["subjectName"] . "</td> 
                                                <td>" . $row["facultyName"] . "</td>
                                                <td>" . $row['amountPaid'] . "</td>
                                                <td class='project-actions'>
                                                <a class='btn btn-primary btn-sm ' href='#' onclick='showDetails(this.id)' id = " . $id . " title='Click hear to view Payment Details'>
                                                    <i class='fas fa-eye'></i>
                                                </a>
                                               ";
                                            echo "</td>
                                                </td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="bonusHistory.js?v=<?php echo $fileVersion; ?>"></script>

<script>
     $('#paymentDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });
    $(function() {
        $("#paymentHistoryTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        $.fn.dataTableExt.afnFiltering.push(
            function(settings, data, dataIndex) {
                var tempDate = document.getElementById("paymentDateFilter").value.trim();
                inEmpStartingDateRange = true;
                if (tempDate.length > 0) {
                    tempDate = tempDate.split("-");
                    dateRangeStart = tempDate[0];
                    dateRangeEnd = tempDate[1];
                    var dateRangeStart = new Date(formatDate(dateRangeStart));
                    var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                    var empStartDate = new Date(formatDate(data[2]));
                    inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                        (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                            moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                } else inEmpStartingDateRange = true;

                

                return inEmpStartingDateRange ;
            }
        );
        $("#paymentDateFilter").val("");
        $("#paymentDateFilter").change(function() {
            var table = $('#paymentHistoryTable').DataTable();
            table.draw();
        });
    });
</script>

<?php require '../../common/footer.php'; ?>
