<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require '../../common/header.php';
require_once '../../common/connectToDB.php';

$masterSemester = [];
$sql = "SELECT * FROM semester";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterSemester, $row);
    }
}

$masterSubjectName = [];
$sql2 = "SELECT * FROM subjects;";
$result2 = $conn->query($sql2);
if ($result2->num_rows > 0) {
    while ($row2 = $result2->fetch_assoc()) {
        array_push($masterSubjectName, $row2);
    }
}
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING PAYMENT</h3>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Filter by Invoice Date</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control fS13" id="invoiceDateFilter" placeholder="FROM TO DATE" onclick="showIcon()" />
                                            <div class="input-group-append" data-target="#invoiceDateFilter" data-toggle="daterangepicker">
                                                <div class="input-group-text" id='iconBackground'> <i class="fa fa-calendar" id='dateIcon'> </i><i class="fas fa-times" id='clearDate' onclick="clearDate()" hidden></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Semester</label>
                                        <select class="form-control custom-select" id="semester" style="width: 100%;" onchange="filterOtherDropDown('semester');">
                                            <option disabled selected>SELECT SEMESTER</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Subject Name</label>
                                        <select class="form-control custom-select" id="subjectName" style="width: 100%;" onchange="filterOtherDropDown('subject');">
                                            <option selected>SELECT SUBJECT</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="allInvoiceTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            INVOICE DATE
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT
                                        </th>
                                        <th>
                                            UNIT NO
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            INVOICE STATUS
                                        </th>
                                        <th>
                                            INVOICE
                                        </th>
                                        <th>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT ac.accountsId,ac.invoiceRaisedTimestamp,ac.assignmentId,a.semester,a.subjectName,a.facultyId,a.facultyName,ac.unitNo,ac.totalAmount,ac.penaltyAmount,f.facultyId,f.invoiceType,ac.invoice,ac.invoiceStatus,ac.approvedExecutionMinutes,a.tableunitno FROM f_accounts as ac ,f_assignment as a,faculty as f where f.facultyId = a.facultyId AND a.assignmentId=ac.assignmentId AND a.tableunitno = ac.unitNo AND  ac.invoice != 'PENDING' AND ac.invoiceStatus !='PENDING AT AUDITOR' GROUP BY a.assignmentId,a.tableunitno ORDER BY ac.accountsId DESC";

                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $tempPendingAmount = '';
                                            $tempPenaltyAmount = '';
                                            $invoice = '';
                                            $facultyId = '';
                                            $invoiceCss = '';

                                            $tempPendingAmount = $row['totalAmount'];
                                            $tempPenaltyAmount = $row['penaltyAmount'];
                                            $invoice = $row['invoice'];
                                            $invoiceStatus = $row['invoiceStatus'];
                                            $facultyId = $row['facultyId'];
                                            $assignmentId = $row['assignmentId'];
                                            $accountsId = $row['accountsId'];
                                            $invoiceRaisedTimestamp = $row['invoiceRaisedTimestamp'];
                                            $invoiceRaisedTimestampArray = explode(":", $invoiceRaisedTimestamp);
                                            $invoiceRaisedDate = str_replace('-', '/', $invoiceRaisedTimestampArray[0]);
                                            $unitNo = '"' . $row['unitNo'] . '"';
                                            $finalAmount = (int)$tempPendingAmount - (int)$tempPenaltyAmount;

                                            if ($row['invoiceStatus'] == 'PENDING AT OWNER') $invoiceStatusCss = "badge badge-primary fS13";
                                            if ($row['invoiceStatus'] == 'PENDING AT AUDITOR') $invoiceStatusCss = "badge badge-warning fS13";
                                            if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') $invoiceStatusCss = "badge badge-light fS13";
                                            if ($row['invoiceStatus'] == 'COMPLETED') $invoiceStatusCss = "badge badge-success fS13";
                                            if ($row['invoiceStatus'] == 'ON HOLD AT OWNER') $invoiceStatusCss = "badge badge-info fS13";

                                            if ($row['invoiceStatus'] == 'COMPLETED') {
                                                $hidBtn = 'hidden';
                                            } else {
                                                $hidBtn = '';
                                            }
                                            if ($row['invoiceStatus'] == 'PENDING AT ACCOUNTS') {
                                                $disBtn = 'disabled';
                                            } else {
                                                $disBtn = '';
                                            }
                                            if ($row['invoice'] != 'PENDING') {
                                                $invoiceFile = $invoice;
                                                $invoice = "CREATED";
                                                $invoiceCss = "badge badge-success fS13";
                                            } else $invoiceCss = "badge badge-danger fS13";

                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $row['assignmentId'] . "</td>
                                                <td>" . $invoiceRaisedDate . "</td>
                                                <td>" . $row["semester"] . "</td>
                                                <td>" . $row["subjectName"] . "</td>
                                                <td>" . $row["unitNo"] . "</td>
                                                <td>" . $row["facultyName"] . "</td>
                                                <td><span class = '" . $invoiceStatusCss . "'>" . $invoiceStatus . "</span></td>";
                                            if ($invoice != "PENDING") {
                                                echo "<td>
                                                <a class='btn btn-primary btn-sm' target='_blank' id='' href='../../../dist/documents/facultyInvoices/$facultyId/$invoiceFile'>
                                                    <i class='fas fa-eye'></i>
                                                </a>     ";
                                            } else {
                                                echo "<td></tr>";
                                            }
                                            echo " <td>
                                                <a class='btn btn-info btn-sm' target='_blank' id='$accountsId' onclick=viewOwnerInvoiceStatus(this.id,$facultyId)>
                                                    <i class='far fa-eye'></i>
                                                </a>   
                                                </td>";
                                            echo "</tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="../../../plugins/daterangepicker/daterangepicker.js"></script>
<script src="allInvoices.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    var masterSemester = <?php echo json_encode($masterSemester); ?>;
    var masterSubjectName = <?php echo json_encode($masterSubjectName); ?>;
    $('#invoiceDateFilter').daterangepicker({
        autoApply: true,
        "alwaysShowCalendars": true,
        locale: {
            format: 'DD/MM/YYYY',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month')
                .endOf('month')
            ],
        },
    });

    $(function() {
        $("#allInvoiceTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });

        $.fn.dataTableExt.afnFiltering.push(
                function(settings, data, dataIndex) {
                    var tempDate = document.getElementById("invoiceDateFilter").value.trim();
                    inEmpStartingDateRange = true;
                    if (tempDate.length > 0) {
                        tempDate = tempDate.split("-");
                        dateRangeStart = tempDate[0];
                        dateRangeEnd = tempDate[1];
                        var dateRangeStart = new Date(formatDate(dateRangeStart));
                        var dateRangeEnd = new Date(formatDate(dateRangeEnd));
                        var empStartDate = new Date(formatDate(data[1]));
                        inEmpStartingDateRange = (dateRangeStart && dateRangeEnd) ?
                            (moment(empStartDate).isSameOrAfter(dateRangeStart) &&
                                moment(empStartDate).isSameOrBefore(dateRangeEnd)) : true;
                    } else inEmpStartingDateRange = true;

                    selectedSemesterName = getSelectValues('', document.getElementById("semester")).trim();
                    var rowSemesterName = data[2];
                

                    if (selectedSemesterName != 'SELECT SEMESTER') {
                        inSemesterName = (selectedSemesterName.indexOf(rowSemesterName) !== -1) ? rowSemesterName :
                            false;
                    } else inSemesterName = true;

                    selectedSubjectName = getSelectValues('', document.getElementById("subjectName")).trim();
                    var rowSubjectName = data[3];

                    if (selectedSubjectName != 'SELECT SUBJECT') {
                        inSubjectName = (selectedSubjectName.indexOf(rowSubjectName) !== -1) ? rowSubjectName :
                            false;
                    } else inSubjectName = true;

                    return inEmpStartingDateRange && inSemesterName && inSubjectName;
                
            }
        );
        $("#invoiceDateFilter").val("");
        $("#invoiceDateFilter").change(function() {
            var table = $('#allInvoiceTable').DataTable();
            table.draw();
        });

        loadDataDropdown("semester", masterSemester);
        loadDataDropdown("subjectName", masterSubjectName);
    });
</script>
<?php require '../../common/footer.php'; ?>