var facultyId = '',
    facultyFirstName = '',
    facultyMiddleName = '',
    facultyLastName = '',
    facultyEmailId = '',
    facultyLoginId = '',
    facultyPassword = '',
    facultyPrimaryNumber = '',
    facultyWhatsAppNumber = '',
    facultyAlternateNumber = '',
    facultyPanCard = '',
    facultyAddress = '',
    profilePhoto = '',
    profilePhotoInput = '',
    profilePhotoFlag = 'false',
    oldPassportPhoto = '',
    // enrollment details variables
    facultyType = '',
    dateOfCommencement = '',
    subjectOffered = '',
    chequeProof = '',
    chequeProofInput = '',
    chequeProofFlag = 'false',
    oldCheckProof = '',
    // bank details variables
    fracultyBankName = '',
    facultyAccountHolderName = '',
    facultyIFSCcode = '',
    facultyAccountType = '',
    facultyAccountNumber = '',
    facultyBranch = '',
    // documentation variables
    addressProofType = '',
    addressProofDocument = '',
    idProofDocument = '',
    resumeDocument = '',
    academicCerificationDocument = '',
    experienceCertificateDocument = '',
    addressProofInput = '',
    idProofInput = '',
    resumeInput = '',
    academicCerificationInput = '',
    experienceCertificateInput = '',
    addressProofFlag = 'false',
    idProofFlag = 'false',
    resumeFlag = 'false',
    academicCerificationFlag = 'false',
    experienceCertificateFlag = 'false',
    oldAddressProofDocument = '',
    oldIdProofPicture = '',
    oldFacultyResume = '',
    oldAccademicCertificate = '',
    oldPastExperienceCertificate = '',
    flagForDuplicate = false,
    blockReason = '',
    instituteOnboardinStatus = '',
    facultyStatus = '';

var oldFacultyOnboardingStatus = '',
    oldFacultyStatus = '',
    statement = '',
    flagForStatement = 0;

function loadOldValues() {
    oldFacultyOnboardingStatus = '';
    oldFacultyStatus = '';
    oldFacultyOnboardingStatus = document.getElementById('instituteOnboardingStatus').value.trim().toUpperCase();
    oldFacultyStatus = document.getElementById('facultyStatus').value.trim().toUpperCase();
}

function compareOldValuesWithNew() {
    statement = "Update done in faculty with faculty ID- (" + facultyId + ").<br>";
    var flagForStatement = 0;

    if (oldFacultyOnboardingStatus != instituteOnboardinStatus) {
        flagForStatement = 1;
        statement = statement + "Institute Onboarding status changed from " + oldFacultyOnboardingStatus + " to " + instituteOnboardinStatus + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function compareOldStatusWithNew() {
    statement = "Update done in faculty with faculty ID- (" + facultyId + "). <br>";
    var flagForStatement = 0;

    if (oldFacultyStatus != facultyStatus) {
        flagForStatement = 1;
        statement = statement + "Faculty status changed from " + oldFacultyStatus + " to " + facultyStatus + "<br>";
    }
    if (flagForStatement == 0) {
        showStatusError('', '#ff6666', 'No Changes Done');
        return 0;
    } else showStatusError('', '', '');
    return 1;
}

function selectDropdownValue(selectName, val) {
    var theSelect = document.getElementById(selectName);
    for (var j = 0; j < theSelect.options.length; j++) {
        var optVal = theSelect.options[j].text;
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function openReasonDiv() {
    facultyStatus = document.getElementById('facultyStatus').value.trim().toUpperCase();
    if (facultyStatus == "BLOCK") document.getElementById('reasonDiv').hidden = false;
    else document.getElementById('reasonDiv').hidden = true;
}

function setHeaders() {
    facultyId = '';
    facultyFirstName = '';
    facultyMiddleName = '';
    facultyLastName = '';
    facultyEmailId = '';
    facultyPassword = '';
    facultyPrimaryNumber = '';
    facultyWhatsAppNumber = '';
    facultyAlternateNumber = '';
    facultyPanCard = '';
    facultyAddress = '';
    // enrollment
    facultyType = '';
    dateOfCommencement = '';
    subjectOffered = '';
    // bank details
    fracultyBankName = '';
    facultyAccountHolderName = '';
    facultyIFSCcode = '';
    facultyAccountType = '';
    facultyAccountNumber = '';
    facultyBranch = '';

    facultyId = document.getElementById('facultyId').value.trim();
    facultyFirstName = document.getElementById('facultyFirstName').value.trim().toUpperCase();
    facultyMiddleName = document.getElementById('facultyMiddleName').value.trim().toUpperCase();
    facultyLastName = document.getElementById('facultyLastName').value.trim().toUpperCase();
    facultyEmailId = document.getElementById('facultyEmailId').value.trim();
    facultyPassword = document.getElementById('facultyPassword').value.trim();
    facultyPrimaryNumber = document.getElementById('facultyPrimaryNumber').value.trim();
    facultyWhatsAppNumber = document.getElementById('facultyWhatsAppNumber').value.trim();
    facultyAlternateNumber = document.getElementById('facultyAlternateNumber').value.trim();
    facultyPanCard = document.getElementById('facultyPanCard').value.trim().toUpperCase();
    facultyAddress = document.getElementById('facultyAddress').value.trim();

    facultyType = document.getElementById('facultyType').value.trim().toUpperCase();
    dateOfCommencement = document.getElementById('dateOfCommencement').value.trim();
    // dateOfCommencement = document.getElementById('dateOfCommencement').value();
    subjectOffered = document.getElementById('subjectOffered').value.trim().toUpperCase();

    fracultyBankName = document.getElementById('facultyBankName').value.trim().toUpperCase();
    facultyAccountHolderName = document.getElementById('facultyAccountHolderName').value.trim().toUpperCase();
    facultyIFSCcode = document.getElementById('ifscCode').value.trim().toUpperCase();
    facultyAccountType = document.getElementById('facultyAccountType').value.trim().toUpperCase();
    facultyAccountNumber = document.getElementById('facultyAccountNo').value.trim().toUpperCase();
    facultyBranch = document.getElementById('facultyBankBranch').value.trim().toUpperCase();
}

function part1Validation() {
    if (facultyFirstName == '') return 0;
    if (facultyLastName == '') return 0;
    if (facultyPassword == '') return 0;
    if (facultyPrimaryNumber == '') return 0;
    if (facultyPrimaryNumber.length != 10) return 0;
    if (facultyWhatsAppNumber == '') return 0;
    if (facultyWhatsAppNumber.length != 10) return 0;
    if (facultyPanCard == '') return 0;
    if (facultyAddress == '') return 0;
    return 1;
}

function part2Validation() {
    if (facultyType == '') return 0;
    if (dateOfCommencement == '') return 0;
    if (subjectOffered == '') return 0;
    return 1;
}

function part3Validation() {
    if (fracultyBankName == '') return 0;
    if (facultyAccountHolderName == '') return 0;
    if (facultyIFSCcode == '') return 0;
    if (facultyAccountType.toUpperCase() == '') return 0;
    if (facultyAccountNumber == '') return 0;
    if (facultyBranch == '') return 0;
    return 1;
}

function part4Validation() {
    if (tempAddress == '') return 0;
    if (tempIdProof == '') return 0;
    if (tempFRe == '') return 0;
}

function approveFacultyValidation() {
    if (setHeaders() == 0) return 0;
    if (part1Validation() == 0) {
        showError('', '#ff6666', "All required fields in Personal Information section should be filled.");
        return 0;
    }
    if (part2Validation() == 0) {
        showError('', '#ff6666', "All required fields in Assignment Details section should be filled.");
        return 0;
    }
    if (part3Validation() == 0) {
        showError('', '#ff6666', "All required fields in Bank Details section should be filled.");
        return 0;
    }
    if (part4Validation() == 0) {
        showError('', '#ff6666', "All required documents should be uploaded.");
        return 0;
    }
    if (tempAgreementAcceptance == '') {
        showError('', '#ff6666', "Faculty has not accepted agreement yet.");
        return 0;
    }
    return 1;
}

function updateOnboardingStatus(userName) {
    var saveFlag = 'updateOnboardingStatus';
    document.getElementById('updateStatus').disabled = true;
    instituteOnboardinStatus = '';
    instituteOnboardinStatus = document.getElementById('instituteOnboardingStatus').value.trim().toUpperCase();
    facultyId = document.getElementById('facultyId').value.trim();
    if (instituteOnboardinStatus == 'INSTITUTE ONBOARDING STATUS') {
        showError('', '#ff6666', "Please Select Status.");
        document.getElementById('updateStatus').disabled = false;
        return 0;
    } else showError('', '', '');
    if (instituteOnboardinStatus == 'APPROVED') {
        if (approveFacultyValidation() == 0) {
            document.getElementById('updateStatus').disabled = false;
            return;
        }
    }
    if (compareOldValuesWithNew() == 0) {
        document.getElementById('updateStatus').disabled = false;
        return;
    }
    if (confirm('Are you sure you want to update status')) {
        $.post('updateFacultyStatus.php', {
            'saveFlag': saveFlag,
            'facultyId': facultyId,
            'instituteOnboardinStatus': instituteOnboardinStatus,
            'userName': userName,
            'logStatement': statement,
        }, function (data) {
            document.getElementById('successMessage').innerHTML = 'updated. Please wait. The page will get auto-refresh...';
            document.getElementById("updateStatus").disabled = false;
            location.reload();
        });
    }
    else document.getElementById('updateStatus').disabled = false;
}

function showStatusError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('statusErrorMessage').innerHTML = message;
}

function reasonValidation() {
    blockReason = document.getElementById('blockReason').value;
    if (blockReason == '') {
        showStatusError('blockReason', '#ff6666', 'ADD REASON');
        document.getElementById("updateButton").disabled = false;
        return 0;
    } else {
        showStatusError('blockReason', '', '');
        document.getElementById("updateButton").disabled = true;
    }
}

function updateFacultyStatus() {
    var saveFlag = 'updateFacultyStatus';
    facultyId = '';
    facultyId = document.getElementById('facultyId').value;
    facultyStatus = document.getElementById('facultyStatus').value.trim().toUpperCase();
    if (facultyStatus == "BLOCK") {
        if (reasonValidation() == 0) return 0;
    }

    if (compareOldStatusWithNew() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }
    document.getElementById("updateButton").disabled = true;
    document.getElementById('statusSuccessMessage').innerHTML = 'Updating Please Wait...';
    $.post('updateFacultyStatus.php', {
        'saveFlag': saveFlag,
        'facultyId': facultyId,
        'facultyStatus': facultyStatus,
        'blockReason': blockReason,
        'facultyDetails': facultyDetails,
        'logStatement': statement
    }, function (data) {
        document.getElementById('statusSuccessMessage').innerHTML = 'Updated successfully';
        document.getElementById("updateButton").disabled = true;
        location.reload();
    });
}