var facultyFirstName = '',
    facultyLastName = '',
    facultyLoginId = '',
    facultyPassword = '',
    facultyId='',
    firstName = '';

function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function checkForDuplicate(userEmail) {
    flagForDuplicate = false;
    for (i = 0; i < masterFacultyList.length; i++) {
        if (userEmail.trim().toLowerCase() == masterFacultyList[i].emailId.trim().toLowerCase()) flagForDuplicate = true;
    }
}

function facultyValidation() {
    facultyFirstName = '';
    facultyLastName = '';
    facultyLoginId = '';
    facultyPassword = '';
    facultyType ='';

    facultyFirstName = document.getElementById('facultyFirstName').value.trim().toUpperCase();
    facultyLastName = document.getElementById('facultyLastName').value.trim().toUpperCase();
    facultyLoginId = document.getElementById('facultyLoginId').value.trim();
    facultyPassword = document.getElementById('facultyPassword').value.trim();
    subjectOffered = getSelectValues('text', document.getElementById("subjectOffered")).slice(0, -1);
    subjectId = getSelectValues('value', document.getElementById("subjectOffered")).slice(0, -1);
    facultyType = getSelectValues('value', document.getElementById("facultyType")).slice(0, -1);

    

    if (facultyFirstName == '') {
        showError('facultyFirstName', '#ff6666', "First name cannot be blank.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyFirstName', '', '');

    if (facultyLastName == '') {
        showError('facultyLastName', '#ff6666', "Last name cannot be blank.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyLastName', '', '');

    if (facultyLoginId == '') {
        showError('facultyLoginId', '#ff6666', "Login Id cannot be blank.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyLoginId', '', '');

    if (!validateEmail(facultyLoginId)) {
        document.getElementById("facultyLoginId").style.backgroundColor = "#ffc2b3";
        showError('facultyLoginId', '', "Login Id is not in correct format.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else {
        document.getElementById("facultyLoginId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }
    checkForDuplicate(facultyLoginId);
    if (flagForDuplicate) {
        document.getElementById("saveButton").disabled = false;
        showError('facultyLoginId', '#ff6666', "Duplicate Login Id found. Please change it.");
        document.getElementById("saveButton").disabled = false;
        return 0;
    } else showError('facultyLoginId', '', '');

    console.log(subjectOffered);
    if (subjectOffered.toUpperCase() == '') {
        showError('subjectOffered', '#ff6666', "Please select valid Subject.");
        return 0;
    } else showError('subjectOffered', '', '');

    console.log(facultyType);
    if (facultyType.toUpperCase() == 'SELECT FACULTY TYPE') {
        showError('facultyType', '#ff6666', "Please select valid Faculty Type.");
        return 0;
    }

   else if (facultyType.toUpperCase() == '') {
        showError('facultyType', '#ff6666', "Please select valid Faculty Type.");
        return 0;
    } else showError('facultyType', '', '');

    return 1;
}



function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == 'text') {
            if (opt.selected) result += opt.text + "|";
        }
        if (flag == 'value') {
            if (opt.selected) result += opt.value + "|";
        }
    }
    return result.trim();
}

function addFaculty() {
    // document.getElementById("saveButton").disabled = true;
    if (facultyValidation() == 0) return;
    var saveFlag = 'saveFaculty';
    if (confirm("Are you sure you want to add faculty?")) {
        document.getElementById("saveButton").disabled = true;
        document.getElementById('successMessage').innerHTML = 'Adding Faculty Please Wait...';
        $.post('saveFaculty.php', {
            'saveFlag': saveFlag,
            'facultyFirstName': facultyFirstName,
            'facultyLastName': facultyLastName,
            'facultyLoginId': facultyLoginId,
            'facultyPassword': facultyPassword,
            'subjectOffered': subjectOffered,
            'facultyType':facultyType,
            'subjectId':subjectId
        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = 'Faculty added successfully. Please wait. The page will get auto-refresh...';
            document.getElementById("saveButton").disabled = false;
            // location.reload();
        });
    }
    else document.getElementById("saveButton").disabled = false;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
         if (selectName.includes("facultyCenter")) {
            if (i == 0) {
                options.value = options.text = "SELECT CENTER NAME";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].centerId;
            options.text = results[i].centerCode + " - " + results[i].centerLocation.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectOffered")) {
            // if (i == 0) {
            //     options.value = options.text = "SELECT SUBJECT NAME";
            //     theSelect.add(options);
            //     options.selected = true;
            //     options.disabled = true;
            //     options = document.createElement("option");
            // }
            options.value = results[i].subjectId.toUpperCase();
            options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } 
    }
    return;
}

function filterOtherDropDown(flag) {

    var table = $('#usersTable').DataTable();
    table.draw();
}

function getSelectValues1(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function showDetails(id, flag) {
    encodedValue_id = btoa(id);
    encodedKey_facultyId = btoa('facultyId');
    encodedValue_flag = btoa(flag);
    window.location.href = 'viewFacultyDetails.php?' + encodedKey_facultyId + "=" + encodedValue_id + "&flag=" + encodedValue_flag;
}

function userEdit(id) {
    encodedValue_id = btoa(id);
    encodedKey_facultyId = btoa('facultyId');
    window.location.href = 'editFacultyDetails.php?' + encodedKey_facultyId + "=" + encodedValue_id ;
}






// facultyId, firstName, middleName, lastName, emailId, pass, primeryNo, whatsAppNo, alternateNo, facultyPanCard, facultyAddress, invoiceType, companyName, gstNo, state, stateCode, hsnCode, facultyType, commencementDate, subjectId, center, facultySubject, bankName, accountHolderName, ifscCode, accountType, accountNo, branch, cancelledCheque, documentType, addressProof, idProof, facultyResumeDoc, facultyPhoto, academicCertificate, experienceCertificate, formDAT, formStatus, academicApproval, centerManagerApproval, acdemicApprovalTimestamp, centerManagerApprovalTimestamp, academicNotes, centerManagerNote, facultyStatus, facultyStatusUpdatedDate, reasonForBlock, terminationDate, lastLoginTime, facultyCreationTime, otpCreationTime, otpSubmissionTime, averageRating

// facultyId, firstName, middleName, lastName, emailId, pass, primeryNo, whatsAppNo, alternateNo, facultyPanCard, facultyAddress, invoiceType, companyName, gstNo, state, stateCode, hsnCode, facultyType, commencementDate, subjectId, facultySubject, bankName, accountHolderName, ifscCode, accountType, accountNo, branch, cancelledCheque, documentType, addressProof, idProof, facultyResumeDoc, facultyPhoto, academicCertificate, experienceCertificate, formDAT, formStatus, academicApproval, centerManagerApproval, acdemicApprovalTimestamp, centerManagerApprovalTimestamp, academicNotes, centerManagerNote, facultyStatus, facultyStatusUpdatedDate, reasonForBlock, terminationDate, lastLoginTime, facultyCreationTime, otpCreationTime, otpSubmissionTime, averageRating