<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>


<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">PENDING BONUS</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingBonusTable">
                                <thead>
                                    <tr>
                                        <th>
                                            ASSIGNMENT ID
                                        </th>
                                        <th>
                                            SEMESTER
                                        </th>
                                        <th>
                                            SUBJECT
                                        </th>
                                        <th>
                                            FACULTY NAME
                                        </th>
                                        <th>
                                            AVERAGE REVIEW
                                        </th>
                                        <th>
                                            STATUS
                                        </th>
                                        <th>
                                            ACTIONS
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';

                                    $sql = "SELECT b.bonusId,b.assignmentId,b.bonusValue,b.facultyId,b.facultyName,b.flag,a.semester,a.subjectName,r.assignmentId,b.invoiceStatus,(SELECT (CAST(sum(r.noOfRatings)/count(r.noOfRatings) AS DECIMAL (10 , 2 )))) as reviewNumber FROM f_bonus AS b,f_assignment AS a,review AS r WHERE a.assignmentId = b.assignmentId AND b.assignmentId = r.assignmentId GROUP BY b.assignmentId;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $id = '';
                                            $id = $row['bonusId'];
                                            $statusCss = '';
                                            $assignmentId = $row['assignmentId'];
                                            // if ($row['flag'] == 'PENDING') $statusCss = 'badge badge-danger';
                                            // if ($row['flag'] == 'COMPLETED') $statusCss = 'badge badge-success';
                                            $disableButton = 'disabled';
                                            if ($row['bonusValue'] == '0') {
                                                $statusCss = 'badge badge-danger';
                                                $disableButton = '';
                                                $text =  'PENDING';
                                            }
                                            if ($row['bonusValue'] != '' && $row['invoiceStatus'] != ''){
                                                $statusCss = 'badge badge-success';
                                                $disableButton = 'disabled';
                                                $text =  'COMPLETED';

                                            } 
                                        
                                            echo "
                                            <tr  class='tAC'>
                                                <td>" . $row['assignmentId'] . "</td>
                                                <td>" . $row['semester'] . "</td>
                                                <td>" . $row['subjectName'] . "</td>
                                                <td>" . $row['facultyName'] . "</td>
                                                <td>" . $row['reviewNumber'] . "</td>
                                                <td><span class = '" . $statusCss . "'>" .  $text . "</span></td>
                                                <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm fS18 $disableButton' href='#' id = " . $id . " title='Click hear to add payment' onclick='addPayment(this.id,$assignmentId)'>
                                                    <i class='fas fa-edit fS15'></i>
                                                    </a>
                                                </td>
                                            </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/moment/moment.min.js"></script>
<script src="../../../plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script>
    function addPayment(bonusId, assignmentId) {
        encodedValue_bonusId = btoa(bonusId);
        encodedValue_assignmentId = btoa(assignmentId);
        window.location.href = "addPayment.php?bId=" + encodedValue_bonusId + "&aId=" + encodedValue_assignmentId;
    }
    $(function() {
        $("#pendingBonusTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>