var reviewDate = '',
commentsOfLecture = '',
penaltyAmount = '',
    approvedExecutionTime = '',
    noOfRating = 0,
    contentArray = [];

var assignmentId = '',
    reviewId = '',
    facultyName = '',
    payableAmount = '',
    statement = '',
    flagForStatement = 0;

const oldData = {
    unitNo: "",
    assignmentNo: "",
    approvedExecutionTime: "",
    penaltyAmount: "",
    reviewDate: "",
    oldRating: "",
    reviewNote: ""
}

function loadOldValues() {
    oldData.assignmentNo = document.getElementById('asssignmentId').value.trim();
    oldData.unitNo = document.getElementById('unitNo').value.trim();
    oldData.approvedExecutionTime = document.getElementById('approvedExecutionTime').value.trim();
    oldData.penaltyAmount = document.getElementById("penaltyAmount").value.trim();
    oldData.reviewDate = $("#reviewDateAndTime").find("input").val();
    oldData.oldRating = assignmentRating;
    oldData.reviewNote = document.getElementById("commentText1").value.trim();
}

function compareOldValuesWithOld() {
    statement = "UPDATE done in assignment review of " + oldData.unitNo + " of assignment with assignment ID- (" + oldData.assignmentNo + ")." + "<br>";
    var flagForStatement = 0;

    if (oldData.approvedExecutionTime != approvedExecutionTime) {
        flagForStatement = 1;
        statement = statement + "Approved execution time changed from " + oldData.approvedExecutionTime + " min to " + approvedExecutionTime + " min<br>";
    }
    if (oldData.penaltyAmount != penaltyAmount) {
        flagForStatement = 1;
        statement = statement + "Penalty amount changed from " + oldData.penaltyAmount + " to " + penaltyAmount + "<br>";
    }
    if (oldData.reviewDate != reviewDate) {
        flagForStatement = 1;
        statement = statement + "Review date changed from " + oldData.reviewDate + " to " + reviewDate + "<br>";
    }
    if (oldData.oldRating != noOfRating) {
        flagForStatement = 1;
        statement = statement + "Rating changed from " + oldData.oldRating + " to " + noOfRating + "<br>";
    }
    if (oldData.reviewNote != commentsOfLecture) {
        flagForStatement = 1;
        statement = statement + "Review note changed from " + oldData.reviewNote + " to " + commentsOfLecture + "<br>";
    }
    // if (flagForStatement == 0) {
    //     showError('', '#ff6666', 'No Changes Done');
    //     return 0;
    // }
    return 1;
}

function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";

    options.disabled = false;
    options.selected = false;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}

function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    if (selectName == "semester") dummyOptions(theSelect, options, "SEMESTER");
    if (selectName == "subjectName") dummyOptions(theSelect, options, "SUBJECT");
    if (selectName == "assignmentIdDrpodown") dummyOptions(theSelect, options, "ASSIGNMENT ID");
    if (selectName == "facultyNameDropdown") dummyOptions(theSelect, options, "FACULTY NAME");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("semester")) {
            options.value = options.text = results[i].semesterValue.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("subjectName")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("assignmentIdDrpodown")) {
            options.value = options.text = results[i].assignmentId.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("facultyNameDropdown")) {
            facultyName = results[i].firstName + ' ' + results[i].lastName;
            options.value = options.text = facultyName.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}

function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
    }
    return result.trim();
}

function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function amountToPay(approvedMins) {
    approvedMins = document.getElementById('approvedExecutionTime').value.trim();
    var tempLumpsumAmountPerMinute = parseFloat(remunerationData[0]['totalamount']) / parseInt(remunerationData[0]['totalMins']);
    console.log(tempLumpsumAmountPerMinute);
    document.getElementById('amountToPay').value = Math.round(parseFloat(tempLumpsumAmountPerMinute) * parseInt(approvedMins));
}

function filterOtherDropDown(flag) {
    tempSemester = getSelectValues('', document.getElementById("semester")).trim();
    tempSubject = getSelectValues('', document.getElementById("subjectName")).trim();
    tempSubjectName = [];
    tempFacultyName = [];
    tempAssignmentId = [];
    newAssignmentIdArray = [];
    if (flag == "semester") {
        loadDataDropdown("subjectName", []);
        loadDataDropdown("assignmentIdDrpodown", []);
        loadDataDropdown("facultyNameDropdown", []);
        for (let i = 0; i < masterSubjectName.length; i++) {
            if (masterSubjectName[i].semester == tempSemester) {
                tempSubjectName.push(obj = {
                    "subjectId": masterSubjectName[i].subjectId.trim(),
                    "subjectName": masterSubjectName[i].subjectName.trim()
                });
            }
            loadDataDropdown("subjectName", tempSubjectName);
        }
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester) {
                tempAssignmentId.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", tempAssignmentId);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "subject") {
        for (let i = 0; i < masterAssignmentData.length; i++) {
            if (masterAssignmentData[i].semester == tempSemester && masterAssignmentData[i].subjectName == tempSubject) {
                newAssignmentIdArray.push(obj = {
                    "assignmentId": masterAssignmentData[i].assignmentId.trim()
                });
            }
            loadDataDropdown("assignmentIdDrpodown", newAssignmentIdArray);
        }
        for (let i = 0; i < masterFacultyName.length; i++) {
            tempSubjectList = masterFacultyName[i].facultySubject.split("|");
            for (j = 0; j < tempSubjectList.length; j++) {
                if (tempSubjectList[j] == tempSubject) {
                    tempFacultyName.push(obj = {
                        "firstName": masterFacultyName[i].firstName.trim().toUpperCase(),
                        "lastName": masterFacultyName[i].lastName.trim().toUpperCase()
                    });
                }
            }
            loadDataDropdown("facultyNameDropdown", tempFacultyName);
        }
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == "assignment") {
        var table = $('#example1').DataTable();
        table.draw();
    } else if (flag == 'faculty') {
        var table = $('#example1').DataTable();
        table.draw();
    }
}

function resetReview() {
    noOfRating = 0;
    for (let i = 0; i < 10; i++) {
        document.getElementById("rating" + (i + 1)).className = "btn btn-scale btn-scale-desc-" + (i + 1);
    }
}

function countRating(elementId) {
    var temp = elementId.split("rating");
    resetReview();
    noOfRating = 0;
    noOfRating = temp[1];
    document.getElementById(elementId).className = "btn btn-scale btn-scale-desc-" + temp[1] + " btn-border";
}

function addReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');
    window.location.href = "addReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}

function viewAssignmentReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');
    window.location.href = "viewReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}

function editAssignmentReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');
    window.location.href = "editReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}
function addAssignmentReview(assignmentId, reviewId, unitNo, noOfLectures, noOfPenaltyFlag) {
    encodedValue_assignmentId = btoa(assignmentId);
    encodedValue_reviewId = btoa(reviewId);
    encodedValue_unitNo = btoa(unitNo);
    encodedValue_noOfLectures = btoa(noOfLectures);
    encodedValue_noOfPenaltyFlag = btoa(noOfPenaltyFlag);

    encodedKey_aId = btoa('aId');
    encodedKey_rId = btoa('rId');
    encodedKey_uNo = btoa('uNo');
    encodedKey_nOL = btoa('nOL');
    window.location.href = "addReview.php?" + encodedKey_aId + "=" + encodedValue_assignmentId + "&" + encodedKey_rId + "=" + encodedValue_reviewId + "&" + encodedKey_uNo + "=" + encodedValue_unitNo + "&" + encodedKey_nOL + "=" + encodedValue_noOfLectures + "&nOpf=" + encodedValue_noOfPenaltyFlag;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}

function setHeaders() {
    reviewDate = '';
   
    penaltyAmount = '';
    approvedExecutionTime = '';
    payableAmount = '';

    reviewDate = $("#reviewDateAndTime").find("input").val();
    commentsOfLecture = document.getElementById("commentText1").value,

    commentsOfLecture = escapeSpecialCharacters(commentsOfLecture);
    commentsOfLecture = commentsOfLecture.replace("\n", " ");
    penaltyAmount = document.getElementById("penaltyAmount").value;
    approvedExecutionTime = document.getElementById("approvedExecutionTime").value.trim();

    assignmentId = document.getElementById('asssignmentId').value.trim();
    reviewId = document.getElementById('reviewId').value.trim();
    unitNo = document.getElementById('unitNo').value.trim();
    facultyName = document.getElementById('facultyName').value.trim();
    payableAmount = document.getElementById('amountToPay').value.trim();
    return 1;
}

function formValidation() {
    if (setHeaders() == 0) return 0;

    if (approvedExecutionTime == '') {
        showError('approvedExecutionTime', '#ff6666', "Please enter approved execution time.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    if (approvedExecutionTime < 0) {
        showError('approvedExecutionTime', '#ff6666', "Time can not be negative.");
        return 0;
    } else showError('approvedExecutionTime', '', '');

    // if (approvedExecutionTime == 0) {
    //     showError('approvedExecutionTime', '#ff6666', "Approved Time can not be zero.");
    //     return 0;
    // } else showError('approvedExecutionTime', '', '');

    if (reviewDate == '') {
        showError('reviewDateAndTime', '#ff6666', "Review Date cannot be Blank.");
        return 0;
    } else showError('reviewDateAndTime', '', '');

    if (noOfRating == 0) {
        showError('', '#ff6666', "Please Select Rating of Unit.");
        return 0;
    } else showError('', '', '');

    if (penaltyAmount < 0) {
        showError('', '#ff6666', "Penalty Amount Cannot be negative.");
        return 0;
    } else showError('', '', '');

    if (penaltyAmount == '') {
        penaltyAmount = '0';
    }

    if (makeArray() == 0) return 0;
    return 1;
}

function makeArray() {
    contentArray = [];
    var obj = {
        'assignmentId': assignmentId,
        'reviewId': reviewId,
        'unitNo': unitNo,
        "facultyId": facultyId,
        'facultyName': facultyName,
        'reviewDate': reviewDate,
        'noOfRating': noOfRating,
        'comments': commentsOfLecture,
        'penaltyAmount': penaltyAmount,
        'approvedExecutionTime': approvedExecutionTime,
        'payableAmount':payableAmount
    }
    contentArray.push(obj);
}

function saveReview(id) {
    document.getElementById('saveReview').disabled = true;
    // document.getElementById('saveAndPublishReview').disabled = true;
    var saveFlag = "SAVEFLAG";
    if (id == 'saveReview') reviewStatus = 'UNDER REVIEW';
    else reviewStatus = 'COMPLETED';
    if (formValidation() == 0) {
        document.getElementById('saveReview').disabled = false;
        // document.getElementById('saveAndPublishReview').disabled = false;
        return;
    }
    else {
        if (confirm("Are you sure you want to save Unit Review??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Lecture Review. Please wait...';
            document.getElementById('saveReview').disabled = true;
            console.log(contentArray);
            console.log(commentsOfLecture)
            console.log(document.getElementById("commentText1"));
            // document.getElementById('saveAndPublishReview').disabled = true;
            $.post('saveAssignmentReview.php', {
                'saveFlag': saveFlag,
                'reviewStatus': reviewStatus,
                'contentArray': contentArray,
            }, function (data) {
                console.log(data);
                document.getElementById('successMessage').innerHTML = 'Lecture Review Saved Successfully...';
            });
        }
        else {
            document.getElementById('saveReview').disabled = false;
            // document.getElementById('saveAndPublishReview').disabled = false;
        }
    }
}

function updateReview(id) {
    // document.getElementById('saveReview').disabled = true;
    document.getElementById('saveAndPublishReview').disabled = true;
    var saveFlag = "editReview";
    if (id == 'saveReview') reviewStatus = 'UNDER REVIEW';
    else reviewStatus = 'COMPLETED';
    if (formValidation() == 0) {
        // document.getElementById('saveReview').disabled = false;
        document.getElementById('saveAndPublishReview').disabled = false;
        return;
    }
    if (compareOldValuesWithOld() == 0) {
        document.getElementById('saveAndPublishReview').disabled = false;
        return;
    }
    else {
        if (confirm("Are you sure you want to save Unit Review??? ")) {
            document.getElementById('successMessage').innerHTML = 'Saving Lecture Review. Please wait...';
            // document.getElementById('saveReview').disabled = true;
            document.getElementById('saveAndPublishReview').disabled = true;
            $.post('saveAssignmentReview.php', {
                'saveFlag': saveFlag,
                'reviewStatus': reviewStatus,
                'contentArray': contentArray,
                'payableAmount': payableAmount,
                'typeOfPayment': remunerationData[0]['typeofpayment'],
                'logStatement': statement
            }, function (data) {
                document.getElementById('successMessage').innerHTML = 'Lecture Review Saved Successfully...';
                if (data == 'ADD') alert("Review can't be updated.");
            });
        }
        else {
            // document.getElementById('saveReview').disabled = false;
            document.getElementById('saveAndPublishReview').disabled = false;
        }
    }
}