function loadDataDropdown(flag, selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("bankName")) {
            if (i == 0) {
                options.value = options.text = "SELECT BANK NAME";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            if (results[i].utilityType == "bankName") {
                options.value = results[i].utilityValue.toUpperCase();
                options.text = results[i].utilityValue.toUpperCase();
                theSelect.add(options);
            }
        }
    }
    return;
}

function selectDropdownValue(selectName, val) {
    let theSelect = document.getElementById(selectName);
    for (let j = 0; j < theSelect.options.length; j++) {
        let optVal = theSelect.options[j].value.trim();
        if (optVal == val.trim()) {
            theSelect.options[j].selected = true;
        }
    }
    return;
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function addTableRow() {

    if (checkTableContentIsNotEmpty() == 0) return;
    var mytable = document.getElementById("utilityTableBody"),
        newRow,
        newCell;

    var currentIndex = mytable.rows.length;
    var newRow = document.createElement("tr");
    mytable.appendChild(newRow);

    newCell = document.createElement("td");
    newCell.id = "rowId" + (currentIndex + 1);
    newCell.setAttribute("class", "fS23");
    newCell.textContent = (currentIndex + 1);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var select = document.createElement("select");
    select.setAttribute("class", "form-control custom-select");
    select.setAttribute("type", "text");
    select.setAttribute("id", "bankName" + (currentIndex + 1));
    newCell.appendChild(select);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var bankAccountNo = document.createElement("input");
    bankAccountNo.setAttribute("class", "form-control tAC");
    bankAccountNo.setAttribute("id", "bankAccountNo" + (currentIndex + 1));
    bankAccountNo.setAttribute("type", "number");
    bankAccountNo.setAttribute("placeholder", "Enter bank Account No");
    newCell.appendChild(bankAccountNo);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var bankBranchNo = document.createElement("input");
    bankBranchNo.setAttribute("class", "form-control tAC");
    bankBranchNo.setAttribute("id", "bankBranchNo" + (currentIndex + 1));
    bankBranchNo.setAttribute("type", "text");
    bankBranchNo.setAttribute("placeholder", "Enter bank Branch Name");
    newCell.appendChild(bankBranchNo);
    newRow.appendChild(newCell);

    newCell = document.createElement("td");
    var bankIfscCode = document.createElement("input");
    bankIfscCode.setAttribute("class", "form-control tAC");
    bankIfscCode.setAttribute("id", "bankIfscCode" + (currentIndex + 1));
    bankIfscCode.setAttribute("type", "text");
    bankIfscCode.setAttribute("placeholder", "Enter bank IFSC CODE");
    newCell.appendChild(bankIfscCode);
    newRow.appendChild(newCell);

    // newCell = document.createElement("td");
    // var openingbalance = document.createElement("input");
    // openingbalance.setAttribute("class", "form-control tAC");
    // openingbalance.setAttribute("id", "openingbalance" + (currentIndex + 1));
    // openingbalance.setAttribute("type", "text");
    // openingbalance.setAttribute("placeholder", "Enter Opening Balance");
    // newCell.appendChild(openingbalance);
    // newRow.appendChild(newCell);


    newCell = document.createElement("td");
    var deleteButton = document.createElement("input");
    deleteButton.setAttribute("type", "button");
    deleteButton.setAttribute("id", "deleteButton" + (currentIndex + 1));
    deleteButton.setAttribute("class", "imageButton deleteButton form-control");
    deleteButton.setAttribute("title", "Delet Current Row");
    deleteButton.setAttribute("onclick", "deleteRow(this)");
    newCell.appendChild(deleteButton);
    newRow.appendChild(newCell);

    loadDataDropdown('', "bankName" + (currentIndex + 1), masterUtility);
}

function checkTableContentIsNotEmpty() {
    resetTableErrors();
    const table = document.getElementById("utilityTableBody");

    for (var r = 0, n = table.rows.length; r < n; r++) {
        if (table.rows[r].cells[1].getElementsByTagName("select")[0].selectedIndex == '0') {
            table.rows[r].cells[1].getElementsByTagName("select")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Select Valid Bank Name from the List.");
            return 0;
        } else table.rows[r].cells[1].getElementsByTagName("select")[0].style.backgroundColor = "";

        if (table.rows[r].cells[2].getElementsByTagName("input")[0].value == '') {
            table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Bank Account No cannot be Blank.");
            return 0;
        } else table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[3].getElementsByTagName("input")[0].value == '') {
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Bank Branch Name cannot be Blank.");
            return 0;
        } else
            table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";

        if (table.rows[r].cells[4].getElementsByTagName("input")[0].value == '') {
            table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "#ff6666";
            showError('', '#ff6666', "Bank IFSC Code cannot be Blank.");
            return 0;
        } else
            table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
    showError('', '', '');

    return 1;
}

function resetTableErrors() {
    const table = document.getElementById("utilityTableBody");
    for (var r = 0, n = table.rows.length; r < n; r++) {
        table.rows[r].cells[1].getElementsByTagName("select")[0].style.backgroundColor = "";
        table.rows[r].cells[2].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[3].getElementsByTagName("input")[0].style.backgroundColor = "";
        table.rows[r].cells[4].getElementsByTagName("input")[0].style.backgroundColor = "";
    }
}

function deleteRow(rows) {
    var tempRowId = (rows.id).split("deleteButton");
    document.getElementById("utilityTableBody").deleteRow(tempRowId[1] - 1);
    var table = document.getElementById("utilityTableBody");
    for (let i = 0; i < table.rows.length; i++) {
        table.rows[i].cells[0].innerText = (i + 1);
        table.rows[i].cells[1].getElementsByTagName("select")[0].id = 'bankName' + (i + 1);
        table.rows[i].cells[2].getElementsByTagName("input")[0].id = 'bankAccountNo' + (i + 1);
        table.rows[i].cells[3].getElementsByTagName("input")[0].id = 'bankBranchNo' + (i + 1);
        table.rows[i].cells[4].getElementsByTagName("input")[0].id = 'bankIfscCode' + (i + 1);
        // table.rows[i].cells[4].getElementsByTagName("input")[0].id = 'openingbalance' + (i + 1);
    }
}

function tableValidation() {
    const table = document.getElementById("utilityTableBody");
    for (let r = 0, n = table.rows.length; r < n; r++) {
        let tempD = table.rows[r].cells[1].getElementsByTagName("select")[0];
        let tempBankName = tempD.options[tempD.selectedIndex].text.trim();
        let tempAccountNo = table.rows[r].cells[2].getElementsByTagName("input")[0].value;
        let tempBranchName = table.rows[r].cells[3].getElementsByTagName("input")[0].value;
        let tempIfscCode = table.rows[r].cells[4].getElementsByTagName("input")[0].value;
        // let tempopeningbalance = table.rows[r].cells[5].getElementsByTagName("input")[0].value;

        collegeBankName += tempBankName + "::";
        collegeAccountNo += tempAccountNo + "::";
        collegeBranchName += tempBranchName + "::";
        collegeIfscCode += tempIfscCode + "::";
        // openingbalance += tempopeningbalance + "::";
    }
    collegeBankName = collegeBankName.slice(0, -2).trim();
    collegeAccountNo = collegeAccountNo.slice(0, -2).trim();
    collegeBranchName = collegeBranchName.slice(0, -2).trim();
    collegeIfscCode = collegeIfscCode.slice(0, -2).trim();
    // openingbalance = openingbalance.slice(0, -2).trim();
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function validatePanCard(panString) {
    var regpan = /^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/;
    if (regpan.test(panString)) return true;
    else return false
}

function convertToPancardNo(gstNo) {
    if ((gstNo.value.length > 15) || (gstNo.value.length < 15)) {
    }
    else {
        showError(gstNo.id, '', '');
        document.getElementById("panCard").value = gstNo.value.substr(2, 10).toUpperCase();
    }
}

function compareOldValues() {
    var flagForStatement = 0;
    var input = document.getElementById("collegeLogo");
    statement = '';
    if (masterList[0].collegeName != collegeName) {
        flagForStatement = 1;
        statement = statement + "College Name changed from " + masterList[0].collegeName + " to " + collegeName + "<br>";
    }
    if (masterList[0].gstnumber != collegeGstNo) {
        flagForStatement = 1;
        statement = statement + "College GST-NO changed from " + masterList[0].gstnumber + " to " + collegeGstNo + "<br>";
    }
    if (masterList[0].panCardNumber != collegePanCard) {
        flagForStatement = 1;
        statement = statement + "College PAN CARD-No changed from " + masterList[0].panCardNumber + " to " + collegePanCard + "<br>";
    }
    if (masterList[0].address != collegeAddress) {
        flagForStatement = 1;
        statement = statement + "College Address changed from " + masterList[0].address + " to " + collegeAddress + "<br>";
    }
    if (masterList[0].contactNumber != collegeContactNo) {
        flagForStatement = 1;
        statement = statement + "College Contact-No changed from " + masterList[0].contactnumber + " to " + collegeContactNo + "<br>";
    }
    if (masterList[0].collegeEmail != collegeEmail) {
        flagForStatement = 1;
        statement = statement + "College Email-ID changed from " + masterList[0].collegeEmail + " to " + collegeEmail + "<br>";
    }
    if (input.files.length > 0) {
        flagForStatement = 1;
        statement = statement + "Company Logo Changed<br>";
    }
    showError('', '', '');
    return 1;
}

function addTableRowDeveloper(masterList, flag) {
    const mytable = document.getElementById("utilityTableBody");
    var newRow,
        newCell;

    mytable.innerHTML = '';
    for (let i = 0; i < masterList.length; i++) {
        var newRow = document.createElement("tr");
        mytable.appendChild(newRow);

        newCell = document.createElement("td");
        newCell.id = "rowId" + (i + 1);
        newCell.setAttribute("class", "fS23");
        newCell.textContent = (i + 1);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var select = document.createElement("select");
        select.setAttribute("class", "form-control custom-select tAC");
        select.setAttribute("id", "bankName" + (i + 1));
        select.disabled = flag;
        newCell.appendChild(select);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var bankAccountNo = document.createElement("input");
        bankAccountNo.setAttribute("class", "form-control tAC");
        bankAccountNo.setAttribute("id", "bankAccountNo" + (i + 1));
        bankAccountNo.setAttribute("placeholder", "Bank AccountNo");
        bankAccountNo.setAttribute("value", masterList[i].accountNo);
        bankAccountNo.disabled = flag;
        newCell.appendChild(bankAccountNo);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var bankBranchNo = document.createElement("input");
        bankBranchNo.setAttribute("class", "form-control tAC mT10");
        bankBranchNo.setAttribute("id", "bankBranchNo" + (i + 1));
        bankBranchNo.setAttribute("placeholder", "Bank Branch Name");
        bankBranchNo.setAttribute("value", masterList[i].branchName);
        bankBranchNo.disabled = flag;
        newCell.appendChild(bankBranchNo);
        newRow.appendChild(newCell);

        newCell = document.createElement("td");
        var bankIfscCode = document.createElement("input");
        bankIfscCode.setAttribute("class", "form-control tAC mT10");
        bankIfscCode.setAttribute("id", "bankIfscCode" + (i + 1));
        bankIfscCode.setAttribute("placeholder", "Bank IFSC Code");
        bankIfscCode.setAttribute("value", masterList[i].ifscCode);
        bankIfscCode.disabled = flag;
        newCell.appendChild(bankIfscCode);
        newRow.appendChild(newCell);

        // newCell = document.createElement("td");
        // var openingbalance = document.createElement("input");
        // openingbalance.setAttribute("class", "form-control tAC mT10");
        // openingbalance.setAttribute("id", "openingbalance" + (i + 1));

        // openingbalance.setAttribute("placeholder", "Enter Opening Balance");
        // openingbalance.setAttribute("value", masterList[i].openingbalance);
        // newCell.appendChild(openingbalance);
        // newRow.appendChild(newCell);

        if (i != 0) {
            newCell = document.createElement("td");
            var deleteButton = document.createElement("input");
            deleteButton.setAttribute("type", "button");
            deleteButton.setAttribute("id", "deleteButton" + (i + 1));
            deleteButton.setAttribute("class", "imageButton deleteButton form-control");
            deleteButton.setAttribute("title", "Delet Current Row");
            deleteButton.setAttribute("onclick", "deleteRow(this)");
            deleteButton.disabled = flag;
            newCell.appendChild(deleteButton);
            newRow.appendChild(newCell);
        } else {
            newCell = document.createElement("td");
            newRow.appendChild(newCell);
        }
        loadDataDropdown('', "bankName" + (i + 1), masterUtility);
        selectDropdownValue("bankName" + (i + 1), masterList[i].bankName);
    }
}

var collegeName = '',
    collegeGstNo = '',
    collegePanCard = '',
    collegeAddress = '',
    collegeContactNo = '',
    collegeEmail = '',
    collegeLogo = '',
    collegeBankName = '',
    collegeAccountNo = '',
    collegeBranchName = '',
    collegeIfscCode = '',
    // openingbalance = '',
    lifeCoachMeetingVenue = '',
    oldImage = '';

function collegeSetHeaders() {
    collegeName = '';
    collegeGstNo = '';
    collegePanCard = '';
    collegeAddress = '';
    collegeContactNo = '';
    collegeEmail = '';
    collegeLogo = '';
    collegeBankName = '';
    collegeAccountNo = '';
    collegeBranchName = '';
    collegeIfscCode = '';
    lifeCoachMeetingVenue = '';
    // openingbalance = '';

    collegeName = document.getElementById("collegeName").value.trim().toUpperCase();
    collegeGstNo = document.getElementById("gstNo").value.trim().toUpperCase();
    collegePanCard = document.getElementById("panCard").value.trim().toUpperCase();
    collegeAddress = document.getElementById("collegeAddress").value.trim().toUpperCase();
    collegeContactNo = document.getElementById("collegeContactNumber").value.trim();
    collegeEmail = document.getElementById("collegeEmailId").value.trim();
    lifeCoachMeetingVenue = document.getElementById('lifeCoachMeetingVenue').value.trim();

    var input = document.getElementById("collegeLogo");
    collegeLogo = input.files[0];
    if (input.files.length == 0) {
        flagForImage = 'FALSE';
    } else if (input.files.length > 0) {
        flagForImage = 'TRUE';
        var imgSize = (parseFloat(input.files[0].size / 1024) / 1024).toFixed(2);
        if (imgSize > 1) {
            showError('', '', "Image size should not exceed 1 MB.");
            return 0;
        } else showError('', '', '');
    }

    return 1;
}

function collegeFormValidation() {
    if (collegeSetHeaders() == 0) return 0;

    // college name validation
    if (collegeName == '') {
        showError('collegeName', '#ff6666', "College Name can not be Blank.");
        return 0;
    } else showError('collegeName', '', '');

    // pan card validation
    if (collegePanCard == '') {
        showError('panCard', '#ff6666', "Pan Card can not be Blank.");
        return 0;
    } else showError('panCard', '', '');

    if ((validatePanCard(collegePanCard) == false)) {
        showError('panCard', '#ff6666', "Pan Card is not in correct format.");
        return 0;
    } else showError('panCard', '', '');

    // address validation
    if (collegeAddress == '') {
        showError('collegeAddress', '#ff6666', "Address cannot be Blank");
        return 0;
    } else showError('collegeAddress', '', '');

    // contact number validation
    if (collegeContactNo == '') {
        showError('collegeContactNumber', '#ff6666', "contact number cannot be Blank");
        return 0;
    } else showError('collegeContactNumber', '', '');

    if (collegeContactNo.length != '' && collegeContactNo.length != 10) {
        document.getElementById("collegeContactNumber").style.backgroundColor = "#FFC2B3";
        showError('errorMessage', '', "Phone No. should be of 10 digits only.");
        return 0;
    } else {
        document.getElementById("collegeContactNumber").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // email validation
    if (collegeEmail == '') {
        showError('collegeEmailId', '#ff6666', "Email Id cannot be Blank.");
        return 0;
    } else showError('collegeEmailId', '', '');

    if (!validateEmail(collegeEmail) && collegeEmail.length > 0) {
        showError('collegeEmailId', '#ff6666', "Email Id is not in correct format.");
        return 0;
    } else showError('collegeEmailId', '', '');

    if (lifeCoachMeetingVenue == '') {
        showError('lifeCoachMeetingVenue', '#ff6666', "Please enter venue for Life Coach Meeting.");
        return 0;
    } else showError('lifeCoachMeetingVenue', '', '');

    // table validation
    if (checkTableContentIsNotEmpty() == 0) return 0;
    if (tableValidation() == 0) return 0;

    return 1;
}

function saveCollegeMaster(flag) {

    // var username = localStorage.getItem("userNameEdj");
    if (flag == 'New') statement = 'New College Master has been created.';

    document.getElementById('submit').disabled = true;
    if (collegeFormValidation() == 0) {
        document.getElementById('submit').disabled = false;
        return;
    }
    if (flag == 'Edit') {
        if (compareOldValues() == 0) {
            document.getElementById('submit').disabled = false;
            return 0;
        }
    }
    // console.log(flag,collegeName,collegeGstNo,collegePanCard,collegeAddress,collegeContactNo,collegeEmail,collegeBankName,collegeBranchName,collegeAccountNo,collegeIfscCode,openingbalance);
    if (confirm("Are you sure you want to save College???")) {
        document.getElementById('successMessage').innerHTML = 'Adding Details.. Please Wait....';
        document.getElementById('submit').innerHTML = true;
        formData = new FormData();
        // formData.append("userName", username);
        formData.append('flag', flag);
        formData.append('collegeName', collegeName);
        formData.append('collegeGstNo', collegeGstNo);
        formData.append('collegePanCard', collegePanCard);
        formData.append('collegeAddress', collegeAddress);
        formData.append('collegeContactNo', collegeContactNo);
        formData.append('collegeEmail', collegeEmail);
        formData.append('collegeBankName', collegeBankName);
        formData.append('collegeBranchName', collegeBranchName);
        formData.append('collegeAccountNo', collegeAccountNo);
        formData.append('collegeIfscCode', collegeIfscCode);
        formData.append('lifeCoachMeetingVenue', lifeCoachMeetingVenue);
        // formData.append('openingbalance', openingbalance);
        if (flagForImage == "FALSE") {
            formData.append('collegeLogo', oldImage);
        } else {
            formData.append('collegeLogo', collegeLogo);
        }
        formData.append('flagForImage', flagForImage);
        formData.append('statement', statement);
        $.ajax({
            url: "saveCollege.php",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                document.getElementById("submit").disabled = false;
                location.reload();
            }
        });
    }
    else document.getElementById("submit").disabled = false;
}