function countRating(elementId) {
    var temp = elementId.split("rating");
    resetReview();
    noOfRating = 0;
    noOfRating = temp[1];
    document.getElementById(elementId).className = "btn btn-scale btn-scale-desc-" + temp[1] + " btn-border";
}


function resetReview() {
    noOfRating = 0;
    for (let i = 0; i < 10; i++) {
        document.getElementById("rating" + (i + 1)).className = "btn btn-scale btn-scale-desc-" + (i + 1);
    }
}
function selectDiv(id) {
    if (id == 'accept') {
        document.getElementById('acceptDiv').hidden = false;
        document.getElementById('rejectDiv').hidden = true;
    } else if (id == 'reject') {
        document.getElementById('acceptDiv').hidden = true;
        document.getElementById('rejectDiv').hidden = false;
    }
}


function setHeaders() {
    reviewId = '';
    lifeCoachId = '';
    lifeCoachName = '';
    studentId = '';
    studentName = '';
    academicYear = '';
    batchCode = '';
    reviewDateAndTime = '';
    commentText = '';


    reviewId = document.getElementById('reviewId').value.trim();
    lifeCoachId = document.getElementById('lifeCoachId').value.trim();
    lifeCoachName = document.getElementById('lifeCoachName').value.trim();
    studentId = document.getElementById('studentId').value.trim();
    studentName = document.getElementById('studentName').value.trim();
    academicYear = document.getElementById('academicYear').value.trim();
    rejectReason = document.getElementById('rejectReason').value.trim();
    batchCode = document.getElementById('batchCode').value.trim();
    reviewDate = $("#reviewDateAndTime").find("input").val();
    commentText = document.getElementById('commentText').value.trim();
    stage = document.getElementById('stage').value.trim();
}


function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
function formValidation() {
    if (setHeaders() == 0) return 0;
    var checkBoxes = document.getElementsByClassName('mycheckbox');
    var checkBoxvalue = document.getElementsByName('checkvalue');
    var nbChecked = 0;

    for (var i = 0; i < checkBoxes.length; i++) {
        if (checkBoxes[i].checked) nbChecked++;
    }
    for (var i = 0; i < checkBoxvalue.length; i++) {
        if (checkBoxvalue[i].checked) checkedValue = checkBoxvalue[i].value;
    }
    if (nbChecked == 0) {
        document.getElementById('errorMessage').innerHTML = 'Select review status';
        return 0;
    } else document.getElementById('errorMessage').innerHTML = '';
console.log(checkedValue,'checkedValue');
    if (checkedValue == "ACCEPTED") {

        if (reviewDate == '') {
            showError('reviewDateAndTime', '#ff6666', "Review Date cannot be Blank.");
            return 0;
        } else showError('reviewDateAndTime', '', '');

        if (noOfRating == 0) {
            showError('', '#ff6666', "Please Select Rating ");
            return 0;
        } else showError('', '', '');

    } else if (checkedValue == "REJECTED") {

        if (rejectReason == '') {
            document.getElementById('rejectReason').style.backgroundColor = '#ff6666';
            document.getElementById('errorMessage').innerHTML = 'Please Add reason for rejection';
            return 0;
        } else {
            document.getElementById('rejectReason').style.backgroundColor = '';
            document.getElementById('errorMessage').innerHTML = '';
        }
    }


    if (makeArray() == 0) return 0;
    return 1;
}

function escapeSpecialCharacters(input) {
    var output = input.replace(/\+/g, "\+")
        .replace(/\'/g, "\\\'")
        .replace(/\"/g, "\\\"");

    return output;
}

function makeArray() {
    contentArray = [];
    var obj = {
        'noOfRating': noOfRating,
        'reviewId': reviewId,
        'lifeCoachId': lifeCoachId,
        "lifeCoachName": lifeCoachName,
        'studentId': studentId,
        'studentName': studentName,
        'academicYear': academicYear,
        'batchCode': batchCode,
        'reviewDate': reviewDate,
        'commentText': commentText,
        'stage': stage,
        'rejectReason':rejectReason,
        'checkedValue':checkedValue
    }
    contentArray.push(obj);
}
function saveReview() {
    saveFlag = 'saveReview';
    reviewStatus = 'COMPLETED';
    if (formValidation() == 0) return 0;
    console.log(contentArray);
    if (confirm("Are you sure you want to save Review??? ")) {
        document.getElementById('successMessage').innerHTML = 'Saving Review. Please wait...';
        document.getElementById('saveReview').disabled = true;
        // document.getElementById('saveAndPublishReview').disabled = true;
        $.post('saveLifeCoachReview.php', {
            'saveFlag': saveFlag,
            'reviewStatus': reviewStatus,
            'contentArray': contentArray,
        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = 'Review Saved Successfully...';
        });
    }
    else {
        document.getElementById('saveReview').disabled = false;
        // document.getElementById('saveAndPublishReview').disabled = false;
    }
}