var lifeCoachUserId = "",
    lifeCoachCompanyName = "",
    lifeCoachEmailId = "",
    lifeCoachPassword = "",
    lifeCoachFirstName = "",
    lifeCoachLastName = "",
    duplicatEmail = false;

function randomString(length, chars) {
    var mask = '';
    if (chars.indexOf('a') > -1) mask += 'abcdefghijklmnopqrstuvwxyz';
    if (chars.indexOf('A') > -1) mask += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    if (chars.indexOf('#') > -1) mask += '0123456789';
    if (chars.indexOf('!') > -1) mask += '@#&*';
    var result = '';
    for (var i = length; i > 0; --i) result += mask[Math.floor(Math.random() * mask.length)];
    return result;
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Duplicate email');
                document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return duplicatEmail;
            } else {
                showError('errorMessage', '', '');
                document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
                duplicatEmail = false;
                return duplicatEmail;
            }
        }
    );
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    lifeCoachUserId = "";
    lifeCoachCompanyName = '';
    lifeCoachEmailId = '';
    lifeCoachPassword = "";
    lifeCoachFirstName = "";
    lifeCoachLastName = "";

    lifeCoachFirstName = document.getElementById("lifeCoachFirstName").value.trim().toUpperCase();
    lifeCoachLastName = document.getElementById("lifeCoachLastName").value.trim().toUpperCase();
    lifeCoachUserId = document.getElementById("lifeCoachUserId").value.trim();
    lifeCoachCompanyName = document.getElementById("lifeCoachCompanyName").value.trim().toUpperCase();
    lifeCoachEmailId = document.getElementById("lifeCoachEmailId").value.trim();
    lifeCoachPassword = document.getElementById("lifeCoachPassword").value.trim();

    return 1;
}

function lifeCoachValidation() {
    // life Coach first name
    if (lifeCoachFirstName.length <= 0) {
        document.getElementById("lifeCoachFirstName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter first name");
        return 0;
    } else {
        document.getElementById("lifeCoachFirstName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // life coach last name
    if (lifeCoachLastName.length <= 0) {
        document.getElementById("lifeCoachLastName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter last name");
        return 0;
    } else {
        document.getElementById("lifeCoachLastName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //lifeCoach company name validation
    if (lifeCoachCompanyName.length <= 0) {
        document.getElementById("lifeCoachCompanyName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter company name");
        return 0;
    } else {
        document.getElementById("lifeCoachCompanyName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //lifeCoach EmailId validation
    if (lifeCoachEmailId.length <= 0) {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter email");
        return 0;
    } else {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (!validateEmail(lifeCoachEmailId)) {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Email is not in correct format");
        // document.getElementById("errorMessage").style.display="block";
        return 0;
    } else {
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (duplicatEmail) {
        showError('errorMessage', '', 'Email Alredy Exist. Please Change it...');
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "#ffc2b3";
        return 0;
    } else {
        showError('errorMessage', '', '');
        document.getElementById("lifeCoachEmailId").style.backgroundColor = "";
    }
    return 1;
}

function saveLifeCoach() {
    document.getElementById('saveButton').disabled = true;
    if (setHeaders() == 0) return;
    if (lifeCoachValidation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (confirm("Are you sure you want to save Details")) {
        document.getElementById('successMessage').innerHTML = "Saving Data Please Wait...";
        document.getElementById('saveButton').disabled = true;
        $.post('saveLifeCoach.php', {
            'lifeCoachFirstName': lifeCoachFirstName,
            'lifeCoachLastName': lifeCoachLastName,
            'lifeCoachUserId': lifeCoachUserId,
            'lifeCoachCompanyName': lifeCoachCompanyName,
            'lifeCoachEmailId': lifeCoachEmailId,
            'lifeCoachPassword': lifeCoachPassword
        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = "Data Saved successfully.";
            document.getElementById('saveButton').disabled = false;
            // location.reload();
        });
    }
    else document.getElementById('saveButton').disabled = false;
}

function showDetails(lifeCoachId) {
    encodedValue_lifeCoachId = btoa(lifeCoachId);
    encodedKey_lifeCoachId = btoa('lId');
    window.location.href = "viewLifeCoach.php?" + encodedKey_lifeCoachId + "=" + encodedValue_lifeCoachId;
}

function userEdit(lifeCoachId) {
    encodedValue_lifeCoachId = btoa(lifeCoachId);
    encodedKey_lifeCoachId = btoa('lId');
    window.location.href = "editLifeCoach.php?" + encodedKey_lifeCoachId + "=" + encodedValue_lifeCoachId;
}