<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';

$academicYearList = [];
$masterleadsList = [];
$masterleadsPList = [];
$masterEmailList = '';
$masterphoneNoList = '';
$masterdataSourceList = [];


// Get Academic year
$sql = "SELECT distinct firstAcademicYear,secondAcademicYear,thirdAcademicYear FROM centerfee WHERE admissionStatus='IN PROGRESS' ORDER BY RIGHT(thirdAcademicYear, 4) DESC";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($academicYearList, $row);
    }
}

$sqlS = "SELECT seriesValue FROM `seriesnumber` WHERE seriesName='dataSource' ORDER BY trim(seriesValue) ASC ;";
$results = $conn->query($sqlS);
if ($results->num_rows > 0) {
    while ($rows = $results->fetch_assoc()) {
        array_push($masterdataSourceList, $rows);
    }
}


// Get all email IDs From data Pool
$sql = "SELECT emailId FROM `data_pool` where 1 ;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterleadsList, $row);
        $masterEmailList = array_column($masterleadsList, 'emailId');
    }
}

// Get all phone numbers From data Pool
$sql = "SELECT REPLACE(phoneNumber,'\n','') as phoneNumber FROM `data_pool` where 1 ;";
$result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        array_push($masterleadsPList, $row);
        $masterphoneNoList = array_column($masterleadsPList, 'phoneNumber');
    }
}
require '../../common/header.php';
require '../../common/navbar.php';
?>
<style>
    .duplicate {
        background-color: #ff6666;
    }
</style>
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <div class="row">
                                <div class="col-md-12">
                                    <h3 class="tAC fSB">UPLOAD DATA</h3>
                                    <br>
                                    <br>
                                </div>

                            </div>


                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Select Academic Year</label>
                                        <select class="custom-select form-control" name="academicYear" id="academicYear"
                                            style="width: 100%;" disabled>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Select Data Source</label>
                                        <select class="form-control custom-select" id="dataSource" style="width: 100%;">
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Import From Excel :</label><br>
                                        <label class="btn btn-primary" id="fileBtn"> Select File
                                            <input type="file" name="file" id="file" class="input-large"
                                                onchange="displayCSVData(event)" accept=".csv" hidden>
                                        </label>
                                    </div>
                                </div>



                                <div class="col-md-2">

                                    <div class="form-group">
                                        <a class='btn btn-success btn-md mt-4' id="download" href="Add Lead Excel.csv"
                                            download="Add Lead Excel.csv" title="Click here to Download Format">Download
                                            Format
                                            <i class='fas fa-file-excel'>
                                            </i>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <p id='errorMessage text-danger' id="errorMessage"></p>
                                    <p id='successMessage text-success' id="successMessage"></p>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="table">
                                <thead>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email ID</th>
                                    <th>Phone Number</th>
                                    <th>Actions</th>
                                </thead>
                                <tbody id="csvDataTable"></tbody>
                            </table>

                            <div class="row">

                            </div>

                        </div>
                        <div class="card-footer tAC">
                            <p id='errorMessage' class="text-center"
                                style="color: red; font-size: 1.2em;   text-align: center;">
                            </p>
                            <p id='successMessage' class="text-center"
                                style="color: #25C032; font-size: 1.2em;   text-align: center;">
                            </p>
                            <span id="savedData"></span>
                            <button type="submit" id="saveButton" name="saveLeads" class="btn btn-primary btn-fill"
                                data-loading-text="Loading..." onclick="uploadData()">Upload Data</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="uploadData.js?v=<?php echo $fileVersion; ?>"></script>
<script>
    var academicYearList = <?php echo json_encode($academicYearList) ?>;
    var masterleadsList = <?php echo json_encode($masterleadsList) ?>;
    var masterEmailList = <?php echo json_encode($masterEmailList) ?>;
    var masterphoneNoList = <?php echo json_encode($masterphoneNoList) ?>;
    var masterdataSourceList = <?php echo json_encode($masterdataSourceList) ?>;
    console.log(masterphoneNoList);
    console.log(masterEmailList);
    var duplicateIndex = '';
    function validateEmail(email) {
        const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
        return re.test(String(email).toLowerCase());
    }
    $(function() {
        $('.select2').select2();

        $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
        loadDataDropdown("academicYear", academicYearList);
        loadDataDropdown("dataSource", masterdataSourceList);
        selectDropdownValue("academicYear", academicYearList);
    });
    var duplicateRows = [];
    function displayCSVData(event) {
        const file = event.target.files[0];
        const reader = new FileReader();
        reader.onload = function(e) {
            const data = e.target.result;
            const rows = data.split('\n');
            const tableData = [];
            const table = document.createElement('table');
            for (let i = 1; i < rows.length; i++) {
                const cells = rows[i].split(',');
                if (cells.length > 1) {
                    const row = document.createElement('tr');
                    const rowData = cells.slice(0, -1); // exclude the last column (delete button)
                    const rowKey = rowData.join(',');
                    // console.log(rowKey, 'rowKey');
                    if (tableData.includes(rowKey)) {
                        duplicateRows.push(i);
                        row.style.backgroundColor = '#ff6666';
                    } else {
                        tableData.push(rowKey);
                    }
                    for (let j = 0; j < cells.length; j++) {
                        const cell = document.createElement('td');
                        cell.textContent = cells[j];
                        row.appendChild(cell);
                    }
                    const buttonCell = document.createElement('td');
                    const deleteButton = document.createElement('button');
                    deleteButton.setAttribute("class", "btn btn-danger btn-fill");
                    deleteButton.setAttribute("id", "deleteButton1" + i);
                    var icon = document.createElement("i");
                    icon.className = 'fas fa-trash-alt';
                    deleteButton.appendChild(icon);
                    deleteButton.setAttribute("onclick", `deleteRow(this, ${i}, ${duplicateRows.includes(i)})`);
                    buttonCell.appendChild(deleteButton);
                    row.appendChild(buttonCell);
                    // check if email or phone is present in masterleadsList
                    const emailColumn = cells[2].trim(); // assuming email is in the 3rd column
                    const phoneColumn = cells[3].replace(/(\r\n|\n|\r)/gm, "").trim(); // // assuming email is in the 4th column
                    // console.log(phoneColumn.length, 'phoneColumn');
                    if (!validateEmail(emailColumn) || phoneColumn.length < 10 || parseFloat(phoneColumn) <= 0) {
                        row.style.backgroundColor = '#ff6666';
                    } else {
                        row.style.backgroundColor = '';
                    }

                    if (phoneColumn.length < 10) {
                        row.style.backgroundColor = '#ff6666';
                    } else {
                        row.style.backgroundColor = '';
                    }
                    // console.log(masterEmailList);
                    if (emailColumn.length > 0) {
                        if (masterEmailList.includes(emailColumn)) {
                            console.log(masterEmailList, 'emailColumnIncluded duplicate');
                            row.style.backgroundColor = '#ff6666';
                        }
                    } else if (masterphoneNoList.includes(phoneColumn)) {
                        row.style.backgroundColor = '#ff6666';
                    }
                    table.appendChild(row);
                }
            }
            document.getElementById('csvDataTable').innerHTML = table.innerHTML;
        };

        reader.readAsText(file);
    }

    function deleteRow(button, rowNumber, isDuplicate) {
        const row = button.parentNode.parentNode;
        row.parentNode.removeChild(row);
        if (isDuplicate) {
            const index = duplicateRows.indexOf(rowNumber);
            if (index !== -1) {
                duplicateRows.splice(index, 1);
            }
        }
    }


    function loadDataDropdown(selectName, results, centerId) {
        var theSelect = document.getElementById(selectName);
        var options = theSelect.getElementsByTagName("option");
        theSelect.innerHTML = "";
        for (var i = 0; i < results.length; i++) {
            options = document.createElement("option");
            if (selectName.includes("academicYear")) {
                if (i == 0) {
                    options.value = options.text = "SELECT ACADEMIC YEAR";
                    theSelect.add(options);
                    options.selected = true;
                    options.disabled = true;
                    options = document.createElement("option");
                }
                academicYear1 = results[i].firstAcademicYear.split("-");
                academicYear2 = results[i].thirdAcademicYear.split("-");
                academicYear = academicYear1[0] + '-' + academicYear2[1];
                options.value = options.text = academicYear;
                theSelect.add(options);
            } else if (selectName.includes("dataSource")) {
                if (i == 0) {
                    options.value = options.text = "SELECT DATA SOURCE";
                    theSelect.add(options);
                    options.selected = true;
                    options.disabled = true;
                    options = document.createElement("option");
                }
                options.value = results[i].seriesValue;
                options.text = results[i].seriesValue.toUpperCase();
                theSelect.add(options);
            }
        }
        return;
    }
</script>
<?php require '../../common/footer.php'; ?>