<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}
require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">CANCELLED ADMISSION</h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="studentListTable">
                                <thead>
                                    <tr>
                                        <th width='10%'>STUDENT ID</th>
                                        <th width='25%'>STUDENT NAME</th>
                                        <th width='15%'>ACADEMIC YEAR</th>
                                        <th width='30%'>STATUS</th>
                                        <th width='15%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    $sql = "SELECT * from admssioncancelledstudents order by STR_TO_DATE(admissionCancelInitiationTimeStamp,'%d-%m-%Y') desc;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $approvalStatusCss = '';
                                            $statusCss = '';
                                            if ($row['ownerApproval'] == 'PENDING') $approvalStatusCss = 'badge badge-danger';
                                            if ($row['ownerApproval'] == 'APPROVED') {
                                                $approvalStatusCss = 'badge badge-success';
                                                $buttonCss = 'disabled';
                                            }
                                            if ($row['ownerApproval'] == 'DISAPPROVED') $approvalStatusCss = 'badge badge-warning';

                                            if ($row['cancellationStatus'] == 'PENDING AT ACCOUNTS') $statusCss = 'badge badge-warning';
                                            if ($row['cancellationStatus'] == 'OWNER APPROVAL PENDING') $statusCss = 'badge badge-primary';
                                            if ($row['cancellationStatus'] == 'PAYMNET DISBURSAL PENDING') $statusCss = 'badge badge-secondary';
                                            if ($row['cancellationStatus'] == 'COMPLETED') 
                                            {
                                                $statusCss = 'badge badge-success';
                                                $disBtn='disabled';
                                            }else{$disBtn='';}
                                            echo "
                                                <tr class='tAC'>
                                                    <td> " . $row['studentId']  . "</td>
                                                    <td>" . $row['studentFirstName'] . '  ' . $row['studentLastName'] . "</td>
                                                    <td> " . $row['academicYear']  . "</td>
                                                    <td><span class = '" . $statusCss . "'>" . $row['cancellationStatus'] . "</td>
                                                    <td class='project-actions'>
                                                    <a class='btn btn-primary btn-sm' href='#' id = " . $row['studentId'] . " onclick='viewStudentAdmissionCancelDetails(this.id)' title='Click hear to view Student Details'>
                                                        <i class='fas fa-eye'></i>
                                                        </i>
                                                    </a>
                                                    <a class='btn btn-secondary btn-sm $disBtn' href='#' id = " . $row['studentId'] . " onclick='editStudentAdmissionCancelDetails(this.id)' title='Click hear to edit Student Details'>
                                                        <i class='fas fa-user-edit'></i>
                                                        </i>
                                                    </a>
                                                </td>
                                               
                                                    </tr>
                                            ";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="admissoinCancelledStudents.js?v=<?php echo $fileVersion; ?>"></script>



<script>
    $(function() {

        $("#studentListTable").DataTable({
            "responsive": true,
            "autoWidth": false,
            "aLengthMenu": [
                [5, 10, 25, 50, 75, -1],
                [5, 10, 25, 50, 75, "All"]
            ],
            "pageLength": 20,
            "aaSorting": [],
        });
    });
</script>
<?php require '../../common/footer.php'; ?>