<?php
session_start();
if (strlen($_SESSION['ownerLoginsuccessEdj'])) {
    if ($_SESSION['ownerLoginsuccessEdj'] > 0) {
    } else {
        header('Location:../../../loginPage.php');
        exit;
    }
} else {
    header('Location:../../../loginPage.php');
    exit;
}

require_once '../../common/connectToDB.php';
require '../../common/header.php';
require '../../common/navbar.php';
?>

<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card mT10">
                        <div class="card-header">
                            <h3 class="tAC fSB">MANAGE ATTENDANCE</h3>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group" style="margin-left: 21px;">
                                    <label class="fS13">FILTER BY USER STATUS</label>
                                    <select class="select2" multiple="multiple" id="userStatusFilter" data-placeholder="SELECT USER STATUS" style="width: 100%;" onchange="filterOtherDropDown('statusOfuser')" ;>
                                        <option value='ACTIVE' selected>ACTIVE</option>
                                        <option value='BLOCKED'>BLOCKED</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-striped projects tAC" id="pendingAttendanceTable">
                                <thead>
                                    <tr>
                                        <th width='15%'>EMPLOYEE ID</th>
                                        <th width='20%'>EMPLOYEE NAME</th>
                                        <th width='20%'>DESIGNATION</th>
                                        <th width='10%'>STATUS</th>
                                        <th width='20%'>TENURE</th>

                                        <th width='15%'>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    require_once '../../common/connectToDB.php';
                                    // $sql = "SELECT * from user_attendance where attendanceStatus='COMPLETED' GROUP BY userid ;;";
                                    $sql = "SELECT  l.userid,l.user_type,ua.userid,ua.userName,l.userStatus,ua.attendanceMonth,ua.dateofJoining,l.dateofJoining as dateofJoining1 
                                    from logindetail as l,user_attendance as ua where ua.userid=l.userid 
                                    AND ua.attendanceStatus='COMPLETED' GROUP BY ua.userid ORDER BY ua.userid DESC;";
                                    $result = $conn->query($sql);
                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            $attendanceMonth = date("F Y", strtotime($row['dateofJoining']));
                                            $attendance1 = '"' . $attendanceMonth . '"';
                                            if ($row["userStatus"] == 'BLOCKED') $statusCss = 'badge badge-danger';
                                            if ($row["userStatus"] == 'ACTIVE') $statusCss = 'badge badge-success';



                                            date_default_timezone_set('Asia/Kolkata');
                                            $edate = date("Y-m-d");
                                            $sdate = $row['dateofJoining1'];
                                            $date_diff = abs(strtotime($edate) - strtotime($sdate));

                                            $years = floor($date_diff / (365 * 60 * 60 * 24));
                                            $months = floor(($date_diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
                                            // $days = floor(($date_diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));

                                            

                                            if($years != 0){
                                                $tenure = $years .' Years & '. $months .' Months';
                                            }else{
                                                $tenure = $months .' Months';

                                            }
                                            echo "<tr  class='tAC'>
                                            <td > " . $row['userid']  . "</td>
                                            <td > " . $row['userName'] . "</td>
                                            <td > " . $row['user_type']  . "</td>
                                            <td><span class = '" . $statusCss . "'>" . $row["userStatus"]  . "</span></td>
                                            <td > " . $tenure  . "</td>

                                            <td>
                                            <a class='btn btn-primary' title='Click hear to Add' id = " . $row['userid'] . " onclick='editAttendance(this.id,$attendance1)'>
                                                <i class='fas fa-eye fS15'></i>
                                                </a>
                                            </td> 
                                        </tr>";
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="../../../plugins/jquery/jquery.min.js"></script>
<script src="../../../plugins/bootstrap/js/bootstrap.bundle.min.js"> </script>
<script src="../../../plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../../../plugins/select2/js/select2.full.min.js"> </script>
<script src="../../../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../../../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="manageAttendance.js?v=<?php echo $fileVersion; ?>"></script>

<script>
    $(function() {

        $(document).ready(function() {
            $.fn.dataTableExt.afnFiltering.push(
                function(settings, data, dataIndex) {
                    selecteduserStatus = getSelectValues('', document.getElementById("userStatusFilter")).trim();

                    var rowuserStatus = data[3].trim();


                    if (selecteduserStatus != '') {
                        inuserStatus = (selecteduserStatus.indexOf(rowuserStatus) != -1) ? rowuserStatus : false;
                    } else inuserStatus = true;
                    return inuserStatus;
                }
            );
            $('.select2').select2();
            $("#pendingAttendanceTable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "aLengthMenu": [
                    [5, 10, 25, 50, 75, -1],
                    [5, 10, 25, 50, 75, "All"]
                ],
                "pageLength": 20,
                "aaSorting": [],
            });
        });
    });

    function filterOtherDropDown(flag) {

        var table = $('#pendingAttendanceTable').DataTable();
        table.draw();
    }

    function getSelectValues(flag, selectVar) {
        var result = "";
        var options = selectVar && selectVar.options;
        var opt;

        for (var i = 0, iLen = options.length; i < iLen; i++) {
            opt = options[i];
            if (flag == '') {
                if (opt.selected) {
                    result += opt.text;
                }
            }
            if (flag == "multiple") {
                if (opt.selected) {
                    result += opt.text + "|";
                }
            }
        }
        return result.trim();
    }
</script>

<?php require '../../common/footer.php'; ?>