var auditorUserId = "",
    auditorCompanyName = "",
    auditorEmailId = "",
    auditorPassword = "",
    auditorFirstName = "",
    auditorLastName = "",
    duplicatEmail = false,
    statement = '',
    flagForStatement = '';


const oldData = {
    auditorId: "",
    auditorFirstName: "",
    auditorLastName: "",
    auditorCompanyName: "",
    auditorPassword: "",
    auditorEmail: ""
}

function loadOldValues() {
    oldData.auditorId = document.getElementById("auditorUserId").value.trim();
    oldData.auditorFirstName = document.getElementById("auditorFirstName").value.trim().toUpperCase();
    oldData.auditorLastName = document.getElementById("auditorLastName").value.trim().toUpperCase();
    oldData.auditorCompanyName = document.getElementById("auditorCompanyName").value.trim();
    oldData.auditorEmail = document.getElementById("auditorEmailId").value.trim();
    oldData.auditorPassword = document.getElementById("auditorPassword").value.trim();
}

function compareNewValuesWithOld() {
    statement = "UPDATE done in Auditor Profile-ID " + oldData.auditorId + " Name " + oldData.auditorFirstName + " " + oldData.auditorLastName + ". ";
    var flagForStatement = 0;

    if (oldData.auditorFirstName != auditorFirstName) {
        flagForStatement = 1;
        statement = statement + "First Name changed from " + oldData.auditorFirstName + " to " + auditorFirstName + "<br>";
    }
    if (oldData.auditorLastName != auditorLastName) {
        flagForStatement = 1;
        statement = statement + "Last Name changed from " + oldData.auditorLastName + " to " + auditorLastName + "<br>";
    }
    if (oldData.auditorCompanyName != auditorCompanyName) {
        flagForStatement = 1;
        statement = statement + "Company Name changed from " + oldData.auditorCompanyName + " to " + auditorCompanyName + "<br>";
    }
    if (oldData.auditorEmail != auditorEmailId) {
        flagForStatement = 1;
        statement = statement + "Email ID changed from " + oldData.auditorEmail + " to " + auditorEmailId + "<br>";
    }
    if (flagForStatement == 0) {
        showError('', '#ff6666', 'No Changes Done');
        return 0;
    }
    return 1;
}

function checkDuplicate(emailId) {
    $.post('checkDuplicate.php', {
        'emailId': emailId
    },
        function (data) {
            if (data == 1) {
                showError('errorMessage', '', 'Duplicate email');
                document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
                duplicatEmail = true;
                return duplicatEmail;
            } else {
                showError('errorMessage', '', '');
                document.getElementById("auditorEmailId").style.backgroundColor = "";
                duplicatEmail = false;
                return duplicatEmail;
            }
        }
    );
}

function validateEmail(email) {
    const re = /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/;
    return re.test(String(email).toLowerCase());
}

function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function setHeaders() {
    auditorUserId = "";
    auditorCompanyName = '';
    auditorEmailId = '';
    auditorPassword = "";
    auditorFirstName = "";
    auditorLastName = "";

    auditorFirstName = document.getElementById("auditorFirstName").value.trim().toUpperCase();
    auditorLastName = document.getElementById("auditorLastName").value.trim().toUpperCase();
    auditorUserId = document.getElementById("auditorUserId").value.trim();
    auditorCompanyName = document.getElementById("auditorCompanyName").value.trim().toUpperCase();
    auditorEmailId = document.getElementById("auditorEmailId").value.trim();
    auditorPassword = document.getElementById("auditorPassword").value.trim();

    return 1;
}

function auditorValidation() {
    // life Coach first name
    if (auditorFirstName.length <= 0) {
        document.getElementById("auditorFirstName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter first name");
        return 0;
    } else {
        document.getElementById("auditorFirstName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    // life coach last name
    if (auditorLastName.length <= 0) {
        document.getElementById("auditorLastName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter last name");
        return 0;
    } else {
        document.getElementById("auditorLastName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //auditor company name validation
    if (auditorCompanyName.length <= 0) {
        document.getElementById("auditorCompanyName").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter company name");
        return 0;
    } else {
        document.getElementById("auditorCompanyName").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    //auditor EmailId validation
    if (auditorEmailId.length <= 0) {
        document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Enter email");
        return 0;
    } else {
        document.getElementById("auditorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (!validateEmail(auditorEmailId)) {
        document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
        showError('errorMessage', '', "Email is not in correct format");
        // document.getElementById("errorMessage").style.display="block";
        return 0;
    } else {
        document.getElementById("auditorEmailId").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (duplicatEmail) {
        showError('errorMessage', '', 'Email Alredy Exist. Please Change it...');
        document.getElementById("auditorEmailId").style.backgroundColor = "#ffc2b3";
        return 0;
    } else {
        showError('errorMessage', '', '');
        document.getElementById("auditorEmailId").style.backgroundColor = "";
    }
    return 1;
}

function updateAuditor() {
    document.getElementById('updateButton').disabled = true;
    if (setHeaders() == 0) return;
    if (auditorValidation() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }
    if (compareNewValuesWithOld() == 0) {
        document.getElementById('updateButton').disabled = false;
        return;
    }

    var flagForUpdate = "TRUE";
    if (confirm("Are you sure you want to update details?")) {
        document.getElementById('successMessage').innerHTML = "Saving Please Wait...";
        document.getElementById('updateButton').disabled = true;
        $.post('updateAuditor.php', {
            'flagForUpdate': flagForUpdate,
            'auditorFirstName': auditorFirstName,
            'auditorLastName': auditorLastName,
            'auditorUserId': auditorUserId,
            'auditorCompanyName': auditorCompanyName,
            'auditorEmailId': auditorEmailId,
            'auditorPassword': auditorPassword,
            'logStatement': statement
        }, function (data) {
            document.getElementById('successMessage').innerHTML = "Saved successfully. Please wait page will get auto-refresh.";
            document.getElementById('updateButton').disabled = false;
            location.reload();
        });
    }
    else document.getElementById('updateButton').disabled = false;
}