var nbfcId = '',
    companyName = '',
    emailId = '',
    nbfcPassword = '',
    nbfcContactNumber = '',
    nbfcPanNumber = '',
    nbfcPaymentMethod = '',
    nbfcGst = '',
    nbfcAddress = '',
    nbfcCity = '',
    nbfcState = '',
    pinCode = '',
    nbfcBankName = '',
    nbfcAccountHolderName = '',
    ifscCode = '',
    accountType = '',
    accountNo = '',
    bankBranch = '';




function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);

    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";

    // add first row as dummy in select
    // options = document.createElement("option");
    // options.value = "";
    // if (selectName.includes("subjectOffered")) options.text = "SELECT A SUBJECT";
    // else if (selectName.includes("center")) options.text = "SELECT CENTER LOCATION";

    // options.disabled = false;
    // options.selected = true;
    // theSelect.add(options);

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");

        if (selectName.includes("subjectOffered")) {
            options.value = options.text = results[i].subjectName.toUpperCase();
            theSelect.add(options);
            // if (i == 0) options.selected = true;
        } else if (selectName.includes("center")) {
            options.value = options.text = results[i].toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("nbfcBankName")) {
            if (i == 0) {
                options.value = options.text = "SELECT BANK NAME";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].bankName;
            options.text = results[i].bankName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("nbfcCity")) {
            if (i == 0) {
                options.value = options.text = "SELECT CITY";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].cityName;
            options.text = results[i].cityName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("nbfcState")) {
            if (i == 0) {
                options.value = options.text = "SELECT STATE";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            options.value = results[i].stateName;
            options.text = results[i].stateName.toUpperCase();
            theSelect.add(options);
        } else if (selectName.includes("nbfcPaymentMethod")) {
            if (i == 0) {
                options.value = options.text = "SELECT PAYMENT TYPE";
                theSelect.add(options);
                options.selected = true;
                options = document.createElement("option");
            }
            if (results[i].PaymentType != null) {
                options.value = results[i].PaymentType;
                options.text = results[i].PaymentType;
                theSelect.add(options);
            }

        }

    }
    return;
}

function selectDropdownValue(selectName, val) {
    val = val.toUpperCase();
    // console.log(val);
    var theSelect = document.getElementById(selectName);
    // console.log(selectName, val, theSelect.options.length)
    for (var j = 0; j < theSelect.options.length; j++) {
        // HERE it is match with id and text
        var optVal = theSelect.options[j].text;
        // var optVal = theSelect.options[j].value;
        // console.log(optVal, val)
        if (optVal == val) {
            theSelect.options[j].selected = true;
        }
    }
    // theSelect.style.color="white";
    return;
}


function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}

function showIntermediateError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessageIntermediate').innerHTML = message;
}

function setHeaders() {
    nbfcId = '',
        companyName = '',
        emailId = '',
        nbfcPassword = '',
        nbfcContactNumber = '',
        nbfcPanNumber = '',
        nbfcPaymentMethod = '',
        nbfcGst = '',
        nbfcAddress = '',
        nbfcCity = '',
        nbfcState = '',
        pinCode = '',
        nbfcBankName = '',
        nbfcAccountHolderName = '',
        ifscCode = '',
        accountType = '',
        accountNo = '',
        bankBranch = '';


    nbfcId = document.getElementById("nbfcId");
    companyName = document.getElementById("nbfcName");
    emailId = document.getElementById("nbfcEmailId");
    nbfcPassword = document.getElementById("nbfcPassword");
    nbfcContactNumber = document.getElementById("nbfcContactNumber");
    nbfcPanNumber = document.getElementById("nbfcPanNumber");
    nbfcPaymentMethod = document.getElementById("nbfcPaymentMethod");
    nbfcGst = document.getElementById("nbfcGst");
    nbfcAddress = document.getElementById("nbfcAddress");
    nbfcCity = document.getElementById("nbfcCity");
    nbfcState = document.getElementById("nbfcState");
    pinCode = document.getElementById("pinCode");
    nbfcBankName = document.getElementById("nbfcBankName");
    nbfcAccountHolderName = document.getElementById("nbfcAccountHolderName");
    ifscCode = document.getElementById("ifscCode");
    accountType = document.getElementById("accountType").value;
    accountNo = document.getElementById("accountNo");
    bankBranch = document.getElementById("bankBranch");
    return 1;
}

function getDropdownValue(id) {
    var tempP = document.getElementById(id);
    return tempP.options[tempP.selectedIndex].text;
}

function getSelectValues(selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (opt.selected) {
            result += opt.text + "|";
        }
    }
    return result.trim();
}

function validateEmail(email) {
    const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
}

function validateAlphaNumaric(val) {
    const re = /^[a-zA-Z0-9]+$/;
    return re.test(String(val));
}

function validatePanCard(panString) {
    var regpan = /^([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}?$/;
    if (regpan.test(panString)) return true;
    else return false
}

function validateIfsc(ifscString) {
    var regpan = /^[A-Za-z]{4}[a-zA-Z0-9]{7}$/;
    return regpan.test(ifscString)
}

//nbfc data validation
function part1Validation() {

    if (nbfcContactNumber.value.length != '' && nbfcContactNumber.value.length != 10) {
        document.getElementById("nbfcContactNumber").style.backgroundColor = "#FFC2B3";
        showError('errorMessage', '', "Phone No. should be of 10 digits only.");
        return 0;
    } else {
        document.getElementById("nbfcContactNumber").style.backgroundColor = "";
        showError('errorMessage', '', '');
    }

    if (nbfcPanNumber.value != '') {
        if (((nbfcPanNumber.value.length > 10) || (nbfcPanNumber.value.length < 10))) {
            showError('nbfcPanNumber', '#ff6666', "Card No is not in correct format. Please correct it.");
            return 0;
        } else showError('nbfcPanNumber', '', '');
    }


    if (nbfcGst.value != '') {
        if (nbfcGst.value.length > 16) {
            showError('nbfcGst', '#ff6666', "Company gstNo length should Be less than 16.");
            return 0;
        } else showError('nbfcGst', '', '');
    }

    if (nbfcAddress.value != '') {
        if (nbfcAddress.value.length < 4) {
            showError('nbfcAddress', '#ff6666', "Address is not in correct format. Please correct it.");
            return 0;
        } else showError('nbfcAddress', '', '');
    }

    if (pinCode.value != '') {
        if (pinCode.value.length != 6) {
            showError('pinCode', '#ff6666', "Pincode should be 6 digit. Please correct it.");
            return 0;
        } else showError('pinCode', '', '');
    }

    if (nbfcAccountHolderName.value != '') {
        if (nbfcAccountHolderName.value.length < 4) {
            showError('nbfcAccountHolderName', '#ff6666', "Name is not in correct format. Please correct it.");
            return 0;
        } else showError('nbfcAccountHolderName', '', '');


    }



    if (ifscCode.value != '') {
        if ((ifscCode.value.length < 11)) {
            showError('ifscCode', '#ff6666', "IFSC code is not in correct format. Please correct it.");
            return 0;
        } else showError('ifscCode', '', '');

    }

    if (accountNo.value != '') {
        if ((accountNo.value.length < 9) || (accountNo.value.length > 18)) {
            showError('accountNo', '#ff6666', "Account No can not be blank. Please correct it.");
            return 0;
        } else showError('accountNo', '', '');
    }



    if (bankBranch.value != '') {
        if (bankBranch.value.length < 4) {
            showError('bankBranch', '#ff6666', "Name is not in correct format. Please correct it.");
            return 0;
        } else showError('bankBranch', '', '');


    }

}



function formValidation() {
    if (setHeaders() == 0) return 0;

    if (part1Validation() == 0) return 0;

    return 1;
}
//save nbfc
function savenbfc(flag) {
    var flag1 = flag;
    if (formValidation() == 0) {
        return;
    }

    if (flag == 'Save Details' || flag == 'Update Details') {

        // console.log("Clear");

        document.getElementById('successMessage').innerHTML = 'Updating the profile . Please wait...';
        document.getElementById("saveButton").disabled = true;
        $.post('saveProfile.php', {
            'flag': flag,
            'nbfcId': nbfcId.value,
            'companyName': companyName.value,
            'nbfcPassword': nbfcPassword.value,
            'emailId': emailId.value,
            'contactNumber': nbfcContactNumber.value,
            'panNumber': nbfcPanNumber.value,
            'paymentMethod': nbfcPaymentMethod.value,
            'ifscCode': ifscCode.value,
            'gstNo': nbfcGst.value,
            'nbfcAddress': nbfcAddress.value,
            'nbfcCity': nbfcCity.value,
            'nbfcState': nbfcState.value,
            'pinCode': pinCode.value,
            'nbfcBankName': nbfcBankName.value,
            'nbfcAccountHolderName': nbfcAccountHolderName.value,
            'accountType': accountType,
            'accountNo': accountNo.value,
            'bankBranch': bankBranch.value,

        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = 'Profile Updated Successfully. Please wait. The page will get auto-refresh...';
            document.getElementById("saveButton").disabled = false;
            location.reload();
        });
    }


}



//edit Starts