function getSelectValues(flag, selectVar) {
    var result = "";
    var options = selectVar && selectVar.options;
    var opt;

    for (var i = 0, iLen = options.length; i < iLen; i++) {
        opt = options[i];
        if (flag == '') {
            if (opt.selected) {
                result += opt.text;
            }
        }
        if (flag == "multiple") {
            if (opt.selected) {
                result += opt.text + "|";
            }
        }
        if (flag == "value") {
            if (opt.selected) {
                result += opt.value;
            }
        }
        if (flag == "MultipleValue") {
            if (opt.selected) {
                result += opt.value + "|";
            }
        }
    }
    return result.trim();
}
function dummyOptions(theSelect, options, dropowntext) {
    options = document.createElement("option");
    options.value = "";
    options.disabled = false;
    options.selected = true;
    theSelect.add(options);
    options.text = "SELECT " + dropowntext;
}
function loadDataDropdown(selectName, results) {
    var theSelect = document.getElementById(selectName);
    var options = theSelect.getElementsByTagName("option");
    theSelect.innerHTML = "";
    if (selectName.includes('faculty')) dummyOptions(theSelect, options, "FACULTY/SELF");

    for (var i = 0; i < results.length; i++) {
        options = document.createElement("option");
        if (selectName.includes("studentCategory")) {



            options.value = results[i].seriesName;
            options.text = results[i].seriesValue.toUpperCase();
            theSelect.add(options);
        }
        if (selectName.includes("studentbatch")) {

            options.value = results[i].batchId;
            options.text = results[i].batchTitle.toUpperCase();
            theSelect.add(options);
        }
        if (selectName.includes("faculty")) {

            options.value = results[i].userId;
            options.text = results[i].firstName.toUpperCase() + ' ' + results[i].lastName.toUpperCase();
            theSelect.add(options);
        }
        if (selectName.includes("worksheets")) {

            options.value = results[i].worksheetId;
            options.text = results[i].worksheetTitle.toUpperCase();
            theSelect.add(options);
        }
    }
    return;
}
function showError(id, color, message) {
    if (id != '')
        document.getElementById(id).style.backgroundColor = color;
    document.getElementById('errorMessage').innerHTML = message;
}
function setHeaders() {
    workshopDate = '';
    workshopTitle = '';
    studentCategory = '';
    workshopId = '';
    batchId = '';
    batchName = '';
    description = '';
    workshopId = document.getElementById('workshopId').value.trim();

    workshopDate = document.getElementById('workshopDate').value.trim();
    workshopTitle = document.getElementById('workshopTitle').value.trim();
    description = document.getElementById('description').value.trim();
    facultyId = document.getElementById('faculty').value.trim();
    facultyName = faculty[faculty.selectedIndex].text.toUpperCase();

    fee = document.getElementById('fee').value.trim();
    studentCategory = getSelectValues('multiple', document.getElementById("studentCategory"))
        .trim();
    batchName = getSelectValues('multiple', document.getElementById("studentbatch"))
        .trim();
    batchId = getSelectValues('MultipleValue', document.getElementById("studentbatch"))
        .trim();
    // worksheetId = getSelectValues('MultipleValue', document.getElementById("worksheets"))
    //     .trim();
    table = document.getElementById('documentTable');
}

count='';
function updateCheckCount(checkId) {
    if (document.getElementById(checkId).checked) {
        count = count + 1;
        checkedValues.push(checkId);
    } else {
        for (var i = 0; i < checkedValues.length; i++) {
            if (checkedValues[i] == checkId) {
                checkedValues.splice(i, 1);
            }
        }
    }
    console.log(checkedValues);
}

function validation() {
    if (workshopDate == '') {
        showError('workshopDate', '#ff6666', "Workshop Date Cannot Be Blank");
        return 0;
    } else {
        showError('workshopDate', '', "");
    }
    if (workshopTitle == '') {
        showError('workshopTitle', '#ff6666', "Workshop Title Cannot Be Blank");
        return 0;
    } else {
        showError('workshopTitle', '', "");
    }

    if (batchName == '') {
        showError('studentbatch', '#ff6666', "Please Select Batch");
        return 0;
    } else {
        showError('studentbatch', '', "");
    }

    if (studentCategory == '') {
        showError('studentCategory', '#ff6666', "Please Select Student Category");
        return 0;
    } else {
        showError('studentCategory', '', "");
    }
    if (facultyId == '') {
        showError('faculty', '#ff6666', "Please Select faculty or self");
        return 0;
    } else {
        showError('faculty', '', "");
    }
    if (fee == '') {
        showError('fee', '#ff6666', "Please add fee for workshop");
        return 0;
    } else {
        showError('fee', '', "");
    }
    if (description == '') {
        showError('description', '#ff6666', "Please add description");
        return 0;
    } else {
        showError('description', '', "");
    }

    if (table.rows.length == 0) {
        showError('', '#ff6666', "No students From this Category");
        return 0;
    } else {
        showError('', '', "");
    }

}
function studentsData() {
    var table = document.getElementById('documentTable');
    tableContent = [];
    for (let r = 0, n = table.rows.length; r < n; r++) {
        var tempStudentId = table.rows[r].cells[0].innerHTML;
        var tempStudentName = table.rows[r].cells[1].innerHTML;
        var tempStudentCategory = table.rows[r].cells[2].innerHTML;
        var tempacademicYear = table.rows[r].cells[4].innerHTML;
        var tempBatchName = table.rows[r].cells[3].innerHTML;

        var obj = {
            tableStudentId: tempStudentId,
            tableStudentName: tempStudentName,
            tableStudentCategory: tempStudentCategory,
            academicYear: tempacademicYear,
            batchName: tempBatchName,

        };
        tableContent.push(obj);
    }
}
function saveWorkshop() {
    var saveFlag = 'SAVE-WORKSHOP';
    if (setHeaders() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (validation() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    if (studentsData() == 0) {
        document.getElementById('saveButton').disabled = false;
        return;
    }
    console.log(workshopDate);
    console.log(workshopTitle);
    console.log(studentCategory);
    console.log(tableContent);
    console.log(batchId);
    console.log(batchName);
    console.log(description);
    if (confirm("Are you sure you want to Save Workshop?")) {
        document.getElementById("saveButton").disabled = true;
        document.getElementById('successMessage').innerHTML = 'Saving please wait';
        $.post('saveWorkshop.php', {
            'saveFlag': saveFlag,
            'workshopId': workshopId,
            'batchId': batchId,
            'batchName': batchName,
            'description': description,
            'workshopDate': workshopDate,
            'studentCategory': studentCategory,
            'workshopTitle': workshopTitle,
            'tableContent': tableContent,
            'facultyId': facultyId,
            'facultyName': facultyName,
            'fee': fee,
            'worksheetId':checkedValues.toString(),


        }, function (data) {
            console.log(data);
            document.getElementById('successMessage').innerHTML = 'Saved successfully.';
            document.getElementById("saveButton").disabled = true;
            // location.reload();
        });
    }
    else document.getElementById("saveButton").disabled = false;
}












